PROGRAM BumpyObjects;  {Problem A 1990}

#include "str.h"

CONST top = 100;
TYPE  index = 0..top;
      lots_of_points = array[index] of integer;
VAR   thing: string;
      px, py, hx, hy: lots_of_points;
      hull: array[index] of index;
      N, M, start: index;
      x, y, minx, miny, maxx, maxy: integer;
      x0, y0, xc, yc, width, height: integer;
      sf, sf1: real;
      ans: char;

FUNCTION MorePoints: Boolean;
begin MorePoints := (x > 0) and (y > 0) end;

FUNCTION ccw (s, m, e: index): integer;{modified from Sedgewick}
VAR   dx1, dx2, dy1, dy2, cc: integer;

begin
  dx1 := px[m] - px[s];  dy1 := py[m] - py[s];
  dx2 := px[e] - px[s];  dy2 := py[e] - py[s];
  if dx1 * dy2 > dy1 * dx2 then cc := -1;
  if dx1 * dy2 < dy1 * dx2 then cc := +1;
  if dx1 * dy2 = dy1 * dx2 then cc := 0;
  ccw := cc;
end;  {CCW}

PROCEDURE Grahamscan;
VAR   i, j: index;
      x: integer;

begin
  start := 1;
  for i := 2 to N do
    if py[i] < py[start] then start := i;
  for i := 1 to N do
    if (py[i] = py[start]) and (px[i] > px[start]) then start := i;
  hull[1] := start;
  for i := 2 to N do begin
    if start = N
      then start := 1
      else start := start + 1;
    hull[i] := start end;
  hull[0] := N; hull[N + 1] := hull[1]; N := N + 1;
  M := 3; start := 4;
  while ccw(hull[M - 2], hull[M - 1], hull[M]) = 0 do begin
    hull[M - 1] := hull[M]; hull[M] := hull[start]; start := start + 1 end;
  for i := start to N do begin
    while ccw(hull[M - 1], hull[M], hull[i]) >= 0 do M := M - 1;
    M := M + 1; hull[M] := hull[i];
    end;
  end;

PROCEDURE FindPoints;
VAR   x1, y1, x2, y2, a2, b2, c2: integer;
      i, j, k: index;
begin
  readln(xc, yc);
  N := 0; read(x, y);
  minx := x; miny := y;
  maxx := x; maxy := y;
  while MorePoints do begin
    N := N + 1; px[N] := x; py[N] := y;
    if minx > x then minx := x;
    if miny > y then miny := y;
    if maxx < x then maxx := x;
    if maxy < y then maxy := y;
    read(x, y) end;
  readln;
  width := maxx - minx; height := maxy - miny;
  if width > height
    then sf := sf1 / width
    else sf := sf1 / height;
  Grahamscan;

{Now we have the convex hull, the lowest two points that satisfy}
{the stability criterion are the ones we want. Second pt defines line}
  start := 1;
  for i := 2 to M do
    if hull[i] < hull[start] then start := i;
  i := start; k := hull[i];
  x2 := px[k]; y2 := py[k];
  c2 := sqr(x2 - xc) + sqr(y2 - yc);
  repeat
    if i < m
      then i := i + 1
      else i := 1;
    j := k; k := hull[i];
    x1 := x2; y1 := y2;
    x2 := px[k]; y2 := py[k];
    a2 := sqr(x1 - x2) + sqr(y1 - y2);
    b2 := c2;
    c2 := sqr(x2 - xc) + sqr(y2 - yc);
  until sqr(a2) - sqr(b2) - sqr(c2) + 2 * b2 * c2 > 0;
  writeln(thing, ' ':20 - length(thing), k : 2);
  end;

begin
readln(thing);
while thing <> '#' do begin
  FindPoints;
  readln(thing);
  end;
end.
