/* 
 * cat-in-the-hat problem
 * V. Khera 6-NOV-1991
 * 
 * compile with gcc
 */

#include <stdio.h>

#define MAX_N 65535	/* this squared is maximum integer */

/* 
 * determine if num is a power of base.  if so, return the power of 
 * base which num is, that is return k where b^k = n.  if not, then 
 * return 0.  this means that num must not be 1, as this case is 
 * indistinguishable from the real value, 0.
 */
static unsigned int intLog(unsigned int base, unsigned int num)
{
	unsigned int pow = 0;

	if (num == 1) return 0;	/* trivial case. */

	while (num % base == 0) {
		++pow;
		num /= base;
		if (num == 1) return pow;
	}
	return 0;	/* failed */
} /* intLog */

/* raise base to the power pow and return the result */
static unsigned int intExp(unsigned int base, unsigned int pow)
{
	unsigned int retval = 1;

	while (pow--)
		retval *= base;

	return retval;
} /* intExp */


/* 
 * determine the values of the two parameters that constitute the bulk 
 * of this problem, n and k.
 *
 * n^k = workers
 * (n+1)^k = height
 */
void calcParameters(unsigned int h, unsigned int w, unsigned int *ret_n, unsigned int *ret_k)
{
	unsigned int n,k;

	if (w == 1) {	/* intLog will always return 0 */
		*ret_n = h;
		*ret_k = 0;
		return;
	}

	for (n = 2; n < MAX_N; ++n) {
		k = intLog(n,w);
		if (k && intExp(n+1,k) == h) break;
	}

#ifdef DEBUG
	printf("*** n = %u, k = %u\n",n,k);
#endif /* DEBUG */

	*ret_n = n; *ret_k = k;
} /* calcParameters */


/* 
 * determine the sum of the cats heights
 */
unsigned int catHeight(unsigned int n, unsigned int k)
{
	unsigned int sum = 0;
	unsigned int height = intExp(n+1,k);
	unsigned int num = 1;

	while (height > 0) {
		sum += num * height;
		num *= n;
		height /= n+1;
	}

	return sum;
} /* catHeight */

int main(void)
{
	unsigned int height, workers;
	unsigned int lazyCats;
	unsigned int n,k;

	for(;;) {
		scanf("%d %d\n", &height, &workers);
		if (height == 0 && workers == 0) break;

		calcParameters(height, workers, &n, &k);
		if (workers == 1)
			lazyCats = 0;
		else
			lazyCats = (intExp(n,k) - 1) / (n - 1);

		printf("%u %u\n",lazyCats, catHeight(n,k));
	}

	return 0;
}
