/*
 * Author: Paul Ashton
 * Date written: September 13th 1992
 *
 * Files: stdin - team's solution.
 *        progin - input used to produce solution
 *        judgeout - output of judging program where progin was the
 *                   input file.
 *
 * Algorithm: For each table in progin:
 *            1. The table is read in from progin.
 *            2. The judge's and team's solutions are read in.
 *            3. The team's number of exchanges is compared with the
 *               judges.
 *            4. It is checked to see whether the team's set of exchanges
 *               results in a profit of at least 1%
 */

#include <stdio.h>
#include <ctype.h>

#define PROGIN "../../input/e"
#define JUDGEOUT "../../answers/e"

#define MAXD	20    
#define PROFIT  1.01

float table[MAXD][MAXD];
int teamsoln[MAXD+1];

void ReadAnswer();

static char *progname;
int error = 0;
int dimension;	/* the number of countries */
FILE *progin, *judgeout;
int tablenum = 0;

int
ReadTable()
/* return 1 if exchange rates read, 0 otherwise */     
{
    int i,j;
    if (fscanf(progin, "%d\n",&dimension) != 1)
	return 0;
    for(i=0;i<dimension;i++){
	for(j=0;j<dimension;j++){
	    if (i==j){
		table[i][j] = 1.0;
		continue;
	    }
	    fscanf(progin, "%f",&(table[i][j]));
	}
    }
    return 1;
}


main(argc, argv)
        int argc;
        char *argv[];
{
	int minteam, minjudge;
	double arb;
	int i;
	
	progname = argv[0];

	if ((progin = fopen(PROGIN, "r")) == 0) {
		fprintf(stderr, "%s: failed to open %s\n", progname, PROGIN);
		exit(1);
	}
	if ((judgeout = fopen(JUDGEOUT, "r")) == 0) {
		fprintf(stderr, "%s: failed to open %s\n", progname, JUDGEOUT);
		exit(1);
	}

	/* Repeatedly read data sets */
	while (ReadTable()) {
		tablenum++;
		ReadAnswer(stdin, &minteam, teamsoln, "Team");
		ReadAnswer(judgeout, &minjudge, (int *)0, "Judge");

		if (minteam != minjudge) {
			printf(
			  "Team (%d) disagrees with judge (%d) for table %d\n",
			       minteam, minjudge, tablenum);
			error = 1;
			continue;
		}
		if (minteam == 0) {
			continue;
		}
		arb = 1.0;
		for (i = 0 ; i < minteam-1 ; i++) {
			arb = arb * table[teamsoln[i]-1][teamsoln[i+1]-1];
		}
		if (arb <= PROFIT) {
			printf("Team soln for table %d has low profit %f\n",
			       tablenum, arb);
			error = 1;
		}
	}
	CheckEof(stdin, "Team");
	if (!error) {
		printf("Team's solution is correct\n");
	}
}


/*
 * Stores in len: -1 on error, 0 on "no arbitrage sequence exists",
 *                 number of integers put into order otherwise.
 */

        void
ReadAnswer(infile, len, order, name)
        FILE *infile;
        int *len;
        int *order;
        char *name;
{
	char buffer[BUFSIZ];
	char *cp;
	int i, temp;
	int first;

	if (fgets(buffer, sizeof(buffer), infile) == 0) {
		printf("%s: read line failed for file %s on table %i\n",
		       progname, name, tablenum);
		exit(1);
	}
	if (strcmp(buffer, "no arbitrage sequence exists\n") == 0) {
		*len = 0;
		return;
	}

	*len = -1;
	cp = buffer;
	i = 0;
	do {
		temp = ReadInt(&cp, name);
		while (*cp && isspace(*cp)) cp++;
		if (i == 0) {
			first = temp;
		}
		if (order) {
			order[i] = temp;
		}
		i++;
	} while (i <= dimension && *cp);
	if (*cp != '\0') {
		printf("Sequence too long for %s for table %d\n", name,
		       tablenum);
		error = 1;
	} else {
		if (temp != first) {
			printf("First and last currencies differ for %s table %d\n",
			       name, tablenum);
			error = 1;
		} else {
			*len = i;
		}
	}
}

        int
ReadInt(buffp, name)
        char **buffp;
        char *name;
{
	int temp = 0;
	char *cp;

	temp = strtol(*buffp, &cp, 10);
	*buffp = cp;
	if (temp < 1 || temp > dimension) {
		printf("Out of range or missing value in row %d for %s\n",
		       tablenum, name);
		error = 1;
		temp = 1;
	}
	return temp;
}

CheckEof(infile, name)
        FILE *infile;
        char *name;
{
	if (fgetc(infile) != EOF) {
		printf("Trailing garbage after expected EOF for %s\n", name);
		error = 1;
	}
}
