------------------------------------------------------------------------------
--                                                                          --
--                GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS                --
--                                                                          --
--                 S Y S T E M _ T I M E R _ S E R V I C E                  --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                              --
--                    (corresponds to FSU revision 1.1)                     --
--                                                                          --
--           Copyright (c) 1992,1993,1994 FSU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with System.Real_Time; use System.Real_Time;
with Calendar;         use Calendar;

with System.Protected_Objects; use System.Protected_Objects;

package System.Timer_Service is

   --  Implementing a protected type using a single package, to be changed
   --  later when protected types are properly implemented in GNAT ???

   package Signal_Object is
      type O_Type is record
         Object : Protection (Num_Entries => 1);
         Open :   Boolean := False;
      end record;

      procedure Signal (PO : in out O_Type);

      --  9X code:    function Wait_Count return integer;
      --  This is a general purpose function.
      --  This can not be implemented using function in Ada83 because
      --  passing object has to be 'in out' mode (for read_lock in the
      --  body of the function). Therefore we use a procedure instead.

      procedure Wait_Count (PO : in out O_Type; W : out Integer);

      procedure Service_Entries (PO : in out O_Type);
   end Signal_Object;

   package Timer is
      Object : Protection (Num_Entries => 4);

      --  Relative Delays

      type Time_Span_Params is record
         Param : Time_Span;
      end record;

      type Duration_Params is record
         Param : Duration;
      end record;

      --  Absolute Delays

      type Real_Time_Time_Params is record
         Param : Real_Time.Time;
      end record;

      type Calendar_Time_Params is record
         Param : Calendar.Time;
      end record;

      procedure Service (T : out Real_Time.Time);

      procedure Service_Entries;

   end Timer;
end System.Timer_Service;
