------------------------------------------------------------------------------
--                                                                          --
--                GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS                --
--                                                                          --
--                     S Y S T E M . R E A L _ T I M E                      --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.5 $                              --
--                    (corresponds to FSU revision 1.1)                     --
--                                                                          --
--           Copyright (c) 1992,1993,1994 FSU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with System.Clock;             use System.Clock;
with System.Protected_Objects; use System.Protected_Objects;

package System.Real_Time is

   type Time is new Stimespec;

   Time_First : constant Time := Time (Stimespec_First);
   Time_Last  : constant Time := Time (Stimespec_Last);

   type Time_Span is new Stimespec;

   Time_Span_First : constant Time_Span := Time_Span (Stimespec_First);
   Time_Span_Last  : constant Time_Span := Time_Span (Stimespec_Last);
   Time_Span_Zero  : constant Time_Span := Time_Span (Stimespec_Zero);
   Time_Span_Unit  : constant Time_Span := Time_Span (Stimespec_Unit);

   Ticks : constant Time_Span := Time_Span (Stimespec_Ticks);

   Time_Unit : constant := 10#1.0#E-9;

   function Clock return Time;

   function "+"  (Left : Time;      Right : Time_Span) return Time;
   function "+"  (Left : Time_Span; Right : Time)      return Time;
   function "-"  (Left : Time;      Right : Time_Span) return Time;
   function "-"  (Left, Right : Time) return Time_Span;

   function "<"  (Left, Right : Time) return Boolean;
   function "<=" (Left, Right : Time) return Boolean;
   function ">"  (Left, Right : Time) return Boolean;
   function ">=" (Left, Right : Time) return Boolean;

   function "+"  (Left, Right : Time_Span) return Time_Span;
   function "-"  (Left, Right : Time_Span) return Time_Span;
   function "-"  (Right : Time_Span) return Time_Span;

   function "/"  (Left, Right : Time_Span) return Integer;
   function "/"  (Left : Time_Span; Right : Integer)   return Time_Span;
   function "*"  (Left : Time_Span; Right : Integer)   return Time_Span;
   function "*"  (Left : Integer;   Right : Time_Span) return Time_Span;

   function "<"  (Left, Right : Time_Span) return Boolean;
   function "<=" (Left, Right : Time_Span) return Boolean;
   function ">"  (Left, Right : Time_Span) return Boolean;
   function ">=" (Left, Right : Time_Span) return Boolean;

   function "abs" (Right : Time_Span) return Time_Span;

   function To_Duration  (FD : Time_Span) return Duration;
   function To_Time_Span (D  : Duration)  return Time_Span;

   function Nanoseconds  (NS : integer) return Time_Span;
   function Microseconds (US : integer) return Time_Span;
   function Milliseconds (MS : integer) return Time_Span;

   --  Hand translation code will be provided here for now. ???
   --  Until the GNAT compiler can accomodate the protected objects.

   package Delay_Object is
      Object : Protection (Num_Entries => 1);

      type Params is record
         Param : Time_Span;
      end record;

      procedure Service_Entries;
   end Delay_Object;

   type Seconds is new Integer range -Integer'Last .. Integer'Last;
   --  Seconds is signed entity

   procedure Split (T : Time; S : out Seconds; D : out Time_Span);

   function Time_Of (S : Seconds; D : Time_Span) return Time;

end System.Real_Time;
