------------------------------------------------------------------------------
--                                                                          --
--                GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS                --
--                                                                          --
--                S Y S T E M . P T H R E A D _ D E F A U L T S             --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                              --
--                    (corresponds to FSU revision 1.5)                     --
--                                                                          --
--           Copyright (c) 1992,1993,1994 FSU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This package creates predefined values for certain Pthreads types.
--  These are values that cannot be imported from the Pthreads implementation
--  because of a lack of an interface to C constants in this Ada compiler.
--  This package must be initialized by calling Defaults_Init.

with System.Pthreads;

package System.Pthread_Defaults is

   pthread_attr_default      : Pthreads.pthread_attr_t;
   pthread_mutexattr_default : Pthreads.pthread_mutexattr_t;
   pthread_condattr_default  : Pthreads.pthread_condattr_t;

   procedure Init_Defaults;

end System.Pthread_Defaults;
