------------------------------------------------------------------------------
--                                                                          --
--                GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS                --
--                                                                          --
--                    S Y S T E M . P R I M I T I V E S                     --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                              --
--                    (corresponds to FSU revision 1.18)                    --
--                                                                          --
--           Copyright (c) 1992,1993,1994 FSU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with System.Machine_Specifics;
with System.POSIX_RTE;
with System.Pthreads;
with System.Clock;

with Unchecked_Conversion;

package System.Primitives is

   subtype Lock is Pthreads.pthread_mutex_t;

   subtype Condition_Variable is Pthreads.pthread_cond_t;

   type Task_Control_Block is record
      LL_Entry_Point :   Machine_Specifics.Init_State;
      LL_Arg         :   System.Address;
      Thread         :   Pthreads.pthread_t;
      Stack_Size     : Machine_Specifics.Task_Storage_Size;
      Stack_Limit    : System.Address;
   end record;

   type TCB_Ptr is access Task_Control_Block;

   function Address_To_TCB_Ptr is
     new Unchecked_Conversion (System.Address, TCB_Ptr);

   Timer_Signal : constant Machine_Specifics.Interrupt_ID :=
       Machine_Specifics.Interrupt_ID (POSIX_RTE.SIGALRM);

   procedure Initialize_LL_Tasks (T : TCB_Ptr);

   function Self return TCB_Ptr;

   procedure Initialize_Lock (Prio : System.Priority; L : in out Lock);

   procedure Finalize_Lock (L : in out Lock);

   procedure Write_Lock    (L : in out Lock);

   procedure Read_Lock     (L : in out Lock);

   procedure Unlock        (L : in out Lock);

   procedure Initialize_Cond (Cond : in out Condition_Variable);

   procedure Finalize_Cond (Cond : in out Condition_Variable);

   procedure Cond_Wait
     (Cond : in out Condition_Variable;
      L    : in out Lock);

   procedure Cond_Timed_Wait
     (Cond      : in out Condition_Variable;
      L         : in out Lock;
      Abs_Time  : Clock.Stimespec;
      Timed_Out : out Boolean);

   procedure Cond_Signal    (Cond : in out Condition_Variable);

   procedure Cond_Broadcast (Cond : in out Condition_Variable);


   procedure Set_Priority (T : TCB_Ptr; Prio : System.Priority);

   procedure Set_Own_Priority (Prio : System.Priority);

   function Get_Priority (T : TCB_Ptr) return System.Priority;

   function Get_Own_Priority return System.Priority;

   procedure Create_LL_Task
     (Priority       : System.Priority;
      Stack_Size     : Machine_Specifics.Task_Storage_Size;
      LL_Entry_Point : Machine_Specifics.Init_State;
      Arg            : System.Address;
      T              : TCB_Ptr);

   procedure Exit_LL_Task;

   procedure Abort_Task (T : TCB_Ptr);

   procedure Test_Abort;

   type Abort_Handler_Pointer is access
     procedure (Context : Machine_Specifics.Pre_Call_State);

   procedure Install_Abort_Handler (Handler : Abort_Handler_Pointer);

   procedure Install_Error_Handler (Handler : System.Address);

   procedure LL_Assert (B : Boolean; M : String);

end System.Primitives;
