------------------------------------------------------------------------------
--                                                                          --
--                GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS                --
--                                                                          --
--                       S Y S T E M . M A C H I N E                        --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                              --
--                    (corresponds to FSU revision 1.22)                    --
--                                                                          --
--           Copyright (c) 1992,1993,1994 FSU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with System.Machine_Specifics;
with System.Task_IDs;

package System.Machine is

   Task_Wrapper_Frame : constant Integer := 72;
   --  This is the size of the frame for the Pthread_Wrapper procedure.

   type Proc is access procedure (Addr : System.Address);

   procedure Task_Wrapper (Arg : System.Address);

   procedure Test_And_Set (Flag_Add : System.Address; Result : out Boolean);

   --  This wrapper sets up an Ada environment within a new thread and calls
   --  the task body code within it.

   type Block_Size is new Integer range 2#1#E5 .. 2#1#E30;
   type Block_Lists_Index is new Integer range 5 .. 31;
   subtype Integer_Exponent is Block_Lists_Index range 5 .. 30;
   --  Memory management types and operations. Here for speed.

   function Exp_2 (arg : Integer_Exponent) return Block_Size;
   pragma Interface (C, Exp_2);

   function Bit_XOR (l, r : Integer) return Integer;
   pragma Interface (C, Bit_XOR);

end System.Machine;
