------------------------------------------------------------------------------
--                                                                          --
--                GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS                --
--                                                                          --
--           S Y S T E M . C O M P I L E R _ E X C E P T I O N S            --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                              --
--                    (corresponds to FSU revision 1.22)                    --
--                                                                          --
--           Copyright (c) 1992,1993,1994 FSU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with System.Machine_Specifics;
with Unchecked_Conversion;

package System.Compiler_Exceptions is

   type Exception_ID is new Integer;
   --  This was System.Address; this is to keep GNAT happy.  It probably
   --  doesn't work, but then this package doesn't do anything under GNAT yet.

   function Int_To_Exception is
     new Unchecked_Conversion (Integer, Exception_ID);

   Null_Exception : constant Exception_ID := Int_To_Exception (0);

   Constraint_Error_ID : Exception_ID;
   Numeric_Error_ID    : Exception_ID;
   Program_Error_ID    : Exception_ID;
   Storage_Error_ID    : Exception_ID;
   Tasking_Error_ID    : Exception_ID;

   procedure Raise_Exception (E : Exception_ID);

   procedure Notify_Exception
     (Which              : Machine_Specifics.Machine_Exceptions;
      Info               : Machine_Specifics.Error_Information;
      Modified_Registers : Machine_Specifics.Pre_Call_State);

   function Current_Exception return Exception_ID;

   subtype Exception_ID_String is String (1 .. 16);

   function Image (E : Exception_ID) return Exception_ID_String;

end System.Compiler_Exceptions;
