------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                     A D A . N U M E R I C S . A U X                      --
--                                                                          --
--                                 S p e c                                  --
--                           (C Library Version)                            --
--                                                                          --
--                            $Revision: 1.2 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This package provides the basic computational interface for the generic
--  elementary functions. The C library version interfaces with the routines
--  in the C mathematical library, and is thus quite portable, although it may
--  not necessarily meet the requirements for accuracy in the numerics annex.
--  One advantage of using this package is that it will interface directly to
--  hardware instructions, such as the those provided on the Intel 80x87.

package Ada.Numerics.Aux is

   subtype Double is Long_Float; -- implementation dependent

   function Sin (X : Double) return Double;
   pragma interface (C, Sin);
   pragma interface_name (Sin, "sin");

   function Cos (X : Double) return Double;
   pragma interface (C, Cos);

   function Tan (X : Double) return Double;
   pragma interface (C, Tan);

   function Exp (X : Double) return Double;
   pragma interface (C, Exp);

   function Sqrt (X : Double) return Double;
   pragma interface (C, Sqrt);

   function Log (X : Double) return Double;
   pragma interface (C, Log);

   function Acos (X : Double) return Double;
   pragma interface (C, Acos);

   function Asin (X : Double) return Double;
   pragma interface (C, Asin);

   function Atan (X : Double) return Double;
   pragma interface (C, Atan);

   function Sinh (X : Double) return Double;
   pragma interface (C, Sinh);

   function Cosh (X : Double) return Double;
   pragma interface (C, Cosh);

   function Tanh (X : Double) return Double;
   pragma interface (C, Tanh);

   function Pow (X, Y : Double) return Double;
   pragma interface (C, Pow);

end Ada.Numerics.Aux;
