------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                     A D A . C A L E N D A R . A U X                      --
--                                                                          --
--                                 B o d y                                  --
--                            (ANSI C Version)                              --
--                                                                          --
--                            $Revision: 1.4 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This version of the package uses the standard Unix function clock to
--  implement Clock_Read, which is not very accurate, it gives only seconds,
--  but it is almost completely universally implemented.

package body Ada.Calendar.Aux is

   ----------------
   -- Clock_Read --
   ----------------

   function Clock_Read return Time is

      subtype clock_t is Long_Integer;

      function clock_ return clock_t;
      pragma Import (C, clock_, "clock");

   begin
      return (Val => Duration (clock_));
   end Clock_Read;

end Ada.Calendar.Aux;
