#ifndef lint
static char *rcsid = "$Header: /usr/src/local/xldial/RCS/xllog.c,v 1.1 1994/01/24 09:13:08 root Exp root $";
#endif


/*
 * $Log: xllog.c,v $
 * Revision 1.1  1994/01/24  09:13:08  root
 * Initial revision
 *
 * Revision 1.6  93/07/03  15:44:09  chech
 *    :-)
 * 
 * Revision 1.5  92/09/11  17:14:28  chech
 * *** empty log message ***
 * 
 * Revision 1.4  92/08/16  20:04:25  chech
 * version for multislip
 * 
 * Revision 1.3  92/05/27  20:42:21  olg
 * Fixed bug with line params having not been set
 * properly in sllog.c
 * 
 * Revision 1.2  1992/03/30  17:03:06  olg
 * Changes to work with new routed policy
 * (wait GARBAGE_TIME - EXPIRE_TIME before
 * releasing interface)
 *
 * Revision 1.1  1992/03/26  01:09:35  olg
 * Initial revision
 *
 *
 */

#include "defs.h"

#include <time.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/termios.h>
#include <sys/file.h>
extern char *sys_errlist[];

#define DIALIN
#include "readcf.c"

FILE *ftrace;
struct termios term;
char *progname;
char *id;
char *ttyline;
int sock;
pid_t pid;

void hangup (), cleanup (), keepalive ();
char *ctime ();
char *ttyname ();
char *getlogin ();

main (argc, argv)
	char *argv[];
{
	extern int cfline;
	int i;
	register struct sldialup *slp;
	char name [IFNAMSIZ];

	progname = *argv;
	pid = getpid ();
	id = getlogin();
	if ((ftrace = fopen (LOGIN, "a")) == NULL)
	    exit (2);
	if ((slp = readcflog (CONFIG, id, 1)) == NULL) {
	    if (cfline == -1)
		panic ("can't open config file: %s: ", CONFIG, 1);
	  else if (cfline == 0) 
		panic ("id: %s not found (or don't allowed for this time)", id, 1);
	  else 
		panic ("parse error at line: %d", cfline, 1);
	}

	signal (SIGHUP, hangup);
	signal (SIGTERM, cleanup);
	signal (SIGQUIT, cleanup);
	signal (SIGUSR1, keepalive);

	ttyline = ttyname (NULL);
	log ("login on line %s", ttyline);
	if (ioctl(0, TIOCGETA, &term) < 0) 
	    panic ("unable to get line params", NULL, 1);
	term.c_cflag = CS8 | CREAD | HUPCL | CRTSCTS;
	term.c_iflag = 0;
	term.c_oflag = 0;
	term.c_lflag = 0;
	term.c_cc[VMIN] = 1;
	term.c_cc[VTIME] = 0;
	if (ioctl(0, TIOCSETA, &term) < 0) 
	    panic ("unable to set line parameters", NULL, 1);
	i = SLIPDISC;
	if (ioctl(0, TIOCSETD,&i) < 0)
	    panic ("unable to set SLIP line disc", NULL, 1);

        if (slp->sl_unit < 0 || slp->sl_unit > 64)
	    panic ("invalid interface: sl%d", slp->sl_unit, 2);
	if (ioctl (0, SLIOCATTACH, &slp->sl_unit) < 0)
	    panic ("SLIOCATTACH failed", NULL, 1);

	if (ioctl(0, SLIOCGUNIT, &i) < 0)
	    panic ("SLIOCGUNIT failed", NULL, 1);
	if (i != slp->sl_unit)
	    panic ("failed to attach to unit: %d got %d", slp->sl_unit, i);
        sprintf (name, "sl%d", slp->sl_unit);

	if (slp -> sl_mtu) {
	    if (ioctl (0, SLIOCSETMTU, &(slp -> sl_mtu)) < 0)
		log ("SLIOCSETMTU to %d failed: %s",
			    slp -> sl_mtu, sys_errlist[errno], 0);
	    if (ioctl (0, SLIOCGETMTU, &i) < 0)
		panic ("SLIOCGETMTU failed", NULL, 1);
	    log ("use max transfer unit mtu=%d", i, 0, 0);
	}
	if (slp->sl_outfill) {
	    if (ioctl(0, SLIOCSOUTFILL, &slp->sl_outfill) < 0)
		panic ("SLIOCSOUTFILL failed", NULL, 1);
	    log ("out is filled (%d sec)", slp->sl_outfill, 0, 0);
	}
	if (slp->sl_keepal) {
	    if (slp->sl_waiting) {
		struct sl_attach sl;

		log ("waiting %d keepalives per %d sec",
				slp->sl_waiting, slp->sl_keepal, 0);
		sl.sl_keep = slp->sl_keepal;
		sl.sl_cnt = slp->sl_waiting;
		if (ioctl(0, SLIOCWAIT, &sl) < 0) {
		    if (errno == ETIMEDOUT)
			panic ("no keepalives ??", NULL, 1);
		    panic ("SLIOCWAIT failed", NULL, 1);
		}
	    }
	    if (ioctl(0, SLIOCSKEEPAL, &slp->sl_keepal) < 0)
		panic ("SLIOCSKEEPAL failed", NULL, 1);
	    log ("input is checked (%d sec)", slp->sl_keepal, 0, 0);
	}

	if ((sock = socket(AF_INET, SOCK_DGRAM, 0)) < 0) 
	    panic ("socket", NULL, 1);
	if_up (name, &slp->sl_src, &slp->sl_dst, &slp->sl_netmask,
		     slp->sl_setmode, slp->sl_clrmode);
	log ("attach successful name=\"%s\"", name);
	pause ();
	log ("link from \"%s\" terminated by unknown reazon, errno=%d", ttyline, errno);
	exit (0);
}

void hangup (sig)
{
	signal (sig, SIG_IGN);
	log ("link from \"%s\" terminated by signal %d", ttyline, sig);
	signal (sig, hangup);
	return;
}

void keepalive (sig) 
{
    signal (sig, SIG_IGN);
    log ("keepalive timeout, terminating ...", 0, 0, 0);
    signal (sig, keepalive);
    return;
}

void cleanup (sig)
{
	signal (sig, SIG_IGN);
	log ("link from \"%s\" terminated by signal %d", ttyline, sig);
	exit (2);
}

panic (fmt, arg, exitcode)
char   *fmt,
       *arg;
{
    time_t tm;
    char   *s;

    time (&tm);
    s = ctime (&tm) + 4;
    s[strlen (s) - (1 + 5)] = '\0';
    fprintf (ftrace, "%s: id=%s pid=%05d (%s) ", progname, id, pid, s);
    fprintf (ftrace, fmt, arg);
    fprintf (ftrace, ": %s\n", sys_errlist[errno]);
    fclose (ftrace);
    exit (exitcode);
}

log (fmt, arg1, arg2, arg3)
char   *fmt, *arg1, *arg2, *arg3;
{
    time_t tm;
    char   *s;

    time (&tm);
    s = ctime (&tm) + 4;
    s[strlen (s) - (1 + 5)] = '\0';
    fprintf (ftrace, "%s: id=%s pid=%05d (%s) ", progname, id, pid, s);
    fprintf (ftrace, fmt, arg1, arg2, arg3);
    fprintf (ftrace, "\n");
    fflush (ftrace);
}

