#ifndef lint
static char *dummy = "$Header: readcf.c,v 1.3 93/07/03 15:44:05 chech Exp $";
#endif


/*
 * $Log:	readcf.c,v $
 * Revision 1.3  93/07/03  15:44:05  chech
 *    :-)
 * 
 * Revision 1.2  92/08/16  20:04:23  chech
 * version for multislip
 * 
 * Revision 1.1  1992/03/26  01:09:29  olg
 * Initial revision
 *
 *
 */

#include "defs.h"
#include <ctype.h>
#include <string.h>
#include <time.h>



#define	NEXT_TOKEN	strtok(NULL," \t")
int cfline;
char error [MAXCFLINE];

#ifdef MAIN
#define DEBUG
#define DIALOUT

main (ac, av) char **av; {
    char *progname;
    char *id;
    struct sldialup *slp;

    progname = *av++;
    id = *av++;

    error [0] = '\0';
    slp = readcfdial (CONFIG, id);
    if (slp == NULL) {
	printf ("%s: %s\n", progname, error);
	exit (1);
    }
    else if (error [0]) {
	printf ("%s: last warning: %s\n", progname, error);
	error [0] = '\0';
    }

    printf ("-------ALL LIST----------------\n");
    for (slp; slp; slp = slp -> sl_nextp) {
	printf ("%s -> %s\n", slp -> sl_id, slp -> sl_nextid);
	sleep (3);
    }
}

log (fmt, arg1, arg2, arg3)
char   *fmt, *arg1, *arg2, *arg3;
{
    time_t tm;
    char   *s;

    time (&tm);
    s = ctime (&tm) + 4;
    s[strlen (s) - (1 + 5)] = '\0';
    printf (fmt, arg1, arg2, arg3);
    printf ("\n");
}
#endif

#ifdef DIALOUT
/*
 * Read config file and fill "dialup" structure for
 * "id" site return pointer to sldialup structure.
 * If no line for matching "id" found or parse error occure 
 * return NULL.
 *
 *	struct sldialup *readcf (file, id)
 *	  char *file - pathname of config file
 *	  char *id   - id to match in first field of config line
 *	RETURN
 *	  NULL - failed to retrieve data from config file, or
 *               id not found. In this case, global char array
 *               "error" determine cause of error.
 *                if (error [0] == 0)   - "id" not found
 *                else                  printf (error);
 *	  != NULL - pointer to "id" "sldialup" structure 
 */

struct sldialup *
readcfdial (file, id)
register char *id, *file;
{
    register struct sldialup *slp;
    static struct sldialup *list = NULL;

    error [0] = '\0';
    if (list == NULL && readcfall (file, &list))
	return NULL;
    for (slp = list; slp; slp = slp -> sl_cont)
	if (! strcmp (slp -> sl_id, id))
	    break;
    return slp;
}

readcfall (file, sllist)
struct sldialup **sllist;
char *file;
{
    register char *cp;
    register struct sldialup *slp, *prv;
    struct sldialup sldial;
    FILE *fd;
    char *p, line[MAXCFLINE], s[40], *getline ();
    int first;

    if ((fd = fopen (file, "r")) == NULL) {
	sprintf (error, "can't open file %s (errno %d)", file, errno);
	return -1;
    }
    first = 0;
    cfline = 0;
    while (cp = getline (line, MAXCFLINE, fd)) {
	memset((char *) &sldial, 0, sizeof(sldial));
	cp = strtok (cp, " \t");
	if ( strcmp(cp,"ALL") == 0 ) continue;
	sldial.sl_cfline = cfline;
	strncpy (sldial.sl_id, cp, sizeof (sldial.sl_id));
	cp = NEXT_TOKEN;
	if (*cp == 's' && *(cp+1) == 'l')
	      sldial.sl_unit = atoi (cp + 2);
	else {
	    log ("(file %s): parse error at field INTERFACE, line %d ignored",
	    file, cfline,0);
	    continue;
	}
	if ((cp = NEXT_TOKEN) == NULL || getiaddr (cp, &sldial.sl_dst, 0)) {
	    log ("(file %s): parse error at field DST, line %d ignored",
	    file, cfline,0);
	    continue;
	}
	if ((cp = NEXT_TOKEN) == NULL || getiaddr (cp, &sldial.sl_src, 0)) {
	    log ("(file %s): parse error at field SRC, line %d ignored",
	    file, cfline,0);
	    continue;
	}
	if ((cp = NEXT_TOKEN) == NULL || getiaddr (cp, &sldial.sl_netmask, -1)) {
	    log ("(file %s): parse error at field NETMASK, line %d ignored",
	    file, cfline,0);
	    continue;
	}
	if ((cp = NEXT_TOKEN) == NULL || getmode (cp, &sldial, 0)) {
	    log ("(file %s): parse error at field MODE, line %d ignored",
	    file, cfline,0);
	    continue;
	}
	if ((cp = NEXT_TOKEN) == NULL)  /* dialin line */
	    continue;

	strncpy (sldial.sl_dialer, cp, sizeof (sldial.sl_dialer));
	if ((cp = NEXT_TOKEN) == NULL)  {
	    log ("(file %s): parse error at field TTY, line %d ignored",
	    file, cfline,0);
	    continue;
	}
	if (*cp != '/') {
	  sprintf (s, "/dev/%s", cp);
	  strncpy (sldial.sl_line, s, sizeof (sldial.sl_line));
	} else
	  strncpy (sldial.sl_line, cp, sizeof (sldial.sl_line));
	if ((cp = NEXT_TOKEN) == NULL)  {
	    log ("(file %s): parse error at field SPEED, line %d ignored",
	    file, cfline,0);
	    continue;
	}
	strncpy (sldial.sl_speed, cp, sizeof (sldial.sl_speed));
	if ((cp = NEXT_TOKEN) == NULL)  {
	    log ("(file %s): parse error at field PHONE, line %d ignored",
	    file, cfline,0);
	    continue;
	}
	strncpy (sldial.sl_phone, cp, sizeof (sldial.sl_phone));
	if ((cp = NEXT_TOKEN) == NULL)  {
	    log ("(file %s): parse error at field SCRIPT, line %d ignored",
	    file, cfline,0);
	    continue;
	}
	strncpy (sldial.sl_chat, cp + strlen (cp) + 1, sizeof (sldial.sl_chat) - 1);
	sldial.sl_chat[sizeof (sldial.sl_chat) - 1] = '\0';

	if (p = strchr (cp, '/')) {
	  *p++ = '\0';
	  strncpy (sldial.sl_nextid, p, sizeof (sldial.sl_nextid));
	}
	sldial.sl_retries = atoi (cp);
	if ((slp = (struct sldialup *)malloc (sizeof (struct sldialup))) == NULL) {
	    sprintf (error, "(file %s): can't alloc memory for line %d",
	    file, cfline);
	    fclose (fd);
	    return -1;
	}
	*slp = sldial;
	slp -> sl_cont = NULL;
	if (first == 0) {
	    first++;
	    *sllist = slp;
	}
	else
	    prv -> sl_cont = slp;
	prv = slp;
    }

/*   next-id */
    for (slp = *sllist; slp; slp = slp -> sl_cont) {
	if (slp -> sl_nextid [0]) {
	    for (prv = *sllist; prv; prv = prv -> sl_cont) {
		if (! strcmp (slp -> sl_nextid, prv -> sl_id)) {
		    slp -> sl_nextp = prv;
		    break;
		}
	    }
	    if (slp -> sl_nextp == NULL) {
		log ("(file %s): unknown next id \"%s\" (line %d)",
		file, slp -> sl_nextid, slp -> sl_cfline);
		fclose (fd);
		break;
	    }
	}
    }
    fclose (fd);
    return (0);
} 
#endif

#ifdef DIALIN
/*
 * Read config file and fill "dialup" structure for
 * "id" site return pointer to sldialup structure.
 * If no line for matching "id" found or parse error occure 
 * return NULL.
 *
 *	struct sldialup *readcf (file, id)
 *	  char *file - pathname of config file
 *	  char *id   - id to match in first field of config line
 *	RETURN
 *	  NULL - failed to retrieve data from config file, or
 *		 id not found. In this case, global variable
 *		 "cfline" determine cause of error.
 *                  cfline = -1  - can not open config file
 *                         = 0   - "id" not found
 *                         > 0   - parse error at line "cfline"
 *	  != NULL - pointer to "id" "sldialup" structure 
 */

struct sldialup *
readcflog (file, id)
char *file, *id;
{
    FILE *fd;
    register char *cp;
    register struct sldialup *slp;
    static struct sldialup dialinfo;
    char *getline ();
    char line[MAXCFLINE];

    cfline = -1;
    slp = &dialinfo;
    if ((fd = fopen (file, "r")) == NULL)
	return NULL;    /* can't open file */
    cfline++;
    while (cp = getline (line, MAXCFLINE, fd)) {
	cp = strtok (cp, " \t");
	if (strncmp (cp, id, sizeof (slp->sl_id)))  continue;
	strncpy (slp->sl_id, cp, sizeof (slp->sl_id));
	cp = NEXT_TOKEN;
	if (*cp == 's' && *(cp+1) == 'l')
	      slp->sl_unit = atoi (cp + 2);
	else
	      return NULL;
	cp = NEXT_TOKEN; if (getiaddr (cp, &slp->sl_dst, 0))        return NULL;
	cp = NEXT_TOKEN; if (getiaddr (cp, &slp->sl_src, 0))        return NULL;
	cp = NEXT_TOKEN; if (getiaddr (cp, &slp->sl_netmask, -1))   return NULL;
	cp = NEXT_TOKEN; if (getmode (cp, slp, 1))                  return NULL;
#ifdef NOTDEF
	/* ,     */
	cp = NEXT_TOKEN; if ( cp && cp[0] && ifdate(cp) == 0 )
	{
	       log("User %s don't allow in this time. ",cp,id);
	       printf("You (%s) can'not work now. Log-in later\nYou time is: %s\n",id,cp);
	       fflush(stdout);
	       cfline = 0;
	       return NULL;
	}
#endif
	return (slp);
    }
    cfline = 0;
    return NULL;
} 
#endif

getiaddr (cp, sin, mask)
	register char *cp;
	register struct sockaddr_in *sin;
{
	register struct hostent *hp;
	struct netent  *np;

	if (cp == NULL)
	  return 1;
	if (! mask)
	    sin -> sin_family = AF_INET;
	sin -> sin_len = sizeof (*sin);
	if ((mask = inet_addr (cp)) != -1)
	    sin -> sin_addr.s_addr = mask;
	else if (hp = gethostbyname (cp))
	    bcopy (hp -> h_addr, (caddr_t) & sin -> sin_addr, hp -> h_length);
	else if (np = getnetbyname (cp))
	    sin -> sin_addr.s_addr = inet_makeaddr (np -> n_net, INADDR_ANY);
	else
	    return 1;
	return 0;
}

getmode (cp, slp, login)
register char  *cp;
struct sldialup *slp;
{
#define SETMODE(x)  slp -> sl_setmode |= (x)
#define CLRMODE(x)  slp -> sl_clrmode |= (x)
#ifndef SC_NOICMP
#define SC_NOICMP   0
#endif

    register char *p;
    int l, brk;

    slp -> sl_setmode = slp -> sl_clrmode = 0;
    slp -> sl_mtu = slp -> sl_keepal = slp -> sl_outfill = 0;

    if (cp == NULL && *cp == '\0')
	return 1;

    for (p = cp, brk = 0;; p++) {
	if (*p == '\0')
	    brk++;
	else if (*p != ',')
	    continue;
	*p = '\0';
	l = strlen (cp);
	if (! strcmp (cp, "-") || (! strcmp (cp, "+"))) ;
	else if (! strncmp (cp, "+lockcomp", l)) SETMODE (SC_COMPRESS);
	else if (! strncmp (cp, "+autocomp", l)) SETMODE (SC_AUTOCOMP);
	else if (! strncmp (cp, "+noicmp",   l)) SETMODE (SC_NOICMP);
	else if (! strncmp (cp, "+bpf",      l)) SETMODE (SC_BPFILTER);
	else if (! strncmp (cp, "+outfill",  l)) slp -> sl_outfill = 1;
	else if (! strncmp (cp, "+intest",   l)) slp -> sl_keepal = 90;
	else if (! strncmp (cp, "+waiting",  l)) slp -> sl_waiting = 1;
	else if (! strncmp (cp, "-lockcomp", l)) CLRMODE (SC_COMPRESS);
	else if (! strncmp (cp, "-autocomp", l)) CLRMODE (SC_AUTOCOMP);
	else if (! strncmp (cp, "-bpf",      l)) CLRMODE (SC_BPFILTER);
	else if (! strncmp (cp, "-noicmp",   l)) CLRMODE (SC_NOICMP);
	else if (! strncmp (cp, "-outfill",  l)) slp -> sl_outfill = 0;
	else if (! strncmp (cp, "-intest",   l)) slp -> sl_keepal = 0;
	else if (! strncmp (cp, "-waiting",  l)) slp -> sl_waiting = 0;

	else if (! strncmp (cp, "+extcomp", l)) {
	    if (login) {    CLRMODE (SC_COMPRESS); SETMODE (SC_AUTOCOMP); }
	    else       {    SETMODE (SC_COMPRESS); }
	}
	else if (! strncmp (cp, "-extcomp", l)) {
	    if (login) {    CLRMODE (SC_COMPRESS); SETMODE (SC_AUTOCOMP); }
	    else       {    CLRMODE (SC_COMPRESS); }
	}
	else if (! strncmp (cp, "mtu=", sizeof("mtu=") - 1))
	    slp -> sl_mtu = atoi (cp + sizeof("mtu=") - 1);
	else if (! strncmp (cp, "keepal=", sizeof("keepal=") - 1))
	    slp -> sl_keepal = atoi (cp + sizeof("keepal=") - 1);
	else if (! strncmp (cp, "outfill=", sizeof("outfill=") - 1))
	    slp -> sl_outfill = atoi (cp + sizeof("outfill=") - 1);
	else if (! strncmp (cp, "wait=", sizeof("wait=") - 1))
	    slp -> sl_waiting = atoi (cp + sizeof("wait=") - 1);

/* cludge for MULTICAST bug's in BSD 1.1 & gated */
	else if (! strncmp (cp, "+multicast",l)) SETMODE (IFF_MULTICAST);
	else if (! strncmp (cp, "-multicast",l)) CLRMODE (IFF_MULTICAST);

	else
	    return 1;
	cp = p + 1;
	if (brk)
	    break;
    }
    return 0;
}

char *
getline (l, size, f)
register char *l;
register FILE *f;
{
    register char *p;

    do {
	for (p = l; ;p += strlen (p) - 1) {
	    if (fgets (p, size, f) == NULL)
		return NULL;
	    cfline++;
	    p [strlen (p) - 1] = '\0';
	    if (p [strlen (p) - 1] != '\\')
		break;
	}
    } while (*l == '#' || *l == ' ' || *l == '\t' ||
	     *l == '\0' || *l == '\n' || *l == '\r') ;
    return l;
}

/*
 *       .      .
 */
ifdate(p)
register char *p;
{
	register char *np;
	register int ret, g;
	int rtime, i;
	/*     == Never */
	if (p[0] == '-' && p[1] == 0 ) return(0);
	ret = 0;
	do {
		np = strpbrk(p, ",|");	/* prefer , but allow | for compat */
		if (np)
			*np = '\0';
		g = ifadate(p);
		if (g != 0) {
			ret = 1;
		}
		if (np)
			*np = ',';
		p = np + 1;
	} while (np);
	return ret;
}
/*        BSD UUCP.
 *	this routine will check a string (string)
 *	like "MoTu0800-1730" to see if the present
 *	time is within the given limits.
 *	SIDE EFFECT - Retrytime is set
 *
 *	return codes:
 *		0  -  not within limits
 *		1  -  within limits
 */

ifadate(string)
char *string;
{
	static char *days[]={
		"Su", "Mo", "Tu", "We", "Th", "Fr", "Sa", 0
	};
	time_t clock;
	register char *s = string;
	int i, tl, th, tn, dayok=0;
	struct tm *localtime();
	struct tm *tp;
	char *p;

	time(&clock);
	tp = localtime(&clock);
	while (isascii(*s) && isalpha(*s)) {
		for (i = 0; days[i]; i++) {
			if (prefix(days[i], s))
				if (tp->tm_wday == i)
					dayok = 1;
		}

		if (prefix("Wk", s))
			if (tp->tm_wday >= 1 && tp->tm_wday <= 5)
				dayok = 1;
		if (prefix("Any", s))
			dayok = 1;
		if (prefix("Evening", s)) {
			/* Sat or Sun */
			if (tp->tm_wday == 6 || tp->tm_wday == 0
				|| tp->tm_hour >= 17 || tp->tm_hour < 8)
					dayok = 1;
		}
		if (prefix("Night", s)) {
			if (tp->tm_wday == 6  /* Sat */
				|| tp->tm_hour >= 23 || tp->tm_hour < 8
					/* Sunday before 5pm */
				|| (tp->tm_wday == 0 && tp->tm_hour < 17))
					dayok = 1;
		}
		if (prefix("NonPeak", s)) { /* For Tymnet and PC Pursuit */
			/* Sat or Sun */
			if (tp->tm_wday == 6 || tp->tm_wday == 0
				|| tp->tm_hour >= 18 || tp->tm_hour < 7)
					dayok = 1;
		}
		s++;
	}

	if (dayok == 0 && s != string)
		return 0;
	i = sscanf(s, "%d-%d", &tl, &th);
  	if (i < 2)
		return 1;
	tn = tp->tm_hour * 100 + tp->tm_min;
  	if (th < tl) { 		/* crosses midnight */
  		if (tl <= tn || tn < th)
			return 1;
  	} else {
		if (tl <= tn && tn < th)
			return 1;
	}
	return 0;
}

/*
 *	check s2 for prefix s1
 *
 *	return 0 - !=
 *	return 1 - == 
 */

prefix(s1, s2)
register char *s1, *s2;
{
	register char c;

	while ((c = *s1++) == *s2++)
		if (c == '\0')
			return 1;
	return c == '\0';
}
