/*
 * ntpq.h - definitions of interest to ntpq
 */

/*
 * Maximum number of arguments
 */
#define	MAXARGS	4

/*
 * xntpdc includes a command parser which could charitably be called
 * crude.  The following structure is used to define the command
 * syntax.
 */
struct xcmd {
	char *keyword;		/* command key word */
	void (*handler)();	/* command handler */
	u_char arg[MAXARGS];	/* descriptors for arguments */
	char *desc[MAXARGS];	/* descriptions for arguments */
	char *comment;
};


/*
 * Flags for forming descriptors.
 */
#define	OPT	0x80		/* this argument is optional, or'd with type */

#define	NO	0x0
#define	STR	0x1		/* string argument */
#define	UINT	0x2		/* unsigned integer */
#define	INT	0x3		/* signed integer */
#define	ADD	0x4		/* IP network address */

/*
 * Arguments are returned in a union
 */
typedef union {
	char *string;
	long ival;
	u_long uval;
	u_long netnum;
} arg_v;


/*
 * Structure for passing parsed command line
 */
struct parse {
	char *keyword;
	arg_v argval[MAXARGS];
	int nargs;
};


/*
 * Types of things we may deal with
 */
#define	TYPE_SYS	1
#define	TYPE_PEER	2
#define	TYPE_CLOCK	3


/*
 * Structure to hold association data
 */
struct association {
	u_short assid;
	u_short status;
};

#define	MAXASSOC	1024
