/*
 * gettstamp - return the system time in timestamp format
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "ntp_fp.h"
#include "ntp_unixtime.h"

/*
 * Reference to conversion table
 */
extern u_long ustotslo[];
extern u_long ustotsmid[];
extern u_long ustotshi[];

void
gettstamp(ts)
	l_fp *ts;
{
	struct timeval tv;

	/*
	 * Quickly get the time of day and convert it
	 */
	(void) gettimeofday(&tv, (struct timezone *)NULL);
	TVTOTS(&tv, ts);
	ts->l_uf += TS_ROUNDBIT;	/* guaranteed not to overflow */
	ts->l_ui += JAN_1970;
	ts->l_uf &= TS_MASK;
}
