/*	thunk32.c   	main source for 32 bit Win32s exe that loads the UT dll's   
			linked with ut32.lib */

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include "thunk32.h"
#include "ut32.h"

int WINAPI WinMain (HANDLE hInstance,HANDLE hPrevInstance,  //standard window setup
		    LPSTR lpCmdLine, int nCmdShow)
{ MSG msg;
  if (!hPrevInstance)
  {
    WNDCLASS wc;
    wc.style         = 0;
    wc.lpfnWndProc   = (WNDPROC)MainWndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = hInstance;
    wc.hIcon         = LoadIcon(hInstance, "Thunk32Icon");
    wc.hCursor       = LoadCursor (NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject (WHITE_BRUSH);
    wc.lpszMenuName  = (LPCTSTR) "Menu";
    wc.lpszClassName = (LPCTSTR) "Thunk32";

    if (!RegisterClass (&wc))
    {
      MessageBox (NULL, (LPCTSTR) "WinMain(): RegisterClass() failed",
		  (LPCTSTR) "Err! - Thunk32", MB_OK | MB_ICONEXCLAMATION);
      return(FALSE);
    }
  }

  if (!(ghwndMain = CreateWindow ("Thunk32",
				  "Thunk32",
				  WS_OVERLAPPEDWINDOW,
				  CW_USEDEFAULT, CW_USEDEFAULT,
				  CW_USEDEFAULT, CW_USEDEFAULT,
				  NULL, NULL, hInstance, NULL)))
    return (0);

  ShowWindow (ghwndMain, nCmdShow);

  while (GetMessage (&msg, NULL, 0, 0))
  {
    TranslateMessage (&msg);
    DispatchMessage  (&msg);
  }

  return (msg.wParam);
}

LRESULT CALLBACK MainWndProc (HWND hwnd, UINT message, WPARAM wParam, //standard message handling
			      LPARAM lParam)
{               
	static long Data1[SIZE]={300,100};
	long AddResult, SubResult, MultResult, DivResult;
	static char buffer[256]={0};
	static char title[128] ={0};
	static char temp[128]={0};

	switch (message)
  	{
		case WM_COMMAND:

      		switch (LOWORD(wParam))
      		{

			case IDM_VERSION:
			bUnder31=((DWORD)GetVersion() & 0x80000000);
			if (bUnder31)
	  			MessageBox (ghwndMain, (LPCTSTR) "Running Under Win 3.1 Win32s- Thunking available", 
				(LPCSTR) "WIN32 version", MB_OK); 
			else 
	  			MessageBox (ghwndMain, (LPCTSTR) "Running Under Windows NT- Thunking not available",
				(LPCSTR) "WIN32 version", MB_OK);
	 		break;

			case IDM_THUNK16:

	  		MessageBox(ghwndMain, (LPCSTR) "Thunking 32 -> 16, Operands are 100 and 300", (LPCSTR) "Call 16 bit DLL", MB_OK);
			AddResult=(long) AddTwo(Data1);
			SubResult=(long) SubTwo(Data1);
			MultResult=(long) MultTwo(Data1);
	  		DivResult=(long) DivTwo(Data1);
			strcpy(buffer, "Answers are : \n");
			wsprintf(temp, "Addition= %ld\n Subtraction= %ld\n Multiplication = %ld\n Division = %ld\n", AddResult, SubResult, MultResult, DivResult);    
	  		strcat(buffer, temp);
	  		MessageBox(ghwndMain, buffer, "Call 32 -> 16 Thunk", MB_OK);           
			break;

			case IDM_32DLL:
	  
	  		MessageBox (ghwndMain, (LPCTSTR) "Win32 DLL Function called\n Operands are 100 and 300", (LPCSTR) "Call 32 bit DLL", MB_OK);
	  		AddResult=(long) AddTwoDLL32(Data1);
	  		SubResult=(long) SubTwoDLL32(Data1);
	  		MultResult=(long) MultTwoDLL32(Data1);
	  		DivResult=(long) DivTwoDLL32(Data1);
	  		strcpy(buffer, "Answers are : \n");
	  		wsprintf(temp, "Addition= %ld\n Subtraction= %ld\n Multiplication = %ld\n Division = %ld\n", AddResult, SubResult, MultResult, DivResult);    
	  		strcat(buffer, temp);
	  		MessageBox (ghwndMain, buffer, (LPCSTR) "Call 32 bit DLL", MB_OK);
			break;

			case IDM_ABOUT:

	 		MessageBox (ghwndMain, (LPCTSTR) "            Thunk32\n A Win32s DLL Loader\n\n          John Zempel\n WinTech Journal, 1993", (LPCSTR) "About Thunk32", MB_OK);
			break;

			default:
	  		break;
		}
		break;

		case WM_DESTROY:
	    	PostQuitMessage(0);
      		break;

    		default:

      		return (DefWindowProc(hwnd, message, wParam, lParam));
	}
return (0);
}


