######################################################################
## MSC 7.0
## C++ makefile for example programs
## Windows Tech Journal, OOP Alley, June 1993
## Demonstrates DiskTutor collection class library
## Greg Voss
######################################################################
## Usage Notes:
## To build example programs:
##     nmake /fmsc70.mak
##          or
##     nmake /fmsc70.mak all
##
## To run test suite
##     nmake /fmsc70.mak verify
##
## To clean intermediate *.obj files:
##     nmake /fmsc70.mak clean
######################################################################



######################################################################
CCDEBUG = /Od /Zi
LNKDEBUG = /CO
MODEL = S       # C small memory model
USR_INCLUDE_DIR =   ..\include
USR_LIB_DIR     =   ..\lib
##I = c:\c700\include   ## Environment variables used instead
USRLIB=dt.lib

CC = cl
LNK = link
CFLAGS = $(CCDEBUG) /A$(MODEL) /Gs /I$(USR_INCLUDE_DIR)
LFLAGS = $(LNKDEBUG)
######################################################################
## Meaning of CFLAGS for MSC 7.0 Compiler
## /AS      small memory model
## /Gs      turn off run-time stack checking
## /Od      turn off all optimizations (use with /Zi for debugging)
## /Zi      include symbolic debug information in obj files
## /Ipath   dir indicates additional path to search for #include
######################################################################

######################################################################
## Meaning of LFLAGS for MSC 7.0 Linker
## /CO      include symbolic debug information in exe files
######################################################################


######################################################################
## Rules
######################################################################
.obj.exe:
    $(LNK) $(LFLAGS) $*, , NUL, $(USR_LIB_DIR)\ $(USRLIB), NUL

.cpp.obj:
    $(CC) /c $(CFLAGS) $<
                    

######################################################################
## Default targets
######################################################################
all:                    \
        xset.exe        \
        xstack.exe      \
        xsortclt.exe    \
        xlist.exe       \


######################################################################
## Target dependencies, and explicit rules
######################################################################
xset.exe: xset.obj
    $(LNK) $(LFLAGS) $*, , NUL, $(USR_LIB_DIR)\ $(USRLIB), NUL

xstack.exe: xstack.obj
    $(LNK) $(LFLAGS) $*, , NUL, $(USR_LIB_DIR)\ $(USRLIB), NUL

xsortclt.exe: xsortclt.obj
    $(LNK) $(LFLAGS) $*, , NUL, $(USR_LIB_DIR)\ $(USRLIB), NUL

xlist.exe: xlist.obj
    $(LNK) $(LFLAGS) $*, , NUL, $(USR_LIB_DIR)\ $(USRLIB), NUL


######################################################################
## Verification Test Suite
## Requires diff.exe (installed in ..\dtlibv)
##
## NOTE:    The last test (xstack) should print an error message
##          to stderr when pop is performed on an empty stack.
######################################################################
DIFF_DIR=..\dtlibv              ## source directory for diff.exe
verify:
        -xset.exe        >out.v
            -$(DIFF_DIR)\diff out.v  set.v
        -xsortclt.exe    >out.v
            -$(DIFF_DIR)\diff out.v  sortcltn.v
        -xlist.exe       >out.v
            -$(DIFF_DIR)\diff out.v  list.v
        -xstack.exe      >out.v
            -$(DIFF_DIR)\diff out.v  stack.v
        -del out.v

clean:
    del *.obj

