#include "point.h"

#define THIS Point
#define BASE Object
DEFINE_CLASS(Point,Object);

void Point::printOn(ostream& strm) const
{
    strm << "(" << xc << " @ " << yc << ")";
}

Point Point::max(Point p) const
{
    return Point(MAX(xc,p.xc),MAX(yc,p.yc));
}

Point Point::min(Point p) const
{
    return Point(MIN(xc,p.xc),MIN(yc,p.yc));
}

bool Point::isEqual(const Object& p) const
{
    return p.isSpecies(class_Point) && *this==*(Point*)&p;
}

const Class* Point::species() const  { return &class_Point; }

int Point::compare(const Object& p) const
{
    int t;
    assertArgSpecies(p,class_Point,"compare");
    if ((t=yc-((Point*)&p)->yc) != 0) return t;
    else return (xc-((Point*)&p)->xc);
}

unsigned Point::hash() const { return xc^yc; }

Object* Point::copy() const      { return shallowCopy(); }

void Point::deepenShallowCopy() {}

