######################################################################
## MSC 7.0
## C++ makefile for
## DiskTutor class library
######################################################################
## Usage Notes:
## To build dt.lib:
##     nmake /fmsc70.mak
##          or
##     nmake /fmsc70.mak all
##
## To install dt.lib and *.h files:
##     nmake /fmsc70.mak install
##
## To clean intermediate *.obj files:
##     nmake /fmsc70.mak clean
######################################################################


######################################################################
CCDEBUG = /Od /Zi
MODEL = S       # C small memory model
USR_INCLUDE_DIR =   ..\include
USR_LIB_DIR     =   ..\lib
##I = c:\c700\include   ## Environment variables used instead

CC = cl
CFLAGS = $(CCDEBUG) /A$(MODEL) /Gs /I$(USR_INCLUDE_DIR)
USRLIB=dt.lib
######################################################################
## Meaning of CFLAGS for MSC 7.0 Compiler
## /AS      small memory model
## /Gs      turn off run-time stack checking
## /Od      turn off all optimizations (use with /Zi for debugging)
## /Zi      include symbolic debug information in obj files
## /Ipath   dir indicates additional path to search for #include
######################################################################

######################################################################
## Meaning of LFLAGS for MSC 7.0 Linker
## /CO      include symbolic debug information in exe files
######################################################################


oopsOBJS = \
            arrayob.obj  \
            assoc.obj    \
            assocint.obj \
            bag.obj      \
            collect.obj  \
            date.obj     \
            dict.obj     \
            identdic.obj \
            integer.obj  \
            iterator.obj \
            link.obj     \
            linkob.obj   \
            list.obj     \
            lookupke.obj \
            nil.obj      \
            object.obj   \
            ordcltn.obj  \
            point.obj    \
            queue.obj    \
            random.obj   \
            range.obj    \
            rect.obj     \
            seqcltn.obj  \
            set.obj      \
            sortcltn.obj \
            stack.obj    \
            strclass.obj \
            timecls.obj     


$(USRLIB): $(oopsOBJS)
    del $(USRLIB)
    lib $(USRLIB) @<<lib.rsp
            + arrayob.obj &
            + assoc.obj &
            + assocint.obj &
            + bag.obj &
            + collect.obj &
            + date.obj &
            + dict.obj &
            + identdic.obj &
            + integer.obj &
            + iterator.obj &
            + link.obj &
            + linkob.obj &
            + list.obj &
            + lookupke.obj &
            + nil.obj &
            + object.obj &
            + ordcltn.obj &
            + point.obj &
            + queue.obj &
            + random.obj &
            + range.obj &
            + rect.obj &
            + seqcltn.obj &
            + set.obj &
            + sortcltn.obj &
            + stack.obj &
            + strclass.obj &
            + timecls.obj &
        , oops_lib.lst
<<KEEP
    @echo dt.lib created.
    @echo Now install by running 
    @echo nmake /fmsc70.mak install


.cpp.obj:
    $(CC) /c $(CFLAGS) $<


all: dt.lib

clean:
    del *.obj

USR_INCLUDE_DIR = ..\include
USR_LIB_DIR = ..\lib

install:
    -md               $(USR_INCLUDE_DIR)
    -copy *.h         $(USR_INCLUDE_DIR)
    -md               $(USR_LIB_DIR)
    -copy dt.lib      $(USR_LIB_DIR) 
            

