#include "lookupke.h"

#define THIS    LookupKey
#define BASE    Object
DEFINE_CLASS(LookupKey,Object);

LookupKey::LookupKey(const Object& newKey)
{
    akey = (Object*)&newKey;
}

Object* LookupKey::key() const   { return akey; }

Object* LookupKey::key(const Object& newkey)
{
    Object* temp = akey;
    akey = (Object*)&newkey;
    return temp;
}

bool LookupKey::isEqual(const Object& ob) const { return ob.isEqual(*akey); }

unsigned LookupKey::hash() const { return akey->hash(); }

int LookupKey::compare(const Object& ob) const { return ob.compare(*akey); }

void LookupKey::deepenShallowCopy()
{
    akey = akey->deepCopy();
}

void LookupKey::printOn(ostream& strm) const
{
    akey->printOn(strm);
}

Object* LookupKey::value() const
{
    derivedClassResponsibility("value"); return (Object*)0;
}

Object* LookupKey::value(const Object& newvalue)
{
    derivedClassResponsibility("value"); return (Object*)&newvalue;
}
