/* AssocInt.c -- implementation of key-Integer association

Function:

Objects of class AssocInt associate a key object with an Integer value
object.  They are used to implement Bags, which use a Dictionary to
associate objects with their occurrence counts.

*/

#include "assocint.h"

#define THIS    AssocInt
#define BASE    LookupKey
//DEFINE_CLASS(THIS, BASE);
DEFINE_CLASS(AssocInt,LookupKey);

AssocInt::AssocInt(const Object& newKey, int newValue)
: LookupKey(newKey), avalue(newValue) {}

Object* AssocInt::value() const   { return (Object*)&avalue; }

Object* AssocInt::value(const Object& newValue)
{
    assertArgClass(newValue,class_Integer,"value");
    avalue = *(Integer*)&newValue;
    return &avalue;
}

void AssocInt::deepenShallowCopy()
{
    BASE::deepenShallowCopy();
    avalue.deepenShallowCopy();
}

void AssocInt::printOn(ostream& strm) const
{
    strm << className() << "("; BASE::printOn(strm);
    strm << "="; avalue.printOn(strm); strm << ")";
}

