/*

TESTMET.C - Tests metafile functions
            (C) 1993, Dennis CHUAH

*/

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <metafile.h>


static HMETAFILE hMet;
static char *MetClass = "TestMetaFileClass";

LRESULT CALLBACK WindowProc (HWND hWnd, UINT msg, WPARAM wParam,
                             LPARAM lParam);

#pragma argsused
int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lpCmdLine,
                    int nCmdShow)
  {METAFILEHEADER mh;
   HMETAFILE hMf;
   WNDCLASS wc;
   HWND hWnd;
   MSG msg;

   hMet = GetMetaFileBetter ("GASH1.WMF", &mh);
   hMf = CopyMetaFile (hMet, "GASH-NO.WMF");
   DeleteMetaFile (hMf);
   hMf = CopyMetaFileBetter (hMet, "GASH-YES.WMF", &mh);
   DeleteMetaFile (hMet);
   hMet = hMf;

   if (hPrev == NULL)
     {wc.style = CS_HREDRAW | CS_VREDRAW;
      wc.lpfnWndProc = WindowProc;
      wc.cbClsExtra = 0;
      wc.cbWndExtra = 0;
      wc.hInstance = hInstance;
      wc.hIcon = NULL;
      wc.hCursor = LoadCursor (NULL, IDC_ARROW);
      wc.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
      wc.lpszMenuName = NULL;
      wc.lpszClassName = MetClass;
      RegisterClass (&wc);
     }

   hWnd = CreateWindow (MetClass, "Test MetaFile functions",
      WS_OVERLAPPEDWINDOW, 0, 0, CW_USEDEFAULT, CW_USEDEFAULT,
      NULL, NULL, hInstance, NULL);
   ShowWindow (hWnd, nCmdShow);
   UpdateWindow (hWnd);

   while (GetMessage (&msg, NULL, 0, 0))
     {TranslateMessage (&msg);
      DispatchMessage (&msg);
     }

   DeleteMetaFile (hMet);
   return msg.wParam;
  } // end WinMain


LRESULT CALLBACK WindowProc (HWND hWnd, UINT msg, WPARAM wParam,
                             LPARAM lParam)
  {PAINTSTRUCT ps;
   HDC hDc;
   RECT rect;

   if (msg == WM_PAINT)
     {hDc = BeginPaint (hWnd, &ps);
      GetClientRect (hWnd, &rect);
      SetMapMode (hDc, MM_ANISOTROPIC);
      SetViewportExt (hDc, rect.right, rect.bottom);
      SetViewportOrg (hDc, 0, 0);
      PlayMetaFile (hDc, hMet);
      EndPaint (hWnd, &ps);
      return 0L;
     }
   else if (msg == WM_DESTROY)
     {PostQuitMessage (0);
      return 0L;
     }

   return DefWindowProc (hWnd, msg, wParam, lParam);
  } // end WindowProc



