{TUG PDS CERT 1.01 (Pascal)

==========================================================================

                  TUG PUBLIC DOMAIN SOFTWARE CERTIFICATION

The Turbo User Group (TUG) is recognized by Borland International as the
official support organization for Turbo languages.  This file has been
compiled and verified by the TUG library staff.  We are reasonably certain
that the information contained in this file is public domain material, but
it is also subject to any restrictions applied by its author.

This diskette contains PROGRAMS and/or DATA determined to be in the PUBLIC
DOMAIN, provided as a service of TUG for the use of its members.  The
Turbo User Group will not be liable for any damages, including any lost
profits, lost savings or other incidental or consequential damages arising
out of the use of or inability to use the contents, even if TUG has been
advised of the possibility of such damages, or for any claim by any
other party.

To the best of our knowledge, the routines in this file compile and function
properly in accordance with the information described below.

If you discover an error in this file, we would appreciate it if you would
report it to us.  To report bugs, or to request information on membership
in TUG, please contact us at:

             Turbo User Group
             PO Box 1510
             Poulsbo, Washington USA  98370

--------------------------------------------------------------------------
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
This program demonstrates the use of the heap allocation tools provided in
the HeapChek unit.

* ASSOCIATED FILES
HEAPCHEK.PAS
DEMO.EXE
DEMO.PAS
HEAPCHEK.TPU

* CHECKED BY
DRM 08/08/88

* KEYWORDS
TURBO PASCAL V4.0

==========================================================================
}
Program Demo;

{ This program demonstrates the use of the heap allocation tools provided
  in the HeapChek unit.

  Public Domain -- Lynn W. Taylor (CIS 74176,52) }

Uses TpCRT, TpString, HeapChek;

const MaxArray=24;
      BlockSize=1;

var PointerArray: array  [1..MaxArray] of Pointer;
    Ctr, Index: integer;
    AllocationStrategy: char;

Begin
  ClrScr;
  WriteLn('Heap allocation strategy demo');
  WriteLn;
  WriteLn('Program demonstrates tools to show heap states, and to alter the allocation');
  WriteLn('strategies used by the Heap Manager by modifying the free list.');
  WriteLn;
  WriteLn('To demonstrate, program will allocate 24 one-byte blocks, deallocate them');
  WriteLn('in a random order, then re-allocate them.');
  WriteLn;
  WriteLn('After the blocks are allocated, an "*" will indicate a block which');
  WriteLn('has been deallocated.  The new pointer will be displayed to the right');
  WriteLn('as it is allocated, along with the size of the largest free block.');
  WriteLn;
  WriteLn('Choose [E] for Exact Fit');
  WriteLn('       [F] for First Fit');
  WriteLn('       [B] for Best Fit');
  WriteLn('       [W] for Worst Fit');
  WriteLn('       [S] to place disposed pointer at end of free list');
  WriteLn;
  WriteLn('Any other key uses Turbo default heap management');
  AllocationStrategy:=ReadKey;
  ClrScr;
  Randomize;
  AlwaysShowHeapStatus:=true;
  ClrScr;
  For Ctr:=1 to MaxArray do
    Begin
      GetMem(PointerArray[Ctr], BlockSize);
      GotoXY(32, Ctr);
      Write(Ctr:2,' $', HexPtr(PointerArray[Ctr]));
      GotoXY(1, 1);
      HeapCheck;
      Delay(500)
    End;
  For Ctr:=1 to Random(MaxArray)+MaxArray div 2 do
    Begin
      Index:=Random(MaxArray)+1;
      If PointerArray[Index]<>NIL then
        Begin
          GotoXY(46, Index);
          Write('+');
          FreeMem(PointerArray[Index], BlockSize);
          If UpCase(AllocationStrategy)='S' then SwapFreeHeap;
          GotoXY(1,1);
          HeapCheck;
          ShowFreeList;
          While WhereY<24 do WriteLn('                       ');
          Delay(500);
          GotoXY(46, Index);
          Write('*');
          PointerArray[Index]:=NIL;
        End
    End;
  GotoXY(46, Index);
  Write('+');
  For Ctr:=1 to MaxArray do
    If PointerArray[Ctr]=NIL then
      Begin
        GotoXY(60, Ctr);
        Write('(',MaxFreeListBlock,')');
        Case AllocationStrategy of
          'b','B': BestFitHeap(BlockSize);
          'e','E': ExactFitHeap(BlockSize);
          'f','F': FirstFitHeap(BlockSize);
          'w','W': WorstFitHeap
        end;  {cases}
        GetMem(PointerArray[Ctr], BlockSize);
        GotoXY(48, Ctr);
        Write('$', HexPtr(PointerArray[Ctr]));
        GotoXY(1,1);
        HeapCheck;
        ShowFreeList;
        While WhereY<24 do WriteLn('                       ');
        Delay(500)
      End;
  GotoXY(1,1)
End.
