{TUG PDS CERT 1.01 (Pascal)

==========================================================================

                  TUG PUBLIC DOMAIN SOFTWARE CERTIFICATION

The Turbo User Group (TUG) is recognized by Borland International as the
official support organization for Turbo languages.  This file has been
compiled and verified by the TUG library staff.  We are reasonably certain
that the information contained in this file is public domain material, but
it is also subject to any restrictions applied by its author.

This diskette contains PROGRAMS and/or DATA determined to be in the PUBLIC
DOMAIN, provided as a service of TUG for the use of its members.  The
Turbo User Group will not be liable for any damages, including any lost
profits, lost savings or other incidental or consequential damages arising
out of the use of or inability to use the contents, even if TUG has been
advised of the possibility of such damages, or for any claim by any
other party.

To the best of our knowledge, the routines in this file compile and function
properly in accordance with the information described below.

If you discover an error in this file, we would appreciate it if you would
report it to us.  To report bugs, or to request information on membership
in TUG, please contact us at:

             Turbo User Group
             PO Box 1510
             Poulsbo, Washington USA  98370

--------------------------------------------------------------------------
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Turbo Pascal 4.0 non-resident procedure to change AT class keyboard delay
(.25 - 1.0 sec) and typematic (2 - 30 repeats/sec).

* ASSOCIATED FILES


* CHECKED BY
DRM - 08/08/88

* KEYWORDS
TURBO PASCAL V4.0 AT KEYBOARD MODIFICATION

==========================================================================
}
{$M 16324,0,16324}
program atkybd; { Set AT keyboard delay and typematic.  Turbo Pascal 4.0 }

{ Keying On A Standard, Bob Smith, PC Tech Journal, July 87, p134
  Rev Up The AT Keyboard, Kevin M Crenshaw, PC Tech Journal, May 85, p39
  Speedier AT Keyboard, Robert Patenaude, PC Magazine, Mar 25, 1986, p289}

{ John Haluska CIS 74000,1106 }

const
  DlyVal : array[0..3] of string[3] = ('.25','.5','.75','1.0');
  RepVal : array[0..31] of string[5] = ('30','26.7','24','21.8','20','18.5',
             '17.1','16','15','13.3','12','10.9','10','9.2','8.6','8','7.5',
             '6.7','6','5.5','5','4.6','4.3','4','3.7','3.3','3','2.7','2.5',
             '2,3','2.1','2');
var
  Dly1, Repeat1    : byte;
  Result1,Result2  : integer;
  Error            : byte;

{----------------------------------------------------------------------------}
{ Set AT Keyboard Delay code 0-3 (.25, .5, .75, or 1 sec) before start of
  Typematic code 0-31 (30, 26.7, 24, 21.8, 20, 18.5, 17.1, 16, 15, 13.3, 12,
  10.9, 10, 9.2, 8.6, 8, 7.5, 6.7, 6, 5.5, 5, 4.6, 4.3, 4.0, 3.7, 3.3, 3, 2.7,
  2.5, 2.3, 2.1 or 2 repeats/sec). Return Error code 0 (Operation successful),
  1 (Invalid Delay and/or Typematic code), 2 (Hardware error or feature not
  supported) }

procedure SetATKybdDelayTypematic(Delay,Typematic:byte; var Error: byte);

procedure Xmit(Data:byte; var Error:byte);
          {Transmit info to keyboard}
var
  Rdy1        : byte;
  TickCount   : ^longint;
  Tc1         : longint;

begin
  Error:=0;
  TickCount := Ptr($40,$6C);   { location of DOS clock }
  Tc1 := TickCount^;           { 18.2 tickcounts/second }
  repeat
    Rdy1 := Port[$64];         { Is data waiting for the controller? }
    if (TickCount^ - Tc1) > 36 then
      begin
        Error:=2; Exit;   { Time out - hardware error or not supported }
      end;
  until Rdy1 and 2 = 0;
  Port[$60] := Data;           { Send data to keyboard }
  Tc1 := TickCount^;
  repeat
    Rdy1 := Port[$64];         { Wait for keyboard to read data }
    if (TickCount^ - Tc1) > 36 then
      begin
        Error:=2; Exit;
      end;
  until Rdy1 and 2 = 0;
  Tc1 := TickCount^;
  repeat
    Rdy1 := Port[$64];         { Wait for keyboard to send ACK }
    if (TickCount^ - Tc1) > 36 then
      begin
        Error:=2; Exit;
      end;
  until Rdy1 and 1 = 0;
  Tc1 := TickCount^;
  repeat until (TickCount^ - Tc1) > 2;
  Rdy1 := Port[$60];
  if Rdy1 <> $FA then Error:=2;   { Was it ACK? }
end; {Xmit}

begin
  Error:=0;
  if (Delay<0) or (Delay>3) or (Typematic<0) or (Typematic>31) then
    begin
      Error:=1;  Exit;
    end;
  Xmit($F3,Error);              { send command to set delay and typematic }
  if Error = 2 then Exit;
  Xmit(Delay shl 5 + Typematic,Error);  { send delay and typematic values }
end;{SetATKybdDelayTypematic}
{----------------------------------------------------------------------------}

begin
  case ParamCount of
    0: begin
Writeln('                  Set AT Keyboard Delay and Repeat Rate');
Writeln;
Writeln('            Syntax: ATKYBD [Delay Code] [Repeats/Sec Code] ');
Writeln;
Writeln('                   Code  Delay(Sec)    Code  Delay(Sec)');
Writeln('                     0     .25           2      .75 ');
Writeln('                     1     .50*          3     1.00 ');
Writeln;
Writeln('       Code Rep/Sec    Code Rep/Sec    Code Rep/Sec   Code Rep/Sec ');
Writeln;
Writeln('         0    30         8    15        16    7.5      24    3.7 ');
Writeln('         1    26.7       9    13.3      17    6.7      25    3.3 ');
Writeln('         2    24        10    12        18    6        26    3.0 ');
Writeln('         3    21.8      11    10.9*     19    5.5      27    2.7 ');
Writeln('         4    20        12    10        20    5        28    2.5 ');
Writeln('         5    18.5      13     9.2      21    4.6      29    2.3 ');
Writeln('         6    17.1      14     8.6      22    4.3      30    2.1 ');
Writeln('         7    16        15     8.0      23    4.0      31    2.0 ');
Writeln;
Writeln('          * Standard Values');
       end;
    2: begin
         Val(ParamStr(1),Dly1,Result1);
         Val(ParamStr(2),Repeat1,Result2);
         if (Result1 > 0) or (Result2 > 0) then
           begin
             Writeln('Syntax error - Exit Program');  Exit;
           end
         else
           begin
             SetATKybdDelayTypematic(Dly1,Repeat1,Error);
             case Error of
               0: begin
                    Write('AT Keyboard Delay: ',DlyVal[Dly1],' sec.  ');
                    Writeln('Typematic: ',RepVal[Repeat1],' repeats/sec');
                  end;
               1: begin
                    Writeln('Syntax Error - Exit Program'); Exit;
                  end;
               2: begin
                    Write('Hardware error or feature not supported');
                    Writeln(' - Exit Program');  Exit;
                  end;
               end;
           end;
       end;
    else           { 1 or greater than 2 command line parameters }
      begin
        Writeln('Syntax error - Exit Program');  Exit;
      end;
   end;
 end.
