(*  T{m{ ohjelma laatii satunnaissokkelon, jossa ei ole silmukoita   *)
(*  ja josta l|ytyy varmasti yksi ja vain yksi ulosp{{sy.            *)
(*  Sokkelo luodaan taulukkoon sokkelonkartta, ja piirret{{n samalla *)
(*  CGAn 320x200 pisteen ruudulle.                                   *)
(*  Listaukseen on merkitty laiteriippuvaiset piirteet, muutenhan    *)
(*  Pascal on aivan riitt{v{n itsedokumentoivaa.                     *)
(*  Ohjelma on kirjoitettu Turbo Pascal 3.0 varten, mutta ei sen     *)
(*  sovittaminen muihin versioihin/k{{nt{jiin pit{isi olla mitenk{{n *)
(*  mahdoton teht{v{.                                                *)

program Sokkelo;   (* Just for fun, TP couldn't care less about this *)
const
  seina = 'X';
  scrlen = 320;    (* "Hires"-ruudun leveys pisteiss{ *)

type
  kartta = array [1..200,1..200] of char;
  suunnat = (pohjoinen,ita,etela,lansi);

var
  korkeus,leveys,xa:integer;
  ch:char;
  sokkelonkartta:kartta;

Procedure TyhjennaSokkelo;
var
  x,y:integer;
  scrn:byte absolute $B800:0;
begin
  fillchar(scrn,16383,255);                (* Tyhjent{{ kuvaruudun      *)
  fillchar(sokkelonkartta,300*200,seina);  (* Tyhjent{{ sokkelotaulukon *)
end;

Procedure TeeSokkelo(x,y:integer; suunta:suunnat);
  var
    seuraava_suunta : suunnat;
    suuntia_kokeilematta : set of suunnat;

  Procedure Hae_x_askel_ja_y_askel(suunta:suunnat; var x_askel,y_askel:integer);
  begin
    x_askel := 0; y_askel := 0;
    case suunta of
      pohjoinen  : y_askel := -1;
      ita        : x_askel := 1;
      etela      : y_askel := 1;
      lansi      : x_askel := -1;
    end;
  end;

  Procedure Etene(var x,y:integer; suunta:suunnat);
  var
    x_askel,y_askel : integer;
  begin
    Hae_x_askel_ja_y_askel(suunta,x_askel,y_askel);
    x := x + x_askel; y := y + y_askel;
    sokkelonkartta[x,y] := ' ';

(* Piirret{{n k{yt{v{ pisteest{ (xa+x,y) pisteeseen (xa+x+x_askel,y+y_askel) *)
    draw(xa + x, y, xa + x + x_askel, y + y_askel, 0);

    x := x + x_askel;y := y + y_askel;
    sokkelonkartta[x,y] := ' ';
  end;

  Function SatunnaisSuunta:suunnat;
  begin
    case random(4) of
      0 : SatunnaisSuunta := pohjoinen;
      1 : SatunnaisSuunta := ita;
      2 : SatunnaisSuunta := etela;
      3 : SatunnaisSuunta := lansi;
    end;
  end;

  Function VoiEdeta(x,y:integer; suunta:suunnat):boolean;
  var
    x_askel,y_askel : integer;
  begin
    Hae_x_askel_ja_y_askel(suunta,x_askel,y_askel);
    x := x + x_askel*2;
    y := y + y_askel*2;
    VoiEdeta := false;
    if x<leveys then
      if x>0 then
        if y<korkeus then
          if y>0 then
            if sokkelonkartta[x,y] = 'X' then
              VoiEdeta := true
  end;

begin  { TeeSokkelo }
  suuntia_kokeilematta := [pohjoinen..lansi] - [suunta];
  if VoiEdeta(x,y,suunta) then Etene(x,y,suunta);
  While suuntia_kokeilematta <> [] do
  begin
    seuraava_suunta := SatunnaisSuunta;
    if voiedeta(x,y,seuraava_suunta) then
      TeeSokkelo(x,y,seuraava_suunta);
    suuntia_kokeilematta := suuntia_kokeilematta - [seuraava_suunta];
  end;
end;

begin
  repeat
    TextMode;
    repeat
      korkeus:=1000; leveys:=1000;
      Writeln; Write('Anna Korkeus ja Leveys (max 200 200):');
      Read(korkeus,leveys)
    until (korkeus <= 200) and (leveys <= 200);

    (* Asetetaan 320*200 "hires" grafiikka *)
    GraphMode;

    TyhjennaSokkelo;
    xa := (ScrLen - leveys) div 2;
    if xa<10 then halt;

    (* Piirret{{n k{yt{v{t ulos varsinaisesta sokkelosta *)
    draw(0, 2, xa + 2, 2, 0); draw(xa + leveys - 2, 2, 319, 2, 0);

    TeeSokkelo(2,2,ita);

    repeat until keypressed;
  until false;
end.
