{$TITLE:'Epson MX-100 TabSet Procedure',$PAGESIZE:57,$LINESIZE:132,$LINE+}

{This program is an elementary-level Pascal program, illustrating how
 procedures are incorporated into programs, how a printer file is
 defined and used and how control characters can be defined and used.
 The program was written for an Epson MX-100; it can presumably be
 used on the MX-80 with virtually no change.}

PROGRAM TabTest (Input,Output);

VAR
  I, Col, Count: INTEGER;
  Flag: BOOLEAN;
  Answer: CHAR;
  Tabs: ARRAY[1..132] OF BOOLEAN;
  Printer: TEXT;

PROCEDURE TabSet (TabCol: INTEGER; VerifyFlag: BOOLEAN);

CONST
  Escape = CHR(27);
  HorTab = CHR(9);
  NullChar = CHR(0);
     
BEGIN

  IF TabCol < 0 THEN
    BEGIN
      Count:= 0;
      FOR I:= 1 TO 132 DO
        Tabs[I]:= FALSE
    END
  
  ELSE IF (TabCol >= 1) AND (TabCol <= 132) AND (Count < 12) THEN
    BEGIN
      Count:= Count+1;
      Tabs[TabCol]:= TRUE
    END

  ELSE IF TabCol = 0 THEN
    BEGIN
      ASSIGN (Printer,'LPT1:'); { Open print file }
      REWRITE (Printer);
      WRITE (Printer,Escape,'D'); { Send Escape D }
      FOR I:= 2 TO 132 DO { Send column numbers for tab settings }
        IF Tabs[I] THEN WRITE (Printer,CHR(I-1));
      WRITELN (Printer,NullChar); { Send null to terminate sequence }
            
      IF VerifyFlag = TRUE THEN
        BEGIN
          WRITE (Printer,'-');
          FOR I:=2 TO 132 DO
            BEGIN
              IF Tabs[I] THEN WRITE (Printer,'+')
              ELSE WRITE (Printer,'-');
            END;
          WRITELN (Printer);
          FOR I:= 1 TO Count DO
            BEGIN
              WRITE (Printer,HorTab,'+');
            END;
          WRITELN (Printer);
        END;
      CLOSE (Printer)
    END;
END;
  
BEGIN
  WRITE ('Will You Want To Display Tab Settings (Y/N)? ');
  READLN (Answer);
  IF (Answer='Y') OR (Answer='y') THEN
    BEGIN
      Flag:= TRUE;
      WRITELN ('Tab Settings Will Be Displayed . . .')
    END
  ELSE
    BEGIN
      Flag:= FALSE;
      WRITELN ('Tab Settings Will Not Be Displayed . . .')
    END;
  TabSet (-1,Flag);
  WRITELN;
  WRITELN ('Enter Up To Ten Tabs, Each On A Separate Line.');
  WRITELN ('Enter A "0" To Stop Column Prompts . . .');
  WRITELN;
  REPEAT
    READLN (Col);
    TabSet (Col,Flag);
    IF Col <>0
      THEN WRITELN ('A Tab Will Be Set in Column ', Col:1)
      ELSE WRITELN ('Tab Setting Completed.')
  UNTIL Col=0
END.