program idfi;
uses opcrt,dos;
const
 hcrt=$3b4;
type
  vsystem=(MONO,HERC,CGA,EGA,VGA,MCGA,OTHER);
const
  sys_names : array[vsystem] of string[26]=
   ('Mono Text','Hercules','Color Graphics','Extended Graphics',
    'Video Graphics Array','Multi-Color Graphics','Don''t know');
var
  rr:registers;


function find6845(addr:word):boolean; (* TRUE IF 6845 *)
var
 tmp:byte;
begin
  port[addr]:=$F;
  tmp:=port[addr+1];
  port[addr+1]:=$66;
  delay(100);
  find6845:=port[addr+1]=$66;
  port[addr+1]:=tmp;
end;

function findmono:vsystem;
var
 cnt:word;
 tmp1,tmp2:byte;
begin
 if find6845(hcrt) then
 begin
   tmp1:=port[hcrt+6] and $80;
   repeat
     tmp2:=port[hcrt+6] and $80;
   until tmp1<>tmp2;
   if tmp1<>tmp2 then findmono:=HERC
                 else findmono:=MONO;
 end
 else (*Not Mono *)
   findmono:=OTHER;
end;

function findCGA:vsystem;
begin
 if find6845($3D4) then findCGA:=CGA
                   else findCGA:=OTHER;
end;

function findEGA:vsystem;
begin
 rr.bx:=$0010;
 rr.ax:=$1200;
 intr($10,rr);
 if lo(rr.bx)<>$10 then
 begin
  case lo(rr.cl) div 2 of
    0,3:findEGA:=CGA;
    1,4:findEGA:=EGA;
    2,5:findEGA:=Herc;
  end
 end
 else (*No ega *)
   findEGA:=OTHER;
end;

function findPS2:vsystem;
begin
 rr.ax:=$1A00;
 intr($10,rr);
 if lo(rr.ax)=$1A then
 begin
   case lo(rr.bx) of
   0,3,6,9:findPS2:=other;
         1:findPS2:=MONO;
         2:findPS2:=CGA;
      4,10:findPS2:=EGA;
         5:findPS2:=HERC;
       7,8:findPS2:=VGA;
     11,12:findPS2:=MCGA;
   end
 end
 else
   findPS2:=OTHER;
end;

function whatvsystem:vsystem;
var
 ts:vsystem;
begin
 ts:=findPS2;
 if ts=other then
    ts:=findEGA;
 if ts=other then
    ts:=findmono;
 if ts=other then
    ts:=findCGA;
 whatvsystem:=ts;
end;

begin
 writeln('Video system is ',sys_names[whatvsystem]);
 halt(ord(whatvsystem)+100);
end.
