;
; ADOSX32.ASM (c) Rainer Schnitker 92,93
;
; Entry point for protected mode int 0x21
;

	INCLUDE REGS386.INC
        INCLUDE TRANS.INC

        .386p

DGROUP group _DATA

        extrn _int21:near               ; C-function int21 handler
        extrn _load_ds:near             ; load 16bit extender ds
        extrn _clearregs:near           ; clear high bits from 32bit regs
	extrn _realdos:near		; call real-mode int 0x21
	extrn _check_signals:near	; check if signals raised

_DATA segment word public 'DATA' use16
        extrn _stackp16:DWORD           ; esp value for 16bit extender stack
        extrn _npz:PROCESS              ; pointer to running process
        extrn _tr:TRANS                 ; translation struct for r-mode switch
_DATA ends

_TEXT segment byte public 'CODE' use16
        assume cs:_TEXT,ds:DGROUP



; **************************************
; Entry point for int 0x21
; - test default bit from code segment ( 32 or 16 bit )
; - we handle only 32bit-calls
; - all 16bit calls (from our extender) passed to real mode
;   only segment registers are changed
;

public _doscall
_doscall proc far			; INT 0x21 handler entry
	push	eax
	lar	eax, [esp + 8]		; load cs access rights
	test	eax, 0400000h		; test default code size
	pop	eax

	jnz	short int32bit		; ok, 32bit user int
	cmp	ah, 04Ch		; test extender exit
					; required for more than one instance
	jne	short int16bit		; 16bit DOS call from extender

					; jmp to orginal handler (DPMI-host)
        db 066h         ; 32bit
	db 0EAh 	; JMP
public _int21voff			; label for writing in code
_int21voff:
	dd 2		; offset
public _int21vsel			; label for writing in code
_int21vsel:
	dd 1		; selector



; **************************************
; all 16bit calls assume that this call is equal to a real mode call
; where the segment registers are equal to programs segments
;
; stack: 0=eip 4=cs 8=eflags

int16bit:
	mov	dword ptr _tr.T_EAX, eax
	mov	dword ptr _tr.T_EBX, ebx
	mov	dword ptr _tr.T_ECX, ecx
	mov	dword ptr _tr.T_EDX, edx
	mov	dword ptr _tr.T_ESI, esi
	mov	dword ptr _tr.T_EDI, edi
	mov	dword ptr _tr.T_EBP, ebp

	call	_realdos

	mov	bp, sp
	mov	ax, word ptr _tr.T_FLAGS
	mov	word ptr [bp+8], ax
	mov	eax, dword ptr _tr.T_EAX
	mov	ebx, dword ptr _tr.T_EBX
	mov	ecx, dword ptr _tr.T_ECX
	mov	edx, dword ptr _tr.T_EDX
	mov	esi, dword ptr _tr.T_ESI
	mov	edi, dword ptr _tr.T_EDI
	mov	ebp, dword ptr _tr.T_EBP
        iretd


; **************************************
; here is the 32bit handler
; save all registers, check signals, restore all registers

int32bit:	  ; stack: 0=eip 4=cs 8=eflags

	push	esi
	call	_load_ds			; load 16 bit extender ds
	xor	esi, esi
	mov	si, word ptr DGROUP:_npz	; load process ptr
	pop	dword ptr [si].r_esi		; save ESI

	mov	[si].r_eax, eax 		; EAX
	mov	[si].r_ebx, ebx 		; EBX
	mov	[si].r_ecx, ecx 		; ECX
	mov	[si].r_edx, edx 		; EDX
	mov	[si].r_edi, edi 		; EDI
	mov	[si].r_ebp, ebp 		; EBP
	mov	word ptr [si].r_ds, es		; DS
	mov	word ptr [si].r_es, es		; ES	!assume(es=ds)
	mov	word ptr [si].r_ss, ss		; SS
	mov	word ptr [si].r_fs, fs		; FS
	mov	word ptr [si].r_gs, gs		; GS
	mov	[si].r_esp, esp 		; ESP
	mov	[si].r_esporg, esp		; ESP before int
	add	[si].r_esporg, dword ptr 12	;

	mov	ebp, esp			; others regs are on user stack
	mov	eax, [ebp]			; EIP
	mov	[si].r_eip, eax
	mov	eax, [ebp+4]			; CS
	mov	[si].r_cs, eax
	mov	eax, [ebp+8]			; EFLAGS
	mov	[si].r_eflags, eax

	push	ds				; make ss=ds
	pop	ss				; load 16bit ss
	mov	esp, _stackp16			; load 16bit sp

	sub	esp, 3000	; int stack under exception/signal stack

	call	_clearregs	; clear high bits for our 16bit prg

	call	_int21		; call C-prg handler for int21h

public _back_from_syscall
_back_from_syscall:
	call	_check_signals

	mov	si, word ptr DGROUP:_npz	; load process ptr
	mov	ebx, [si].r_ebx 		; restore old regs
	mov	ecx, [si].r_ecx
	mov	edx, [si].r_edx
	mov	edi, [si].r_edi
	mov	ebp, [si].r_ebp
	mov	ss , word ptr [si].r_ss 	; change ss first
	mov	esp, [si].r_esp 		; restore ss:esp
	mov	es , word ptr [si].r_es
	mov	fs , word ptr [si].r_fs
	mov	gs , word ptr [si].r_gs

	mov	eax, [si].r_eflags		; other regs are on user stack
	mov	[esp+8], eax
	mov	eax, [si].r_cs
	mov	[esp+4], eax
	mov	eax, [si].r_eip
	mov	[esp], eax
	mov	eax, [si].r_eax 		; eax

	push	dword ptr [si].r_esi		; restore esi
	pop	esi

	push	es
	pop	ds				; last segment restore
        iretd
_doscall endp

_TEXT	ends

	end
