//
//  XTFormattedOutputElement.m
//  TadsTerp
//
//  Created by Rune Berg on 10/07/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTFormattedOutputElement.h"


@implementation XTFormattedOutputElement

+ (instancetype) regularOutputElement:(NSAttributedString *)attributedString
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementRegularOutput;
	elt.attributedString = attributedString;
	return elt;
}

+ (instancetype)removeTabsToStartOfLineElement
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementRemoveTabsToStartOfLine;
	return elt;
}

+ (instancetype)gameTitleElement:(NSAttributedString *)attributedString
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementGameTitle;
	elt.attributedString = attributedString;
	return elt;
}

- (BOOL)isRegularOutputElement
{
	return (self.elementType == XTFormattedOutputElementRegularOutput);
}

- (BOOL)isRegularOutputElementWithString:(NSString *)str
{
	return [self isRegularOutputElement] && [str isEqualToString:self.attributedString.string];
}

- (BOOL)isRemoveTabsToStartOfLineElement
{
	return (self.elementType == XTFormattedOutputElementRemoveTabsToStartOfLine);
}

- (BOOL)isGameTitleElement
{
	return (self.elementType == XTFormattedOutputElementGameTitle);
}

@end
