#ifndef OSWIN_INCLUDED
#define OSWIN_INCLUDED

# define OS2

// It seems weird to be #defining MACintosh, but it is necessary to keep
// TADS from trying to do its own "[More]" handling. SRG
//# define MAC
# define MAC_OS

# define OS_SYSTEM_NAME  "Win95/NT"
# define OS_SYSTEM_LDESC "Win95/98 and NT"

# define OS_TC_USAGE  "usage: tc32 [options] file"
# define OS_TR_USAGE  "usage: WinTADS [options] file"
# define OS_TDB_USAGE  "usage: tdb32 [options] file"

#ifndef OS_DEFAULT_SWAP_ENABLED
# define OS_DEFAULT_SWAP_ENABLED 1
#endif

/* maximum width of an output line buffer */
#define OS_MAXWIDTH 135

extern int stristr(char *p, char *q);
extern void tzset(void);

/* far pointer type qualifier (null on most platforms) */
#  define osfar_t
#  define far

/* maximum theoretical size of malloc argument */
#  define OSMALMAX ((size_t)0xffffffff)

/* cast an expression to void */
#  define DISCARD (void)

#  include <stdlib.h>
#  include <stdio.h>

/* display lines on which errors occur */
#  define OS_ERRLINE 1

/*
 *   If long cache-manager macros are NOT allowed, define
 *   OS_MCM_NO_MACRO.  This forces certain cache manager operations to be
 *   functions, which results in substantial memory savings.  
 */
#define OS_MCM_NO_MACRO

/* likewise for the error handling subsystem */
#define OS_ERR_NO_MACRO
#define ERR_NO_MACRO


/*
 *   If error messages are to be included in the executable, define
 *   ERR_LINK_MESSAGES.  Otherwise, they'll be read from an external
 *   file that is to be opened with oserrop().
 */
//#define OS_ERR_LINK_MESSAGES 
#define ERR_LINK_MESSAGES 

/* 
 *   Update progress display with linfdef info, if appropriate.  This can
 *   be used to provide a status display during compilation.  Most
 *   command-line implementations will just ignore this notification; this
 *   can be used for GUI compiler implementations to provide regular
 *   display updates during compilation to show the progress so far.  
 */
#define os_progress(linf)

/* Don't print the cryptic "TADS-1000" error code in error messages. */
#define OS_SKIP_ERROR_CODES

/* round a size to worst-case alignment boundary */
#define osrndsz(s) (((s)+3) & ~3)

/* round a pointer to worst-case alignment boundary */
#define osrndpt(p) ((uchar *)((((ulong)(p)) + 3) & ~3))

/* void pointer type */
typedef void dvoid;

/* offset of a member inside a structure */
//###defined in stddef.h
/*#ifndef offsetof
#define offsetof(typ, mem) ((uint)&(((typ *)0)->mem))
#endif*/

/* read unaligned portable 2-byte value, returning int */
#define osrp2(p) ((int)*(unsigned short *)(p))

/* write int to unaligned portable 2-byte value */
#define oswp2(p, i) (*(unsigned short *)(p)=(i))

/* read unaligned portable 4-byte value, returning long */
#define osrp4(p) (*(unsigned long *)(p))

/* write long to unaligned portable 4-byte value */
#define oswp4(p, l) (*(unsigned long *)(p)=(l))

/* allocate storage - malloc where supported */
/*dvoid *osmalloc(size_t siz);*/
#define osmalloc malloc

/* free storage allocated with osmalloc */
/*void osfree(dvoid *block);*/
#define osfree free

/* copy a structure - dst and src are structures, not pointers */
#define OSCPYSTRUCT(dst, src) ((dst) = (src))

/* a full ANSI compiler -- at least, it supports "volatile". */
#define OSANSI

#define TRD_SETTINGS_DEFINED
#define TRD_HEAPSIZ  (65535)
#define TRD_STKSIZ   (1024)
#define TRD_UNDOSIZ  (60000)		/* WARNING: increasing to 65535 will cause crashes */

/* maximum length of a filename */
#define OSFNMAX  _MAX_PATH

/* normal path separator character. */
#define OSPATHCHAR '/'
/* alternate path separator characters */
#define OSPATHALT "\\"
/* character which separates directories in the path */
#define OSPATHSEP ';'

/* os file structure */
typedef FILE osfildef;

/* main program exit codes */
#define OSEXSUCC 0                                 /* successful completion */
#define OSEXFAIL 1                                        /* error occurred */

/* open text file for reading; returns NULL on error */
/* osfildef *osfoprt(char *fname, int typ); */
#define osfoprt(fname, typ) fopen(fname, "r")

/* open text file for reading */
/* osfildef *osfopwt(char *fname, int typ); */
#define osfopwt(fname, typ) fopen(fname, "w")

/* open binary file for writing; returns NULL on error */
/* osfildef *osfopwb(char *fname, int typ); */
#define osfopwb(fname, typ) fopen(fname, "wb")

/* open SOURCE file for reading - use appropriate text/binary mode */
/* osfildef *osfoprs(char *fname, int typ); */
#define osfoprs(fname, typ) fopen(fname, "rb")

/* open binary file for reading; returns NULL on erorr */
/* osfildef *osfoprb(char *fname, int typ); */
#define osfoprb(fname, typ) fopen(fname, "rb")

/* open binary file for reading/writing; truncate; returns NULL on error */
/* osfildef *osfoprwtb(char *fname, int typ); */
#define osfoprwtb(fname, typ) fopen(fname, "w+b")

/* open binary file for reading/writing; don't truncate */
osfildef *osfoprwb(const char *fname, os_filetype_t typ);

/* get a line of text from a text file (fgets semantics) */
/* char *osfgets(char *buf, size_t len, osfildef *fp); */
#define osfgets(buf, len, fp) fgets(buf, len, fp)

/* write bytes to file; TRUE ==> error */
/* int osfwb(osfildef *fp, uchar *buf, int bufl); */
#define osfwb(fp, buf, bufl) (fwrite(buf, bufl, 1, fp) != 1)

/* read bytes from file; TRUE ==> error */
/* int osfrb(osfildef *fp, uchar *buf, int bufl); */
#define osfrb(fp, buf, bufl) (fread(buf, bufl, 1, fp) != 1)

/* write a line of text to a text file (fputs semantics) */
/* void osfputs(char *buf, osfildef *fp); */
#define osfputs(buf, fp) fputs(buf, fp)

/* get a character from a file */
/* int osfgetc(osfildef *fp); */
#define osfgetc(fp) fgetc(fp)

/* read bytes from a file and return count; returns # bytes read, 0=error */
/* size_t osfrbc(osfildef *fp, uchar *buf, size_t bufl); */
#define osfrbc(fp, buf, bufl) (fread(buf, 1, bufl, fp))

/* get position in file */
/* long osfpos(osfildef *fp); */
#define osfpos(fp) ftell(fp)

/* seek position in file; TRUE ==> error */
/* int osfseek(osfildef *fp, long pos, int mode); */
#define osfseek(fp, pos, mode) fseek(fp, pos, mode)
#define OSFSK_SET  SEEK_SET
#define OSFSK_CUR  SEEK_CUR
#define OSFSK_END  SEEK_END

/* close a file */
/* void osfcls(osfildef *fp); */
#define osfcls(fp) fclose(fp)

/* delete a file - TRUE if error */
/* int osfdel(char *fname); */
#define osfdel(fname) remove(fname)

/* access a file - 0 if file exists */
int osfacc(const char *fname);
//#define osfacc(fname) access(fname, 0)

/* open error file, returning file handle, or null if not found */
osfildef *oserrop(/*_ void _*/);

/* clear the screen */
//#define oscls() os_clear_screen()
#define oscls os_clear_screen

/* do nothing with OS_LOADDS definitions */
# define OS_LOADDS

/*
 *   Single/double quote matching macros.  Used to allow systems with
 *   extended character codes with weird quote characters (such as Mac) to
 *   match the weird characters. 
 */
#define os_squote(c) ((c) == '\'')
#define os_dquote(c) ((c) == '"')
#define os_qmatch(a, b) ((a) == (b))

/* Include declarations of os_ functions. */
#include "os_depend.h"

/*
 *  Set plain ascii mode - does nothing under WinTADS
 */
#define os_plain()


/*
 *   Create and open a temporary file.  Creates and opens a temporary
 *   file.  If 'swapname' is null, this routine must choose a file name
 *   and fill in 'buf' with the chosen name; if possible, the file should
 *   be in the conventional location for temporary files on this system,
 *   and should be unique (i.e., it shouldn't be the same as any existing
 *   file).  
 */
//extern osfildef *os_create_tempfile(const char *swapname, char *buf);

/* ------------------------------------------------------------------------ */
/*
 *   If the system "long description" (for the banner) isn't defined,
 *   make it the same as the platform ID string.  
 */
#ifndef OS_SYSTEM_LDESC
# define OS_SYSTEM_LDESC  OS_SYSTEM_NAME
#endif

/*
 *   If a system patch sub-level isn't defined, define it here as zero.
 *   The patch sub-level is used on some systems where a number of ports
 *   are derived from a base port (for example, a large number of ports
 *   are based on the generic Unix port).  For platforms like the Mac,
 *   where the porting work applies only to that one platform, this
 *   sub-level isn't meaningful.
 */
#ifndef OS_SYSTEM_PATCHSUBLVL
# define OS_SYSTEM_PATCHSUBLVL  "0"
#endif

/*
 *   Ports can define a special TDB startup message, which is displayed
 *   after the copyright/version banner.  If it's not defined at this
 *   point, define it to an empty string. 
 */
#ifndef OS_TDB_STARTUP_MSG
# define OS_TDB_STARTUP_MSG ""
#endif

#endif /* OSWIN_INCLUDED */
