/*
 RAP 1.0 Testbed

 Reactive Agent Planner for TADS
 (the Text Adventure Development System)
 ----------------------------------------

 Testbed
 -------

 A compilable game file for testing Rap

*/



#include <adv.t>
#include <std.t>
#include <rap10k.t>
#include <rap10p.t>


replace preinit: function
{
  rBuildMap();   // this is a vital RAP function.  Don't delete this!

                 // rBuildMap builds the default movement plans
                 // for all RAP-enabled actors by scanning the precoded
                 // exits in all rooms

                 // this is best run in preinit or a function called
                 // from preinit.  It's noisy, ie, generates some debugging
                 // messages, and it may take a while on a large map,
                 // so you really want to run it at compile time if possible

                 // Because this game is only a demo and doesn't use any
                 // of the standard std.t darkroom or searchItem functions,
                 // I've replaced the entire preinit, but in a real game
                 // you'd normally modify std.t to include a call to
                 // rBuildMap after the other stuff
}



replace init: function
{
    global.introText;   // display introduction

    // this section here is cut straight from std.t

    version.sdesc;                // display the game's name and version number

    Me.location := startroom;                // move player to initial location
    startroom.lookAround( true );                    // show player where he is
    startroom.isseen := true;                  // note that we've seen the room
    scoreStatus(0, 0);                          // initialize the score display

    // end of std.t section

    notify(rap,&animate,0);   // this sets up the actor daemon
    rap.animate;             // and runs it once

                             //  without this, Rap the dog will do nothing
                             //  animate is just my preferred method name
                             //  for actor self-produced behaviours, it's
                             //  not a RAP requirement.  

}
;


modify version
  sdesc = "\(RAP TESTBED\)
          \nReactive Agent Planner 1.0 testbed
          \nCopyright (C) 1998 by Nate Cull
          \b"

;


// traceVerb is not part of RAP but I've implemented it in this demo
// as a convenient way of activating rToggleTrace() under player control
// rToggleTrace switches RAP trace mode on or off for any given rapper


traceVerb: sysverb
  verb = 'yomin'
  sdesc = "trace"
  doAction = 'Trace'
    validDo( actor, obj, seqno ) =
    {
        return( obj.isVisible(actor) or isclass(obj,rapper));
    }
    validDoList(actor, prep, iobj) = nil

;

modify thing
  verDoTrace(actor) = "You sense nothing."
;

modify Me
  verDoTrace(actor) = "You give yourself a splitting headache."
;

modify rapper
 verDoTrace(actor) = {}
 doTrace (actor) =
  {
    self.rToggleTrace;
  }
;


modify global
  introText =
  {
  //  rBuildMap();

   "\bThis is a simple testbed for RAP (Reactive Agent Planner) 1.0
   for TADS.                                                       
   It's a tiny maze consisting of ten rooms and one locked door.
   You're carrying the key and a ball.  There is one RAP-enabled
   actor - a dog named Rap who starts on the far side of the maze.
   His primary goal is to get the ball and bring it to Room 1.
   No memory filter is implemented yet, so Rap 
   has perfect knowledge of the state and location of all
   objects.

   \bThis test map is trivial, but it does demonstrate Rap's ability to
   react to game events - he will begin by trying to beg the key
   off you, but if you unlock the door yourself he will ignore the key
   and go straight for the ball.  If you have the ball he will follow you,
   otherwise head for Room 1.   If at any time he drops the key or the ball,
   he will pick it up before proceeding.  The debugging spell
   YOMIN RAP will let
   you read Rap's thought processes.\b";


  }
;


// Actor Definition


rap: rapper, Actor

 rTrace = nil    // default trace mode is off

 location = room3
 sdesc = "Rap"
 thedesc = "Rap"
 adesc = "Rap"
 noun = 'rap'
 ldesc =
 {
   "Rap is a dog. ";
   if (length(self.contents)=0) "His mouth is empty.";
   else "He's carrying "; listcont(self); "in his mouth.";
 }
 actorDesc = "\bRap is here,
  looking <<rHappy.rTrue(self,nil) ? 'happy' : 'busy'>>."
 animate =
 {

   // this method gets called by a notify deamon after every turn
   // normally here is where you'd put generic NPC action stuff

   // this is the core of the RAP library
   // the rapAct method is the simplest way of using RAP
   // it searches for the given condition and parameter
   // and then performs a best-fit action that steps toward that goal

   // the RAP condition "rHappy" encodes Rap's top-level behaviour
   // (in this demo, specificially, it is to get the ball and bring it
   // to startroom)

   self.rapAct(rHappy,nil);


   // a little random routine here to make Rap drop stuff accidentally
   // to demonstrate his reactive ability

   if ((length(self.contents)>0) and (rand(100)>50))
   {
     if (self.rLoudAction(nil,nil))
       "\b\^<<self.contents[1].thedesc>> slips out of Rap's mouth
       and rolls to the floor.";
     self.contents[1].moveInto(self.location);
   }
 }

;



// Object Definitions


ball: item
 sdesc = "ball"
 noun = 'ball'
 location = room5

;

ironkey: keyItem
 sdesc = "iron key"
 noun = 'key'
 adjective = 'iron'
 location = room10
;


// Map Definition


startroom: room
  sdesc = "startroom"
  ldesc = "east to room2"
  east = room2
;




room2: room
 sdesc = "Room2"
 ldesc = "west to startroom, north to room3, south to room4"
 west = startroom
 north = room3
 south = room4
;

room3: room
 sdesc = "Room3"
 ldesc = "south to room2"
 south = room2
;

room4: room
 sdesc = "Room4"
 ldesc = "north to room2, south (through door) to room5, east to room6"
 north = room2
 south = room4door
 east = room6
;


room4door: lockableDoorway
  noun = 'door'
  sdesc = "door4"
  location = room4
  otherside = room5door
  isopen = nil
  islocked = true
  key = ironkey
  doordest = room5
;

room5door: lockableDoorway
  noun = 'door'
  sdesc = "door5"
  location = room5
  otherside = room4door
  isopen = nil
  islocked = true
  key = ironkey
  doordest = room4
;


room5: room
 sdesc = "Room5"
 ldesc = "north to room4"
 north = room5door
;



room6: room
 sdesc = "Room6"
 ldesc = "West to room4, east to room7"
 west = room4
 east = room7
;

room7: room
 sdesc = "room7"
 ldesc = "West to room6, north to room8, south to room9"
 north = room8
 south = room9
 west = room6
;

room8: room
 sdesc = "room8"
 ldesc = "South to room7"
 south = room7
;

room9: room
 sdesc = "room9"
 ldesc = "north to room7, southeast to room10"
 north = room7
 se = room10
;

room10: room
 sdesc = "room10"
 ldesc = "northwest to room9"
 nw = room9
;



// Special Conditions and Plans


rHappy: rCond
  sdesc = "rHappy"
  rTrue(a,p) =
  {
    return (a.isCarrying(ball) and a.isIn(startroom));
  }

  rPlans(a,p) =
    [ [rBe rCarrying ball
       rBe rIn startroom]
    ] 

;


modify rNotHeld
 rPlans(a,p) =
 {
   return (
    [
      [rBe rReachable Me
       rDo rAskFor [Me p]]
    ]
   );
 }
;

modify rAskFor
 rPreDesc(a,p) =
  "\b\^<<a.thedesc>> whines and looks pleadingly at <<p[2].thedesc>>."
  
;



