////////////////////////////////////////////////////////////////////////
//  
//  Inform.t Library File: Constant 991214
//
//  Copyright (c) 1999 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the Inform.t library extension for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#include <declare.t>

#pragma C+
 
////////////////////////////////////////////////////////////////////////
//  
//  CONSTANTS FOR timesys
//
////////////////////////////////////////////////////////////////////////

#ifndef PARSETIME_LIM_HH
#define PARSETIME_LIM_HH 	24
#endif
#ifndef PARSETIME_LIM_MM
#define PARSETIME_LIM_MM 	59
#endif

/* Constants for gettimesys */
#define TS_DAY 				'day'
#define TS_DATE 			'date'
#define TS_TIME 			'time'
#define TS_ELAPSE 			'elapse'

////////////////////////////////////////////////////////////////////////
//  
//  CONSTANTS FOR getPlist() AND inPlist() FUNCTIONS
//
////////////////////////////////////////////////////////////////////////

#define PTH_LCC         1
#define PTH_PATH        2
#define PTH_VANTAGE     3
#define PTH_TARGET      4
#define PTH_TLOC        5

////////////////////////////////////////////////////////////////////////
//  
//  CONSTANTS FOR proximity() FUNCTION
//
////////////////////////////////////////////////////////////////////////

#define PRX_REFLEXIVE   1
#define PRX_POSSESSIVE  2
#define PRX_CONTAINED   3
#define PRX_IMMEDIATE   4
#define PRX_LOCAL       5
#define PRX_REMOTE      6

////////////////////////////////////////////////////////////////////////
//  
//  CONSTANTS FOR messagepump
//
////////////////////////////////////////////////////////////////////////

#define MP_PURGE    1
#define MP_FUSE	    2
#define MP_WAITING  3
#define MP_LOCATION 4

////////////////////////////////////////////////////////////////////////
//  
//  CONSTANTS FOR replaceWith()
//
////////////////////////////////////////////////////////////////////////

#define RW_REPLACE_ONCE     1
#define RW_MATCH_WORD       2
#define RW_MATCH_CASE       4
#define RW_RET_NIL          8

////////////////////////////////////////////////////////////////////////
//  
//  COMPOUND WORDS
//
////////////////////////////////////////////////////////////////////////
 
compoundWord 'wait' 'until' 'waituntil';
compoundWord 'wait' 'for' 'waitfor';
compoundWord 'get' 'in' 'getin';
compoundWord 'get' 'into' 'getinto';
compoundWord 'get' 'on' 'geton';
compoundWord 'get' 'onto' 'getonto';
compoundWord 'get' 'out' 'getout';
compoundWord 'getout' 'of' 'getoutof';
compoundWord 'get' 'off' 'getoff';
compoundWord 'getoff' 'of' 'getoffof';
compoundWord 'lie' 'in' 'liein';
compoundWord 'lie' 'on' 'lieon';
