#charset "us-ascii"

/*
 *   Copyright (c) 2002 by Joao Mendes.
 *   ConvActr.t: Conversation Library - Actor Definitions.
 */

#include <adv3.h>
#include <en_us.h>

#include <JmmmConv.h>

/******************************************************************************
 *
 *   JmmmPerson
 */

class JmmmPerson: Person
    canAskNoGreet = nil
    canImplicitGreet = true
    isTalking = nil
    _tmpActor = nil
    actorHereListWith() { return []; }

    history = []
    withTopic(_)
    {
        Ask
        {
            "<q>What can you tell me about <<topic.theName>>?</q>, you
             ask.\b<q>I'm afraid I wouldn't know much about that...</q>,
             <<itNom>> says.";
        }
        Tell
        {
            "<q>I could tell you some things about <<topic.theName>></q>, you
             say.\b<q>I'm afraid I wouldn't have much use for that...</q>,
             <<itNom>> says.";
        }
        Show
        {
            "<q>Take a look at this</q>, you say, showing <<itObj>>
             <<topic.theName>>.\b<q>What about it?</q>, <<itNom>> asks.";
        }
        Give
        {
            "<q>Would you like to have this?</q>, you ask, showing <<itObj>>
             <<topic.theName>>.\b<q>No, not really. Thanks, though.</q>,
             <<itNom>> replies.";
        }
        AskFor
        {
            "<q>Could I please have <<topic.aName>>?</q>, you ask.\b<q>I'm
             afraid I couldn't offer any... My appologies.</q>, <<itNom>>
             replies.";
        }
        Greet {}
        Recall
        {
            "When last you mentioned <<topic.theName>> to <<itObj>>, you
             didn't get much of a response.";
        }
        Before {}
        After {}
        Init {}
    }
    withTopic(_Greet)
    {
        Greet
        {
            "<q>Hello, there...</q>, you say.\b\^<<theName>> nods in response.";
        }
        Recall
        {
            "<q>Hello, again...</q>, you say.\bAnd again, <<theName>> nods in
             response.";
        }
    }

    notTalking()
    {
        return '{You/he} {are}n\'t talking to {the dobj/him}.';
    }

    greetingsFrom(sourceActor)
    {
        isTalking = true;
        _tmpActor = gActor;
        gActor = sourceActor;
        converse(_GreetTopic, Greet);
        gActor = _tmpActor;
    }
    obeyCommand(issuingActor)
    {
        _tmpActor = issuingActor;
        return true;
    }
    actorAction()
    {
        if ( gAction.ofKind(HelloAction) )
            return;
        getParserMessageObj().refuseCommand(self, _tmpActor);
        exit;
    }

    verifyTopic(strng)
    {
        local theTopic = nil;

        if ( gTopic != nil )
            theTopic = gTopic.getBestMatch();

        if ( theTopic == nil )
        {
            reportFailure('That is not something you need to ' + strng + '.');
            exit;
        }

        if ( theTopic.ofKind(JmmmTopic) )
            return;

        reportFailure('That is not something you need to ' + strng + '.');
        exit;
    }
    isTopicRepeat(theTopic)
    {
        if ( history.indexOf(theTopic) )
            return true;
        return nil;
    }
    addToHistory(theTopic)
    {
        local z;

        if ( isTopicRepeat(theTopic) )
            return;

        history = history + theTopic;

        z = topicLst.indexOf(theTopic);
        if ( z )
            topicLst = topicLst.removeElementAt(z);
    }
    deleteFromHistory(theTopic)
    {
        local z = history.indexOf(theTopic);
        if ( z )
            history = history.removeElementAt(z);
    }
    decodeTopic(theTopic, hook)
    {
        if ( theTopic == nil || self.propType(theTopic.(getPropName(hook))) == nil )
            return _Topic;
        return theTopic;
    }
    converse(theTopic, hook)
    {
        redirectTo(theTopic, hook, true);
    }
    redirectTo(newTopic, newHook, doRecall)
    {
        if ( isTopicRepeat(newTopic) )
        {
            if ( newHook == Before || newHook == After )
                return;
            if ( doRecall )
                newHook = Recall;
        }

        if ( newHook != Before && newHook != After )
            addToHistory(newTopic);

        self.(decodeTopic(newTopic, newHook).(getPropName(newHook)))(newTopic, gActor, self);
    }

    dobjFor(AskAbout)
    {
        preCond = [talkingToObj]
        check()
        {
            verifyTopic('ask about');
        }
        action()
        {
            isTalking = true;
            converse(gTopic.getBestMatch(), Ask);
        }
    }
    dobjFor(TellAbout)
    {
        preCond = [talkingToObj]
        check()
        {
            verifyTopic('talk about');
        }
        action()
        {
            isTalking = true;
            converse(gTopic.getBestMatch(), Tell);
        }
    }
    iobjFor(ShowTo)
    {
        preCond = [talkingToObj]
        check()
        {
            verifyTopic('show');
        }
        action()
        {
            isTalking = true;
            converse(gDobj, Show);
        }
    }
    iobjFor(GiveTo)
    {
        preCond = [talkingToObj]
        check()
        {
            verifyTopic('give');
        }
        action()
        {
            isTalking = true;
            converse(gDobj, Give);
        }
    }
    dobjFor(AskFor)
    {
        preCond = [talkingToObj]
        check()
        {
            verifyTopic('ask for');
        }
        action()
        {
            isTalking = true;
            converse(gIobj, AskFor);
        }
    }
    dobjFor(Greet)
    {
        preCond = [canTalkToObj, notTalkingToObj]
        verify() {}
        remap() { return nil; }
        check() {}
        action()
        {
            greetingsFrom(gActor);
        }
    }
    dobjFor(TalkTo) asDobjFor(Greet)

    topicLst = []
    myDaemon = nil
    filterDaemon()
    {
        return true;
    }
    idleDaemon()
    {
    }
    actorDaemon()
    {
        local topic;

        if ( !filterDaemon() )
            return;

        if ( topicLst == [] )
        {
            idleDaemon();
            return;
        }

        topic = topicLst[1];
        converse(topic, Init);

        forEachInstance(JmmmPerson, {obj: obj.afterInit(self, topic)} );
    }
    startDaemon()
    {
        myDaemon = new Daemon(self, &actorDaemon, 1);
    }
    stopDaemon()
    {
        eventManager.removeEvent(myDaemon);
    }

    tmpHst = nil
    tmpActor = nil
    beforeAction()
    {
        local obj, actor;

        if ( gAction.ofKind(TopicAction) )
        {
            obj = gTopic.getBestMatch();
            actor = gDobj;
        }
        else if ( gAction.ofKind(ShowToAction) || gAction.ofKind(GiveToAction) )
        {
            obj = gDobj;
            actor = gIobj;
        }
        else if ( gAction.ofKind(AskForAction) )
        {
            obj = gIobj;
            actor = gDobj;
        }
        else
            return;

        if ( actor == self || obj == nil || !obj.ofKind(JmmmTopic) ||
             (actor.isTopicRepeat(obj) != isTopicRepeat(obj)) )
            return;

        tmpActor = actor;
        tmpHst = actor.history;
        converse(obj, Before);
    }
    afterAction()
    {
        local obj, actor, hst, bool;

        if ( gAction.ofKind(TopicAction) )
        {
            obj = gTopic.getBestMatch();
            actor = gDobj;
        }
        else if ( gAction.ofKind(ShowToAction) || gAction.ofKind(GiveToAction) )
        {
            obj = gDobj;
            actor = gIobj;
        }
        else if ( gAction.ofKind(AskForAction) )
        {
            obj = gIobj;
            actor = gDobj;
        }
        else
            return;

        if ( actor != tmpActor || obj == nil || !obj.ofKind(JmmmTopic) )
        {
            tmpActor = nil;
            tmpHst = nil;
            return;
        }
        tmpActor = nil;

        bool = isTopicRepeat(obj);
        hst = history;
        history = tmpHst;
        if ( isTopicRepeat(obj) != bool )
        {
            history = hst;
            tmpHst = nil;
            return;
        }
        history = hst;
        tmpHst = nil;

        converse(obj, After);
    }
    afterInit(issuer, topic)
    {
        if ( issuer == self || !canHear(issuer) || isTopicRepeat(topic) )
            return;

        converse(topic, After);
    }
;
