#include "giz.ipp"

Array zscii_charset -> 255;

/* !! This gives the Latin-1 equivalents of the default unicode */
/* !! translation map. (Who thought this one up?)  The '?' entires */
/* !! represent the oe ligatures, which are not part of Latin-1. */
/* !! */
/* !! Note, by the way, that GLK keeps Latin-1 "holy," as Andrew Plotkin */
/* !! puts it, so we won't be handling any Unicode outside of Latin-1. */
Array zscii_default_map -> 228 246 252 196 214 220 223 187 171 235 239
    255 203 207 225 233 237 243 250 253 193 201 205 211 218 221 224
    232 236 242 249 192 200 204 210 217 226 234 238 244 251 194 202
    206 212 219 229 197 248 216 227 241 245 195 209 213 230 198 231
    199 254 240 222 208 163 '?' '?' 161 191;



Array A0 -> "      abcdefghijklmnopqrstuvwxyz";
Array A1 -> "      ABCDEFGHIJKLMNOPQRSTUVWXYZ";
Array A2 -> "       ^0123456789.,!?_#'~//-:()";
Array A2_1 -> "       0123456789.,!?_#'~//<-:()";
Array AT --> 3;

Array TripleBuf -> 3;
Array EncodeCache -> 8;

/* !! zabbrevs is an offset from *glulx* memory */
Global zabbrevs;


[zscii_init aloc i;
    readw(zabbrevs, $18);
    zabbrevs = zabbrevs + zmem;

    /* !! handle z-char to zscii mapping */
    
    if (z_ver >= 5 && zmem->$34 ~= 0) {
        aloc = zmem->$34;
        AT-->0 = aloc - 6;
        AT-->1 = aloc + 26;
        AT-->2 = aloc + 52;
    }
    else {
        AT-->0 = A0;
        AT-->1 = A1;
        if (z_ver == 1)
            AT-->2 = A2_1;
        else
            AT-->2 = A2;
        A2->7 = 10;     /* !! newline */
        A2->27 = 92;  /* !! backslash */
        A2->25 = 34;  /* !! double-quote */
        A2_1->26 = 92;
        A2_1->24 = 34;
    }

    /* !! handle zscii to latin1 mapping: output only */
    for (i = 0 : i < 32 : i++)
        zscii_charset->i = '?';

    zscii_charset->0 = 0;
    zscii_charset->9 = ' ';
    zscii_charset->10 = 10;
    zscii_charset->13 = 10;
    
    for (i = 32 : i < 127 : i++)
        zscii_charset->i = i;
    for (i = 127 : i < 255 : i++)
        zscii_charset->i = '?';

    zscii_handle_unicode_map();
];

[zscii_encode_char c i;
            
    for (i = 6 : i < 32 : i++)
        if (A0->i == c)
            return i;
    for (i = 6 : i < 32 : i++)
        if (A1->i == c)
            return i | $ff000000;
    for (i = 6 : i < 32 : i++)
        if (A2->i == c)
            return i | $00ff0000;
    
    return 0;
];


/* !! encode_len is the number of words that the encoded string */
/* !! should occupy */
/* !! buf is a glulxe array, not a z-machine memory address */
[zscii_encode str len encode_len buf i j k c e notdone readahead trip;
    j = 0;
    i = 0;
    k = 0;
    readahead = 0;
    notdone = 1;
    
    while (notdone)
    {
        if (readahead)
        {
            TripleBuf->j++ = EncodeCache->--readahead;
        }
        else if (i == len)
        {
            /* !! end of str, so pad */
            TripleBuf->j++ = 5;
        }
        else
        {
            c = zmem->(str + i++);
            e = zscii_encode_char(c);
                    
            if (e == 0)
            {
                if (z_ver < 3)
                    TripleBuf->j++ = 3;
                else
                    TripleBuf->j++ = 5;
                EncodeCache->readahead++ = 6;
                @ushiftr c 5 e;
                EncodeCache->readahead++ = e;
                EncodeCache->readahead++ = c & $$00011111;
            }
            else if (e & $ff000000)
            {
                if (z_ver < 3)
                    TripleBuf->j++ = 2;
                else
                    TripleBuf->j++ = 4;
                EncodeCache->readahead++ = e & $000000ff;
            }
            else if (e & $00ff0000)
            {
                if (z_ver < 3)
                    TripleBuf->j++ = 3;
                else
                    TripleBuf->j++ = 5;
                EncodeCache->readahead++ = e & $000000ff;
            }
            else
            {
                TripleBuf->j++ = e;
            }
        }
        
        
        if (j == 3)
        {
            j = 0;
            
            trip = TripleBuf->2;
            e = TripleBuf->1;
            @shiftl e 5 e;
            trip = trip | e;
            e = TripleBuf->0;
            @shiftl e 10 e;
            trip = trip | e;
                    
            if (--encode_len == 0)
            {
                notdone = 0;
                trip = (trip | $8000);
            }
            
            @ushiftr trip 8 e;
            buf->k++ = e;
            buf->k++ = trip;
            
        }
    }
];

            
[zscii_decode str printer state w final one two three count;
    state = 4;  /* !! by default, lock alphabet A0 */
    final = 0;
    count = 0;  /* !! count the number of bytes in the z-string */
            
    while (final ~= 1) {
        if (zmem->str & $$10000000)
            final = 1;
        else
            final = 0;

        readw(w, str);
        
        three = w & $0000001f;
        @ushiftr w 5 w;
        two = w & $0000001f;
        @ushiftr w 5 w;
        one = w & $0000001f;
                
        state = zscii_decode_char(one, state, printer);
        state = zscii_decode_char(two, state, printer);
        state = zscii_decode_char(three, state, printer);
        
        str = str + 2;
        count = count + 2;
    }
    return count;
];

/* !! state bits (of the least significant byte) */
/* !! 0: shift up */
/* !! 1: shift down */
/* !! 2: lock A0 */
/* !! 3: lock A1 */
/* !! 4: lock A2 */
/* !! 5: abbrev 1 */
/* !! 6: abbrev 2 */
/* !! 7: abbrev 3 */
/* !! (of the second least significant byte) */
/* !! 0: begin ten-bit ZSCII value */
/* !! 1: received half of ZSCII value (high byte stores this 5-bit value) */

/* !! 00000000 00000000 00000000 00000000 */
[zscii_decode_char z state printer shift_change res tmp;
    shift_change = 0;
            
    /* !! if working on a ZSCII value... */
    if (state & 256)
    {
        /* !! we have half of the value */
        if (state & 512)
        {
            res = state & $ff000000;
            @ushiftr res 19 res;
            res = res | z;
            /* !! no longer working on ZSCII value */
            state = state & $$00000000111111111111110011111111;
            printer(res);
        }
        else
        {
            /* !! this is the first half of the value */
            @shiftl z 24 z;
            state = state | z;
            state = state | 512;
        }
    }
    /* !! are we working on an abbreviation? */
    else if (state & 224)
    {
        if (state & 128)
            z = z + 64;
        else if (state & 64)
            z = z + 32;

        @aloads zabbrevs z tmp;
        zscii_decode(tmp * 2, printer);
        
        state = state & (~ 224);
    }
    else
    {
        switch (z)
        {
         0: printer(' ');
         1:
            if (z_ver == 1)
                printer(10);
            else
                state = state | 32;
         2,3:
            if (z_ver < 3)
            {
                shift_change = 1;
                if (z == 2)
                    state = state | 1;
                else
                    state = state | 2;
            }
            else if (z == 2) 
            {
                state = state | 64;
            }
            else 
            {
                state = state | 128;
            }
         4,5:
            if (z_ver < 3)
            {
                /* !! shift lock */
                if (state & 4)
                {
                    if (z == 4)
                        state = state | 8;
                    else
                        state = state | 16;
                    
                    state = state & (~ 4);
                }    
                else if (state & 8)
                {
                    if (z == 4)
                        state = state | 16;
                    else
                        state = state | 4;
                    
                    state = state & (~ 8);
                }
                else
                {
                    if (z == 4)
                        state = state | 4;
                    else
                        state = state | 8;
                    
                    state = state & (~ 16);
                }
            }
            else
            {
                /* !! shift */
                shift_change = 1;
                if (z == 4)
                    state = state | 1;
                else
                    state = state | 2;
            }
         default:
            /* !! determine current alphabet and use char table */
/*             !! temporarily use res to store alphabet # */
                    
            if (state & 4)
                res = 0;
            else if (state & 8)
                res = 1;
            else
                res = 2;
            
            if (state & 1)
            {
                res++;
                if (res > 2)
                    res = 0;
            }
            
            if (state & 2)
            {
                res--;
                if (res < 0)
                    res = 2;
            }

            if (res == 2 && z == 6)
            {
                /* !! begin 10-bit ZSCII value */
                state = state | 256;
            }
            else
            {
                res = (AT-->res)->z;
                printer(res);
            }
        }
    }
            
    if (shift_change == 0)
        state = state & (~ 3);
    
    return state;
];
            
            
            
[zscii_print_table txt w h skip i j x;

    if (zio_current == zio_upper)
        x = zio_x;
    
    for (i = 0 : i < h : i++)
    {
        for (j = 0 : j < w : j++)
            zio_put_char(zmem->txt++);
        txt = txt + skip;

        if (zio_current == zio_upper)
            zio_set_cursor(x, zio_y + 1);
        else
            zio_put_char(13);
    }
];

        
[latin_to_zscii c;
    switch (c)
    {
     10, $fffffffa: /* !! newline, return */
        return 13;
     $fffffff9: /* !! delete */
        return 8;
     $fffffff8:
        return 27;
     $fffffffc: /* !! cursor up */
        return 129;
     $fffffffb: /* !! down */
        return 130;
     $fffffffe: /* !! left */
        return 131;
     $fffffffd: /* !! right */
        return 132;
     $ffffffef to $ffffffe4: /* !! f1 - f12 (hope I got these right...) */
         return (0 - c) + 30;
     default:
        return c;
    }
];

[zscii_handle_unicode_map tbl_loc ext_len uni_loc uni_tbl uni_tbl_len
    i c found_map;

    found_map = false;
    
    if (z_ver >= 5)
    {
        readw(tbl_loc, $36);
        if (tbl_loc > 0)
        {
            readw(ext_len, tbl_loc);
            if (ext_len > 2)
            {
                uni_loc = tbl_loc + 6;
                readw(uni_tbl, uni_loc);

                uni_tbl_len = (zmem->uni_tbl) * 2;

                uni_tbl++;
                for (i = 0 : i < uni_tbl_len : i = i + 2)
                {
                    uni_loc = uni_tbl + i;
                    readw(c, uni_loc);
                    if (c > 255)
                        zscii_charset->(155 + i/2) = '?';
                    else
                        zscii_charset->(155 + i/2) = c;
                }
                found_map = true;
            }
        }
    }

    if (~~ found_map)
    {
        for (i = 0 : i < 69 : i++)
            zscii_charset->(155 + i) = zscii_default_map->i;
    }
];


    
