/*
 * Decompiled with CFR 0.152.
 */
package zmachine;

import zmachine.ZMemory;
import zmachine.ZUserInterface;

class ZObjectTable {
    private ZUserInterface zui;
    private ZMemory memory;
    private int version;
    private int objTable;
    private int defaultsSize;
    private int objAttrSize;
    private int objHandleSize;
    private int objEntrySize;

    ZObjectTable() {
    }

    void initialize(ZUserInterface ui, ZMemory mem, int ver) {
        this.zui = ui;
        this.memory = mem;
        this.version = ver;
        this.objTable = this.memory.fetchWord(10);
        if (this.version <= 3) {
            this.defaultsSize = 62;
            this.objAttrSize = 4;
            this.objHandleSize = 1;
        } else {
            this.defaultsSize = 126;
            this.objAttrSize = 6;
            this.objHandleSize = 2;
        }
        this.objEntrySize = this.objAttrSize + 3 * this.objHandleSize + 2;
    }

    int getSibling(int obj) {
        int sib = this.version <= 3 ? this.memory.fetchByte(this.objTable + this.defaultsSize + (obj - 1) * this.objEntrySize + this.objAttrSize + this.objHandleSize) : this.memory.fetchWord(this.objTable + this.defaultsSize + (obj - 1) * this.objEntrySize + this.objAttrSize + this.objHandleSize);
        return sib;
    }

    void setSibling(int obj, int sib) {
        if (this.version <= 3) {
            this.memory.putByte(this.objTable + this.defaultsSize + (obj - 1) * this.objEntrySize + this.objAttrSize + this.objHandleSize, sib);
        } else {
            this.memory.putWord(this.objTable + this.defaultsSize + (obj - 1) * this.objEntrySize + this.objAttrSize + this.objHandleSize, sib);
        }
    }

    int getChild(int obj) {
        int child = this.version <= 3 ? this.memory.fetchByte(this.objTable + this.defaultsSize + (obj - 1) * this.objEntrySize + this.objAttrSize + 2 * this.objHandleSize) : this.memory.fetchWord(this.objTable + this.defaultsSize + (obj - 1) * this.objEntrySize + this.objAttrSize + 2 * this.objHandleSize);
        return child;
    }

    void setChild(int obj, int child) {
        if (this.version <= 3) {
            this.memory.putByte(this.objTable + this.defaultsSize + (obj - 1) * this.objEntrySize + this.objAttrSize + 2 * this.objHandleSize, child);
        } else {
            this.memory.putWord(this.objTable + this.defaultsSize + (obj - 1) * this.objEntrySize + this.objAttrSize + 2 * this.objHandleSize, child);
        }
    }

    int getParent(int obj) {
        int parent = this.version <= 3 ? this.memory.fetchByte(this.objTable + this.defaultsSize + (obj - 1) * this.objEntrySize + this.objAttrSize) : this.memory.fetchWord(this.objTable + this.defaultsSize + (obj - 1) * this.objEntrySize + this.objAttrSize);
        return parent;
    }

    void setParent(int obj, int parent) {
        if (this.version <= 3) {
            this.memory.putByte(this.objTable + this.defaultsSize + (obj - 1) * this.objEntrySize + this.objAttrSize, parent);
        } else {
            this.memory.putWord(this.objTable + this.defaultsSize + (obj - 1) * this.objEntrySize + this.objAttrSize, parent);
        }
    }

    void removeObject(int parent, int obj) {
        if (parent == 0) {
            return;
        }
        int curObj = this.getChild(parent);
        if (curObj == 0) {
            this.zui.fatal("Corrupted object table");
        }
        if (curObj == obj) {
            this.setChild(parent, this.getSibling(obj));
            this.setSibling(obj, 0);
            this.setParent(obj, 0);
            return;
        }
        int prevObj = curObj;
        curObj = this.getSibling(prevObj);
        while (curObj != obj && curObj != 0) {
            prevObj = curObj;
            curObj = this.getSibling(prevObj);
        }
        if (curObj == 0) {
            this.zui.fatal("Corrupted object table");
        }
        this.setSibling(prevObj, this.getSibling(curObj));
        this.setSibling(obj, 0);
        this.setParent(obj, 0);
    }

    void insertObject(int obj1, int obj2) {
        int oldparent = this.getParent(obj1);
        if (oldparent > 0) {
            this.removeObject(oldparent, obj1);
        }
        int oldfirst = this.getChild(obj2);
        this.setSibling(obj1, oldfirst);
        this.setChild(obj2, obj1);
        this.setParent(obj1, obj2);
    }

    int getPropertyLength(int baddr) {
        int length;
        if (baddr == 0) {
            return 0;
        }
        int b = this.memory.fetchByte(baddr - 1);
        if (this.version < 4) {
            length = (b >> 5 & 7) + 1;
        } else if ((b & 0x80) == 128) {
            length = b & 0x3F;
        } else {
            length = (b >> 6 & 1) + 1;
            if (length == 0) {
                length = 64;
            }
        }
        return length;
    }

    int getPropertyList(int obj) {
        int addr = this.memory.fetchWord(this.objTable + this.defaultsSize + (obj - 1) * this.objEntrySize + this.objAttrSize + 3 * this.objHandleSize);
        return addr;
    }

    int getPropertyAddress(int obj, int prop) {
        int p = this.getPropertyList(obj);
        int o = this.memory.fetchByte(p);
        p = p + o * 2 + 1;
        int s = this.memory.fetchByte(p);
        while (s != 0) {
            int psize;
            int pnum;
            if (this.version < 4) {
                pnum = s & 0x1F;
                psize = (s >> 5 & 7) + 1;
            } else {
                pnum = s & 0x3F;
                if ((s & 0x80) == 128) {
                    psize = this.memory.fetchByte(++p);
                    psize &= 0x3F;
                } else {
                    psize = (s >> 6 & 3) + 1;
                }
            }
            ++p;
            if (pnum == prop) {
                return p;
            }
            s = this.memory.fetchByte(p += psize);
        }
        return 0;
    }

    int getProperty(int obj, int prop) {
        int pdata = this.getPropertyAddress(obj, prop);
        if (pdata > 0) {
            if (this.getPropertyLength(pdata) == 1) {
                return this.memory.fetchByte(pdata);
            }
            return this.memory.fetchWord(pdata);
        }
        return this.memory.fetchWord(this.objTable + (prop - 1) * 2);
    }

    int getNextProperty(int obj, int prop) {
        if (prop == 0) {
            int propaddr = this.getPropertyList(obj);
            propaddr += this.memory.fetchByte(propaddr) * 2;
            int propnum = this.version < 3 ? this.memory.fetchByte(propaddr) & 0x1F : this.memory.fetchByte(propaddr) & 0x3F;
            return propnum;
        }
        int propaddr = this.getPropertyAddress(obj, prop);
        if (propaddr == 0) {
            return 0;
        }
        int proplen = this.getPropertyLength(propaddr);
        int propnum = this.version < 3 ? this.memory.fetchByte(propaddr) & 0x1F : this.memory.fetchByte(propaddr += proplen) & 0x3F;
        return propnum;
    }

    int getObjectName(int obj) {
        int addr = this.getPropertyList(obj) + 1;
        return addr;
    }

    void putProperty(int obj, int prop, int value) {
        int propaddr = this.getPropertyAddress(obj, prop);
        if (propaddr == 0) {
            return;
        }
        int proplen = this.getPropertyLength(propaddr);
        if (proplen == 1) {
            this.memory.putByte(propaddr, value & 0xFF);
        } else {
            this.memory.putWord(propaddr, value);
        }
    }

    boolean hasAttribute(int obj, int attr) {
        int whichbyte = attr / 8;
        int whichbit = attr % 8;
        int bitmask = 128 >>> whichbit;
        int attrbyte = this.memory.fetchByte(this.objTable + this.defaultsSize + (obj - 1) * this.objEntrySize + whichbyte);
        return (attrbyte & bitmask) == bitmask;
    }

    void setAttribute(int obj, int attr) {
        int whichbyte = attr / 8;
        int whichbit = attr % 8;
        int bitmask = 128 >>> whichbit;
        int attrbyte = this.memory.fetchByte(this.objTable + this.defaultsSize + (obj - 1) * this.objEntrySize + whichbyte);
        this.memory.putByte(this.objTable + this.defaultsSize + (obj - 1) * this.objEntrySize + whichbyte, attrbyte |= bitmask);
    }

    void clearAttribute(int obj, int attr) {
        int whichbyte = attr / 8;
        int whichbit = attr % 8;
        int bitmask = 128 >>> whichbit;
        int attrbyte = this.memory.fetchByte(this.objTable + this.defaultsSize + (obj - 1) * this.objEntrySize + whichbyte);
        attrbyte = attrbyte & ~bitmask & 0xFF;
        this.memory.putByte(this.objTable + this.defaultsSize + (obj - 1) * this.objEntrySize + whichbyte, attrbyte);
    }
}

