/*
 * Decompiled with CFR 0.152.
 */
package com.zaxsoft.zmachine;

import com.zaxsoft.zmachine.ZMemory;
import com.zaxsoft.zmachine.ZUserInterface;
import java.awt.Dimension;
import java.util.StringTokenizer;

class ZIOCard {
    private ZUserInterface zui;
    private ZMemory memory;
    private int version;
    private int inputStream;
    private int outputStream;
    private boolean buffer;
    private StringBuffer outputBuffer;
    private boolean[] isOpen = new boolean[]{false, true, true, true, true};
    private int baseMemAddr;
    private int curMemAddr;
    private int memWidth;
    private int memCursorX;
    private boolean memMultiLine;

    ZIOCard() {
    }

    void initialize(ZUserInterface ui, ZMemory mem, int ver, boolean buf) {
        this.zui = ui;
        this.memory = mem;
        this.version = ver;
        this.outputStream = 1;
        this.inputStream = 0;
        this.buffer = buf;
        this.outputBuffer = new StringBuffer();
    }

    void printString(String s) {
        if (!this.isOpen[this.outputStream]) {
            return;
        }
        switch (this.outputStream) {
            case 1: {
                if (this.buffer) {
                    this.outputBuffer.append(s);
                    break;
                }
                this.zui.showString(s);
                break;
            }
            case 2: {
                System.out.print(s);
                break;
            }
            case 3: {
                if (!this.memMultiLine) {
                    for (int n = 0; n < s.length(); ++n) {
                        this.memory.putByte(this.curMemAddr + n, s.charAt(n));
                    }
                    this.curMemAddr += s.length();
                    this.memory.putWord(this.baseMemAddr, this.memory.fetchWord(this.baseMemAddr) + s.length());
                    break;
                }
                StringTokenizer st = new StringTokenizer(s, "\n ", true);
                while (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    if (tok.equals("\n")) {
                        this.memory.putWord(this.curMemAddr, 0);
                        this.baseMemAddr = this.curMemAddr;
                        this.curMemAddr += 2;
                        continue;
                    }
                    if (this.memCursorX + tok.length() > this.memWidth - 2) {
                        this.memory.putWord(this.curMemAddr, 0);
                        this.baseMemAddr = this.curMemAddr;
                        this.curMemAddr += 2;
                    }
                    for (int n = 0; n < tok.length(); ++n) {
                        this.memory.putByte(this.curMemAddr + n, tok.charAt(n));
                    }
                    this.curMemAddr += tok.length();
                    this.memory.putWord(this.baseMemAddr, this.memory.fetchWord(this.baseMemAddr) + tok.length());
                }
                break;
            }
        }
    }

    void outputFlush() {
        if (!this.buffer) {
            return;
        }
        if (this.outputBuffer.length() == 0) {
            return;
        }
        this.zui.showString(this.outputBuffer.toString());
        this.outputBuffer = new StringBuffer();
    }

    void setOutputStream(int s, int baddr, int w, boolean multiLine) {
        if (s < 0) {
            this.isOpen[-s] = false;
            this.outputStream = 1;
            return;
        }
        if (s == 0 || s > 4) {
            this.zui.fatal("Illegal output stream: " + s);
        }
        if (s == 3) {
            this.memMultiLine = multiLine;
            this.baseMemAddr = baddr;
            this.memory.putWord(this.baseMemAddr, 0);
            this.curMemAddr = this.baseMemAddr + 2;
            if (this.memMultiLine) {
                if (w < 0) {
                    this.memWidth = -w;
                } else {
                    Dimension d = this.zui.getWindowSize(w);
                    this.memWidth = d.width;
                }
                this.memCursorX = 0;
            }
            this.outputStream = 3;
            this.isOpen[3] = true;
        } else if (s == 4) {
            this.zui.fatal("Output stream 4 not yet supported");
        } else {
            this.outputStream = s;
            this.isOpen[s] = true;
        }
    }

    void setInputStream(int s) {
        if (s < 0 || s > 1) {
            this.zui.fatal("Illegal input stream: " + s);
        }
        if (s == 1) {
            this.zui.fatal("Input stream 1 unsupported");
        } else {
            this.inputStream = s;
        }
    }

    int readLine(StringBuffer sb, int time) {
        return this.zui.readLine(sb, time);
    }

    int readChar(int time) {
        int c = this.zui.readChar(time);
        return c;
    }
}

