#!/usr/bin/env python

import sys

base64chars='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'

# Taken from the wikipedia page: http://en.wikipedia.org/wiki/Base64
def base64_encode(s):
   # the result/encrypted string, the padding string, and the pad count
   r = ""
   p = ""
   c = len(s) % 3
 
   # add a right zero pad to make this string a multiple of 3 characters
   if (c > 0):
      #for (; c < 3; c++):
      while (c < 3):
         p += '='
         s += "\0"
         c += 1

   # increment over the length of the string, three characters at a time
   #for (c = 0; c < s.length; c += 3):
   c = 0
   while (c < len(s)):
      # we add newlines after every 76 output characters, according to
      # the MIME specs
      #if (c > 0 and (c / 3 * 4) % 76 == 0):
      #   r += "\r\n"

      # these three 8-bit (ASCII) characters become one 24-bit number
      n = (ord(s[c]) << 16) + (ord(s[c+1]) << 8) + ord(s[c+2])

      # this 24-bit number gets separated into four 6-bit numbers
      n = [(n >> 18) & 63, (n >> 12) & 63, (n >> 6) & 63, n & 63]

      # those four 6-bit numbers are used as indices into the base64
      # character list
      r += base64chars[n[0]] + base64chars[n[1]] + \
           base64chars[n[2]] + base64chars[n[3]]
      c += 3
   # add the actual padding string, after removing the zero pad
   #return r.substr(0, len(r) - len(p)) + p
   return r[0:(len(r)-len(p))] + p

fname = sys.argv[1]
fd = file(fname, "rb")

print "<?xml version='1.0'?>"

data = fd.read()
txt = base64_encode(data)

print "<source>" + txt + "</source>"


## print "<library>"
## print "<script>"

## txt = ""
## while 1:
## 	data = fd.read(1)
## 	if (data == ""): break
## 	txt += str(ord(data)) + ", "

## print "var zdata = [" + txt[0:-2] + "];"

## print "</script>"
## print "</library>"

fd.close()


