
;;;	Copyright (c) 1990 by Aubrey Jaffer,
;;;	All rights reserved.

;;; Some of these functions may be already defined in your Scheme.
;;; Comment out those definitions for functions which are already defined.

;;; This system conforms to:
;;; William Clinger and Jonathan Rees, editors. Revised^3.99
;;; Report on the Algorithmic Language Scheme.  DRAFT August 31, 1989.

;;; A compatibility package from Scheme^3 to Scheme^3.99 should be
;;; written if anyone requires it.  The reference for Scheme^3 is:
;;; Jonathan Rees and William Clinger, editors. The Revised^3
;;; Report on the algorithmic language Scheme.  In ACM SIGPLAN Notices
;;; 21(12), ACM, December 1986.

(define call/cc call-with-current-continuation)
(define (list-copy lst) (append lst '()))
(define (make-list k obj)
  (if (<= k 0) '() (cons obj (make-list (- k 1) obj))))
(define (adjoin e l) (if (memq e l) l (cons e l)))
(define (union l1 l2)
  (cond ((null? l1) l2)
	((null? l2) l1)
	(else (union (cdr l1) (adjoin (car l1) l2)))))
(define (position obj lst)
  (letrec ((pos (lambda (n lst)
		  (cond ((null? lst) #f)
			((eqv? obj (car lst)) n)
			(else (pos (+ 1 n) (cdr lst)))))))
    (pos 0 lst)))
(define (reduce-init p init l)
  (if (null? l)
      init
      (reduce-init p (p init (car l)) (cdr l))))
(define (reduce p l)
  (cond ((null? l) l)
	((null? (cdr l)) (car l))
	(else (reduce-init p (car l) (cdr l)))))
(define (some pred l)
  (and (not (null? l))
       (or (pred (car l)) (some pred (cdr l)))))
(define (every pred l)
  (or (null? l)
      (and (pred (car l)) (every pred (cdr l)))))
(define (notevery pred l)
  (or (null? l)
      (or (not (pred (car l))) (notevery pred (cdr l)))))
(define (find-if t l)
  (cond ((null? l) #f)
	((t (car l)) (car l))
	(else (find-if t (cdr l)))))
(define (member-if t l)
  (cond ((null? l) #f)
	((t (car l)) l)
	(else (member-if t (cdr l)))))
(define (remove-if p l)
  (cond ((null? l) l)
	((p (car l)) (remove-if p (cdr l)))
	(else (cons (car l) (remove-if p (cdr l))))))
(define (remove-if-not p l)
  (cond ((null? l) l)
	((p (car l)) (cons (car l) (remove-if-not p (cdr l))))
	(else (remove-if-not p (cdr l)))))
(define (last-pair l)
  (if (pair? (cdr l)) (last-pair (cdr l)) l))
(define (nconc a b)
  (cond ((null? a) b)
	(else (set-cdr! (last-pair a) b)
	      a)))
(define (butlast lst n)
  (letrec ((l (- (length lst) n))
	   (bl (lambda (lst n)
		 (cond ((null? lst) lst)
		       ((positive? n)
			(cons (car lst) (bl (cdr lst) (+ -1 n))))
		       (else '())))))
    (bl lst (if (negative? n)
		(error "negative argument to butlast")
		l))))
;;;; Merge Sort from MIT C Scheme ;; Functional and unstable
;;; destructive would be acceptable but this one is non-destructive.
(define (sort obj pred)
  (letrec ((loop (lambda (l)
		   (if (and (pair? l) (pair? (cdr l)))
		       (split l '() '())
		       l)))
	   (split (lambda (l one two)
		    (if (pair? l)
			(split (cdr l) two (cons (car l) one))
			(merge (loop one) (loop two)))))
	   (merge (lambda (one two)
		    (cond ((null? one) two)
			  ((pred (car two) (car one))
			   (cons (car two) (merge (cdr two) one)))
			  (else (cons (car one) (merge (cdr one) two)))))))
    (cond ((or (pair? obj) (null? obj)) (loop obj))
	  ((vector? obj) (sort! (vector-copy obj) pred))
	  (else (error "sort: argument should be a list or vector" obj)))))
(define (list-tail l p)
  (if (< p 1) l (list-tail (cdr l) (- p 1))))
(define (string->list s)
  (do ((i (- (string-length s) 1) (- i 1))
       (l '() (cons (string-ref s i) l)))
      ((< i 0) l)))
(define (list->string l) (apply string l))
(define (string-copy s)
  (do ((v (make-string (string-length s)))
       (i (- (string-length s) 1) (- i 1)))
      ((< i 0) v)
      (string-set! v i (string-ref s i))))
(define (string-fill! s obj)
  (do ((i (- (string-length s) 1) (- i 1)))
      ((< i 0))
      (string-set! s i obj)))
(define (list->vector l) (apply vector l))
(define (vector->list s)
  (do ((i (- (vector-length s) 1) (- i 1))
       (l '() (cons (vector-ref s i) l)))
      ((< i 0) l)))
(define (vector-fill! s obj)
  (do ((i (- (vector-length s) 1) (- i 1)))
      ((< i 0))
      (vector-set! s i obj)))

(define base-language 'scheme)
;;; The rest define dummy functions for common-lisp compatability
(define char-code-limit 256)
(define (funcall p . args) (apply p args))
(define (identity arg) arg)
(define (scl . args) #t)
(define proclaim identity)
