#!/usr/bin/perl -w
use 5.008;
use strict;

use ExtUtils::MakeMaker;
use Cwd;
use File::Spec;

# $Header: /cvsroot/gtk2-perl/gtk2-perl-xs/Gnome2-Wnck/Makefile.PL,v 1.13 2005/09/17 20:30:37 kaffeetisch Exp $

my %build_reqs = (
  'perl-ExtUtils-Depends'   => '0.20',
  'perl-ExtUtils-PkgConfig' => '1.03',
  'perl-Glib'               => '1.04',
  'perl-Gtk2'               => '1.00',
  'Wnck'                    => '2.12.0',
);

unless (eval "use ExtUtils::Depends '$build_reqs{'perl-ExtUtils-Depends'}';"
           . "use ExtUtils::PkgConfig '$build_reqs{'perl-ExtUtils-PkgConfig'}';"
           . "use Glib '$build_reqs{'perl-Glib'}';"
           . "use Gtk2 '$build_reqs{'perl-Gtk2'}';"
           . "use Glib::MakeHelper;"
           . "use Gtk2::CodeGen;"
           . "1") {
  warn "$@\n";
  WriteMakefile(
    PREREQ_FATAL => 1,
    PREREQ_PM    => {
      'Glib'                => $build_reqs{'perl-Glib'},
      'Gtk2'                => $build_reqs{'perl-Gtk2'},
      'ExtUtils::Depends'   => $build_reqs{'perl-ExtUtils-Depends'},
      'ExtUtils::PkgConfig' => $build_reqs{'perl-ExtUtils-PkgConfig'},
    },
  );
  exit 1; # not reached
}

# --------------------------------------------------------------------------- #

my %pkgcfg = ExtUtils::PkgConfig->find("libwnck-1.0");

mkdir 'build', 0777;

my @xs_files = <xs/*.xs>;
my %pod_files = (
  'Wnck.pm' => '$(INST_MAN3DIR)/Gnome2::Wnck.$(MAN3EXT)',
  Glib::MakeHelper->do_pod_files (@xs_files),
);

Gtk2::CodeGen->parse_maps('wnck2perl');
Gtk2::CodeGen->write_boot(ignore => qr/^Gnome2::Wnck$/);

ExtUtils::PkgConfig->write_version_macros (
  "build/wnck2perl-version.h",
  "libwnck-1.0" => "WNCK",
);

# --------------------------------------------------------------------------- #

# Mark 2.6.2.1 to work around an API change.  Would someone please stop the
# madness?
if ($pkgcfg{modversion} eq "2.6.2.1") {
  $pkgcfg{cflags} .= " -DWNCK_I_AM_SO_INCREDIBLY_BROKEN";
}

# --------------------------------------------------------------------------- #

my $wnck = ExtUtils::Depends->new('Gnome2::Wnck', 'Gtk2');
$wnck->set_inc($pkgcfg{cflags} . " -DWNCK_I_KNOW_THIS_IS_UNSTABLE");
$wnck->set_libs($pkgcfg{libs});
$wnck->add_xs(@xs_files);
$wnck->add_pm('Wnck.pm' => '$(INST_LIBDIR)/Wnck.pm');
$wnck->add_typemaps(map {File::Spec->catfile(cwd(), $_)} 'build/wnck2perl.typemap');

$wnck->install(qw(wnck2perl.h build/wnck2perl-autogen.h build/wnck2perl-version.h));
$wnck->save_config('build/IFiles.pm');

WriteMakefile(
  NAME          => 'Gnome2::Wnck',
  VERSION_FROM  => 'Wnck.pm', # finds $VERSION
  ABSTRACT_FROM => 'Wnck.pm', # retrieve abstract from module
  XSPROTOARG    => '-noprototypes',
  MAN3PODS      => \%pod_files,
  $wnck->get_makefile_vars,
);

sub MY::postamble {
  return Glib::MakeHelper->postamble_clean ()
       . Glib::MakeHelper->postamble_docs_full (
           DEPENDS => $wnck,
           COPYRIGHT_FROM => 'copyright.pod')
       . Glib::MakeHelper->postamble_rpms (
           GNOME_WNCK => $build_reqs{'Wnck'},
           PERL_EXTUTILS_DEPENDS => $build_reqs{'perl-ExtUtils-Depends'},
           PERL_EXTUTILS_PKGCONFIG => $build_reqs{'perl-ExtUtils-PkgConfig'},
           PERL_GLIB => $build_reqs{'perl-Glib'},
           PERL_GTK => $build_reqs{'perl-Gtk2'});
}
