# NAME

Traveller – a web application to generate sector and subsector maps
for the Traveller RPG

# SYNOPSIS

**traveller** daemon -m production -l http://*:8080

**traveller** routes -v

**traveller** get /uwp/subsector/mgt/123 | w3m -T text/html

# DESCRIPTION

This package contains a web application to generate sector and
subsector maps for the Traveller RPG. The rules are either based on
Classic Traveller (CT), Classic Traveller with the Merchant Prince
Trade System (MPTS), or Mongoose Traveller (1st edition).

To start it as a web server in production mode, listening for all
hostnames on port 8080:

```
traveller daemon -m production -l http://*:8080
```

To run it in development mode and reload it whenever you change a
file:

```
morbo $(which traveller)
```

# INSTALLATION

Using `cpan`:

```
cpan App::phoebe
```

Manual install:

```
perl Makefile.PL
make
make install
```

If you want to know more, see
[Mojolicious::Guides::Tutorial](https://metacpan.org/pod/Mojolicious::Guides::Tutorial)
and
[Mojolicious::Guides::Cookbook](https://metacpan.org/pod/Mojolicious::Guides::Cookbook)
(to manage the web server with systemd, for example).

## Dependencies

Perl libraries you need to install if you want to run it:

* [Mojolicious](https://metacpan.org/pod/Mojolicious) or `libmojolicious-perl`
* [Modern::Perl](https://metacpan.org/pod/Modern::Perl) or `libmodern-perl-perl`

# LICENSE

GNU Affero General Public License
