use strict;
use warnings;

package My::App::Controller::Bookmark;

use base "Catalyst::Example::Controller::InstantCRUD";


{
    package My::App::Controller::Bookmark::BookmarkForm;
    use HTML::FormHandler::Moose;
    extends 'HTML::FormHandler::Model::DBIC';
    with 'HTML::FormHandler::Render::Simple';


    has '+item_class' => ( default => 'Bookmark' );

    has_field 'usr' => ( type => 'Select', );
    has_field 'submit' => ( widget => 'submit' )
}




__PACKAGE__->config(
    action => {
        list => { Chained => 'base', PathPart => q{}, Args => 0 },
        view => { Chained => 'base' },
        edit => { Chained => 'base' },
        destroy => { Chained => 'base' },
    },
);

sub base : Chained('/') PathPart('bookmark') CaptureArgs(0) {}

1;

