package App::Akter;
#ABSTRACT: Akter is a Perl5 task runner

use 5.10.0;
use strict;
use warnings;

use Cwd;
use Getopt::Long;

use App::Akter::Script;
use App::Akter::Exception;

# module version
our $VERSION = "0.001";   

sub run {
    my $instance = __PACKAGE__->new;
    return $instance->startup(@_);
}

# constructor
sub new {
    my $class = shift;
    return bless {
        _home     => Cwd::getcwd(),
        _verbose  => 0,
        _filename => '',
        _tasks    => [],
    }, $class;
}

sub startup {
    my $self = shift;
    
    my $home     = Cwd::getcwd();
    my $verbose  = 0;
    my $filename = '';

    # config arguments
    GetOptions("file=s" => \$filename, "verbose" => \$verbose)
        or throw "Error in command line arguments\n";


    # build akter file path
    $home = Cwd::abs_path($filename) || $home;
    $filename = $home .= '/akterfile' unless $filename;

    # error: file not-found
    throw "[error] akterfile not found!\n" 
        unless -e $filename;

    # parse and exec script
    my $script = App::Akter::Script->new( file => $filename );
    $script->execute;
}

1;
