package Locales::DB::Language::it;

# Auto generated from CLDR

$Locales::DB::Language::it::VERSION = '0.06';

$Locales::DB::Language::it::cldr_version = '1.7.2';

%Locales::DB::Language::it::misc_info = (
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'language'                => "Language\:\ \{0\}",
        'locale'                  => "\{0\}\ \(\{1\}\)",
        'percent'                 => "\#\,\#\#0\%",
        'territory'               => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "sì\:si\:s"
    },
);

%Locales::DB::Language::it::code_to_name = (
    'aa'    => 'afar',
    'ab'    => 'abkhazian',
    'ace'   => 'accinese',
    'ach'   => 'acioli',
    'ada'   => 'adangme',
    'ady'   => 'adyghe',
    'ae'    => 'avestan',
    'af'    => 'afrikaans',
    'afa'   => "lingua\ afroasiatica",
    'afh'   => 'afrihili',
    'ain'   => 'ainu',
    'ak'    => 'akan',
    'akk'   => 'accado',
    'ale'   => 'aleuto',
    'alg'   => "lingue\ algonchine",
    'alt'   => "altai\ meridionale",
    'am'    => 'amarico',
    'an'    => 'aragonese',
    'ang'   => "inglese\ antico",
    'anp'   => 'angika',
    'apa'   => "lingue\ apache",
    'ar'    => 'arabo',
    'arc'   => 'aramaico',
    'arn'   => 'araucano',
    'arp'   => 'arapaho',
    'art'   => "lingua\ artificiale",
    'arw'   => 'aruaco',
    'as'    => 'assamese',
    'ast'   => 'asturiano',
    'ath'   => "lingue\ athabaska",
    'aus'   => "lingue\ australiane",
    'av'    => 'avaro',
    'awa'   => 'awadhi',
    'ay'    => 'aymara',
    'az'    => 'azerbaigiano',
    'ba'    => 'baschiro',
    'bad'   => 'banda',
    'bai'   => "lingue\ bamileke",
    'bal'   => 'beluci',
    'ban'   => 'balinese',
    'bas'   => 'basa',
    'bat'   => "lingua\ baltica",
    'be'    => 'bielorusso',
    'bej'   => 'begia',
    'bem'   => 'wemba',
    'ber'   => 'berbero',
    'bg'    => 'bulgaro',
    'bh'    => 'bihari',
    'bho'   => 'bhojpuri',
    'bi'    => 'bislama',
    'bik'   => 'bicol',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengalese',
    'bnt'   => 'bantu',
    'bo'    => 'tibetano',
    'br'    => 'bretone',
    'bra'   => 'braj',
    'bs'    => 'bosniaco',
    'btk'   => 'batak',
    'bua'   => 'buriat',
    'bug'   => 'bugi',
    'byn'   => 'blin',
    'ca'    => 'catalano',
    'cad'   => 'caddo',
    'cai'   => "lingua\ indiana\ dell\'America\ Centrale",
    'car'   => 'caribico',
    'cau'   => "lingua\ caucasica",
    'cch'   => 'atsam',
    'ce'    => 'ceceno',
    'ceb'   => 'cebuano',
    'cel'   => "celtica\ altra\ lingua",
    'ch'    => 'chamorro',
    'chb'   => 'chibcha',
    'chg'   => 'ciagataico',
    'chk'   => 'chuukese',
    'chm'   => 'mari',
    'chn'   => "gergo\ chinook",
    'cho'   => 'choctaw',
    'chp'   => 'chipewyan',
    'chr'   => 'cherokee',
    'chy'   => 'cheyenne',
    'cmc'   => "lingue\ chamic",
    'co'    => 'corso',
    'cop'   => 'copto',
    'cpe'   => "creolo\ o\ pidgin\ basati\ sull\'inglese",
    'cpf'   => "creolo\ o\ pidgin\ basati\ sul\ francese",
    'cpp'   => "creolo\ o\ pidgin\ basati\ sul\ portoghese",
    'cr'    => 'cree',
    'crh'   => "turco\ crimeo",
    'crp'   => "creolo\ o\ pidgin",
    'cs'    => 'ceco',
    'csb'   => 'kashubian',
    'cu'    => "slavo\ della\ Chiesa",
    'cus'   => "lingua\ cuscitica",
    'cv'    => 'chuvash',
    'cy'    => 'gallese',
    'da'    => 'danese',
    'dak'   => 'dakota',
    'dar'   => 'dargwa',
    'day'   => 'dayak',
    'de'    => 'tedesco',
    'de_at' => "tedesco\ austriaco",
    'de_ch' => "alto\ tedesco\ svizzero",
    'del'   => 'delaware',
    'den'   => 'slave',
    'dgr'   => 'dogrib',
    'din'   => 'dinca',
    'doi'   => 'dogri',
    'dra'   => "lingua\ dravidica",
    'dsb'   => "basso\ sorabo",
    'dua'   => 'duala',
    'dum'   => "olandese\ medio",
    'dv'    => 'divehi',
    'dyu'   => 'diula',
    'dz'    => 'dzongkha',
    'ee'    => 'ewe',
    'efi'   => 'efik',
    'egy'   => "egiziano\ antico",
    'eka'   => 'ekajuka',
    'el'    => 'greco',
    'elx'   => 'elamitico',
    'en'    => 'inglese',
    'en_au' => "inglese\ australiano",
    'en_ca' => "inglese\ canadese",
    'en_gb' => "inglese\ britannico",
    'en_us' => "inglese\ americano",
    'enm'   => "inglese\ medio",
    'eo'    => 'esperanto',
    'es'    => 'spagnolo',
    'es_es' => "spagnolo\ della\ Spagna",
    'et'    => 'estone',
    'eu'    => 'basco',
    'ewo'   => 'ewondo',
    'fa'    => 'persiano',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'fulah',
    'fi'    => 'finlandese',
    'fil'   => 'filippino',
    'fiu'   => "lingua\ ungrofinnica",
    'fj'    => 'figiano',
    'fo'    => 'faroese',
    'fon'   => 'Fon',
    'fr'    => 'francese',
    'fr_ca' => "francese\ canadese",
    'fr_ch' => "francese\ svizzero",
    'frm'   => "francese\ medio",
    'fro'   => "francese\ antico",
    'frr'   => "frisone\ settentrionale",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'friulano',
    'fy'    => 'frisone',
    'ga'    => 'irlandese',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaya',
    'gd'    => "gaelico\ scozzese",
    'gem'   => "lingua\ germanica",
    'gez'   => 'geez',
    'gil'   => 'gilbertese',
    'gl'    => 'galiziano',
    'gmh'   => "tedesco\ medio\ alto",
    'gn'    => 'guarana',
    'goh'   => "tedesco\ antico\ alto",
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gotico',
    'grb'   => 'gerbo',
    'grc'   => "greco\ antico",
    'gsw'   => "tedesco\ svizzero",
    'gu'    => 'gujarati',
    'gv'    => 'manx',
    'gwi'   => 'gwichʼin',
    'ha'    => 'haussa',
    'hai'   => 'haida',
    'haw'   => 'hawaiano',
    'he'    => 'ebraico',
    'hi'    => 'hindi',
    'hil'   => 'hiligayna',
    'him'   => 'himachali',
    'hit'   => 'hittite',
    'hmn'   => 'hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'croato',
    'hsb'   => "alto\ sorabo",
    'ht'    => 'haitiano',
    'hu'    => 'ungherese',
    'hup'   => 'hupa',
    'hy'    => 'armeno',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'iban',
    'id'    => 'indonesiano',
    'ie'    => 'interlingue',
    'ig'    => 'igbo',
    'ii'    => "sichuan\ yi",
    'ijo'   => 'Ijo',
    'ik'    => 'inupiak',
    'ilo'   => 'ilocano',
    'inc'   => "lingua\ indiana",
    'ine'   => "lingua\ indoeuropea",
    'inh'   => 'ingush',
    'io'    => 'ido',
    'ira'   => 'iraniana',
    'iro'   => "lingue\ irochesi",
    'is'    => 'islandese',
    'it'    => 'italiano',
    'iu'    => 'inuktitut',
    'ja'    => 'giapponese',
    'jbo'   => 'lojban',
    'jpr'   => "giudeo\ persiano",
    'jrb'   => "giudeo\ arabo",
    'jv'    => 'giavanese',
    'ka'    => 'georgiano',
    'kaa'   => "kara\-kalpak",
    'kab'   => 'kabyle',
    'kac'   => 'kachin',
    'kaj'   => 'kai',
    'kam'   => 'kamba',
    'kar'   => 'karen',
    'kaw'   => 'kawi',
    'kbd'   => 'kabardia',
    'kcg'   => 'tyap',
    'kfo'   => 'kfo',
    'kg'    => 'kongo',
    'kha'   => 'khasi',
    'khi'   => "lingua\ khoisan",
    'kho'   => 'khotanese',
    'ki'    => 'kikuyu',
    'kj'    => 'kuanyama',
    'kk'    => 'kazako',
    'kl'    => 'kalaallisut',
    'km'    => 'khmer',
    'kmb'   => 'kimbundu',
    'kn'    => 'kannada',
    'ko'    => 'coreano',
    'kok'   => 'konkani',
    'kos'   => 'kosraean',
    'kpe'   => 'kpelle',
    'kr'    => 'kanuri',
    'krc'   => "karachay\-Balkar",
    'krl'   => 'careliano',
    'kro'   => 'kru',
    'kru'   => 'kurukh',
    'ks'    => 'kashmiri',
    'ku'    => 'curdo',
    'kum'   => 'kumyk',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'cornico',
    'ky'    => 'kirghiso',
    'la'    => 'latino',
    'lad'   => 'ladino',
    'lah'   => 'lahnda',
    'lam'   => 'lamba',
    'lb'    => 'lussemburghese',
    'lez'   => 'lezghian',
    'lg'    => 'ganda',
    'li'    => 'limburgese',
    'ln'    => 'lingala',
    'lo'    => 'lao',
    'lol'   => "lolo\ bantu",
    'loz'   => 'lozi',
    'lt'    => 'lituano',
    'lu'    => "luba\-katanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luiseno',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lushai',
    'lv'    => 'lettone',
    'mad'   => 'madurese',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'makasar',
    'man'   => 'mandingo',
    'map'   => 'austronesiano',
    'mas'   => 'masai',
    'mdf'   => 'moksha',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'malgascio',
    'mga'   => "irlandese\ medio",
    'mh'    => 'marshallese',
    'mi'    => 'maori',
    'mic'   => 'micmac',
    'min'   => 'menangkabau',
    'mis'   => "lingue\ diverse",
    'mk'    => 'macedone',
    'mkh'   => "lingua\ mon\-khmer",
    'ml'    => 'malayalam',
    'mn'    => 'mongolo',
    'mnc'   => 'manchu',
    'mni'   => 'manipuri',
    'mno'   => 'manobo',
    'mo'    => 'moldavo',
    'moh'   => 'mohawk',
    'mos'   => 'mossi',
    'mr'    => 'marathi',
    'ms'    => 'malese',
    'mt'    => 'maltese',
    'mul'   => 'multilingua',
    'mun'   => "lingua\ munda",
    'mus'   => 'creek',
    'mwl'   => 'mirandese',
    'mwr'   => 'marwari',
    'my'    => 'birmano',
    'myn'   => "lingue\ maya",
    'myv'   => 'erzya',
    'na'    => 'nauru',
    'nah'   => 'nahuatl',
    'nai'   => "lingua\ indiana\ del\ Nord\ America",
    'nap'   => 'napoletano',
    'nb'    => "norvegese\ bokmal",
    'nd'    => "ndebele\ del\ nord",
    'nds'   => "basso\ tedesco",
    'ne'    => 'nepalese',
    'new'   => 'newari',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => "lingua\ niger\-cordofan",
    'niu'   => 'niue',
    'nl'    => 'olandese',
    'nl_be' => "fiammingo\ belga",
    'nn'    => "norvegese\ nynorsk",
    'no'    => 'norvegese',
    'nog'   => 'nogai',
    'non'   => "norse\ antico",
    'nqo'   => "n\'ko",
    'nr'    => "ndebele\ del\ sud",
    'nso'   => "sotho\ del\ nord",
    'nub'   => 'nubiano',
    'nv'    => 'navajo',
    'nwc'   => "newari\ classico",
    'ny'    => 'nyanja',
    'nym'   => 'nyamwezi',
    'nyn'   => 'nyankole',
    'nyo'   => 'nyoro',
    'nzi'   => 'nzima',
    'oc'    => 'occitano',
    'oj'    => 'ojibwa',
    'om'    => 'oromo',
    'or'    => 'oriya',
    'os'    => 'ossetico',
    'osa'   => 'osage',
    'ota'   => "turco\ ottomano",
    'oto'   => "lingue\ otomi",
    'pa'    => 'punjabi',
    'paa'   => "lingua\ papuana",
    'pag'   => 'pangasinan',
    'pal'   => 'pahlavi',
    'pam'   => 'pampanga',
    'pap'   => 'papiamento',
    'pau'   => 'palau',
    'peo'   => "persiano\ antico",
    'phi'   => "lingua\ filippina",
    'phn'   => 'fenicio',
    'pi'    => 'pali',
    'pl'    => 'polacco',
    'pon'   => 'ponape',
    'pra'   => 'pracrito',
    'pro'   => "provenzale\ antico",
    'ps'    => 'pashto',
    'pt'    => 'portoghese',
    'pt_br' => "portoghese\ brasiliano",
    'pt_pt' => "portoghese\ del\ Portogallo",
    'qu'    => 'quechua',
    'raj'   => 'rajasthani',
    'rap'   => 'rapanui',
    'rar'   => 'rarotonga',
    'rm'    => "lingua\ rhaeto\-romance",
    'rn'    => 'rundi',
    'ro'    => 'rumeno',
    'roa'   => "lingua\ romanza",
    'rom'   => 'romani',
    'ru'    => 'russo',
    'rup'   => 'arumeno',
    'rw'    => 'kinyarwanda',
    'sa'    => 'sanscrito',
    'sad'   => 'sandawe',
    'sah'   => 'yakut',
    'sai'   => "lingua\ indiana\ del\ Sud\ America",
    'sal'   => "lingue\ salish",
    'sam'   => "aramaico\ samaritano",
    'sas'   => 'sasak',
    'sat'   => 'santali',
    'sc'    => 'sardo',
    'scn'   => 'siciliano',
    'sco'   => 'scozzese',
    'sd'    => 'sindhi',
    'se'    => "sami\ del\ nord",
    'sel'   => 'selkup',
    'sem'   => "lingua\ semitica",
    'sg'    => 'sango',
    'sga'   => "irlandese\ antico",
    'sgn'   => "lingue\ sign",
    'sh'    => "serbo\-croato",
    'shn'   => 'shan',
    'si'    => 'singalese',
    'sid'   => 'sidamo',
    'sio'   => "lingue\ sioux",
    'sit'   => "lingua\ sino\-tibetana",
    'sk'    => 'slovacco',
    'sl'    => 'sloveno',
    'sla'   => "lingua\ slava",
    'sm'    => 'samoano',
    'sma'   => "sami\ del\ sud",
    'smi'   => "lingua\ sami",
    'smj'   => "sami\ lule",
    'smn'   => "sami\ inari",
    'sms'   => "sami\ skolt",
    'sn'    => 'shona',
    'snk'   => 'soninke',
    'so'    => 'somalo',
    'sog'   => 'sogdiano',
    'son'   => 'songhai',
    'sq'    => 'albanese',
    'sr'    => 'serbo',
    'srn'   => "sranan\ tongo",
    'srr'   => 'serer',
    'ss'    => 'swati',
    'ssa'   => "lingua\ nilo\-sahariana",
    'st'    => "sotho\ del\ sud",
    'su'    => 'sundanese',
    'suk'   => 'sukuma',
    'sus'   => 'susu',
    'sux'   => 'sumero',
    'sv'    => 'svedese',
    'sw'    => 'swahili',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'siriaco',
    'ta'    => 'tamil',
    'tai'   => "lingua\ tailandese",
    'te'    => 'telugu',
    'tem'   => 'temne',
    'ter'   => 'tereno',
    'tet'   => 'tetum',
    'tg'    => 'tagicco',
    'th'    => 'thai',
    'ti'    => 'tigrinya',
    'tig'   => 'tigre',
    'tiv'   => 'tiv',
    'tk'    => 'turcomanno',
    'tkl'   => 'tokelau',
    'tl'    => 'tagalog',
    'tlh'   => 'klingon',
    'tli'   => 'tlingit',
    'tmh'   => 'tamashek',
    'tn'    => 'tswana',
    'to'    => 'tonga',
    'tog'   => "nyasa\ del\ Tonga",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turco',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimshian',
    'tt'    => 'tatarico',
    'tum'   => 'tumbuka',
    'tup'   => "lingue\ tupi",
    'tut'   => "lingua\ altaica",
    'tvl'   => 'tuvalu',
    'tw'    => 'ci',
    'ty'    => 'taitiano',
    'tyv'   => 'tuvinian',
    'udm'   => 'udmurt',
    'ug'    => 'uigurico',
    'uga'   => 'ugaritico',
    'uk'    => 'ucraino',
    'umb'   => 'mbundu',
    'und'   => "lingua\ imprecisata",
    'ur'    => 'urdu',
    'uz'    => 'usbeco',
    'vai'   => 'vai',
    've'    => 'venda',
    'vi'    => 'vietnamita',
    'vo'    => 'volapük',
    'vot'   => 'voto',
    'wa'    => 'vallone',
    'wak'   => "lingue\ wakash",
    'wal'   => 'walamo',
    'war'   => 'waray',
    'was'   => 'washo',
    'wen'   => 'sorabo',
    'wo'    => 'volof',
    'xal'   => 'kalmyk',
    'xh'    => 'xosa',
    'yao'   => "yao\ \(bantu\)",
    'yap'   => 'yapese',
    'yi'    => 'yiddish',
    'yo'    => 'yoruba',
    'ypk'   => "lingue\ yupik",
    'za'    => 'zhuang',
    'zap'   => 'zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'zenaga',
    'zh'    => 'cinese',
    'znd'   => 'zande',
    'zu'    => 'zulu',
    'zun'   => 'zuni',
    'zxx'   => "Nessun\ contenuto\ linguistico",
    'zza'   => 'zaza',
);

%Locales::DB::Language::it::name_to_code = (
    'abkhazian'                        => 'ab',
    'accado'                           => 'akk',
    'accinese'                         => 'ace',
    'acioli'                           => 'ach',
    'adangme'                          => 'ada',
    'adyghe'                           => 'ady',
    'afar'                             => 'aa',
    'afrihili'                         => 'afh',
    'afrikaans'                        => 'af',
    'ainu'                             => 'ain',
    'akan'                             => 'ak',
    'albanese'                         => 'sq',
    'aleuto'                           => 'ale',
    'altaimeridionale'                 => 'alt',
    'altosorabo'                       => 'hsb',
    'altotedescosvizzero'              => 'de_ch',
    'amarico'                          => 'am',
    'angika'                           => 'anp',
    'arabo'                            => 'ar',
    'aragonese'                        => 'an',
    'aramaico'                         => 'arc',
    'aramaicosamaritano'               => 'sam',
    'arapaho'                          => 'arp',
    'araucano'                         => 'arn',
    'armeno'                           => 'hy',
    'aruaco'                           => 'arw',
    'arumeno'                          => 'rup',
    'assamese'                         => 'as',
    'asturiano'                        => 'ast',
    'atsam'                            => 'cch',
    'austronesiano'                    => 'map',
    'avaro'                            => 'av',
    'avestan'                          => 'ae',
    'awadhi'                           => 'awa',
    'aymara'                           => 'ay',
    'azerbaigiano'                     => 'az',
    'balinese'                         => 'ban',
    'bambara'                          => 'bm',
    'banda'                            => 'bad',
    'bantu'                            => 'bnt',
    'basa'                             => 'bas',
    'baschiro'                         => 'ba',
    'basco'                            => 'eu',
    'bassosorabo'                      => 'dsb',
    'bassotedesco'                     => 'nds',
    'batak'                            => 'btk',
    'begia'                            => 'bej',
    'beluci'                           => 'bal',
    'bengalese'                        => 'bn',
    'berbero'                          => 'ber',
    'bhojpuri'                         => 'bho',
    'bicol'                            => 'bik',
    'bielorusso'                       => 'be',
    'bihari'                           => 'bh',
    'bini'                             => 'bin',
    'birmano'                          => 'my',
    'bislama'                          => 'bi',
    'blin'                             => 'byn',
    'blissymbols'                      => 'zbl',
    'bosniaco'                         => 'bs',
    'braj'                             => 'bra',
    'bretone'                          => 'br',
    'bugi'                             => 'bug',
    'bulgaro'                          => 'bg',
    'buriat'                           => 'bua',
    'caddo'                            => 'cad',
    'careliano'                        => 'krl',
    'caribico'                         => 'car',
    'catalano'                         => 'ca',
    'cebuano'                          => 'ceb',
    'ceceno'                           => 'ce',
    'ceco'                             => 'cs',
    'celticaaltralingua'               => 'cel',
    'chamorro'                         => 'ch',
    'cherokee'                         => 'chr',
    'cheyenne'                         => 'chy',
    'chibcha'                          => 'chb',
    'chipewyan'                        => 'chp',
    'choctaw'                          => 'cho',
    'chuukese'                         => 'chk',
    'chuvash'                          => 'cv',
    'ci'                               => 'tw',
    'ciagataico'                       => 'chg',
    'cinese'                           => 'zh',
    'classicalsyriac'                  => 'syc',
    'copto'                            => 'cop',
    'coreano'                          => 'ko',
    'cornico'                          => 'kw',
    'corso'                            => 'co',
    'cree'                             => 'cr',
    'creek'                            => 'mus',
    'creoloopidgin'                    => 'crp',
    'creoloopidginbasatisulfrancese'   => 'cpf',
    'creoloopidginbasatisullinglese'   => 'cpe',
    'creoloopidginbasatisulportoghese' => 'cpp',
    'croato'                           => 'hr',
    'curdo'                            => 'ku',
    'dakota'                           => 'dak',
    'danese'                           => 'da',
    'dargwa'                           => 'dar',
    'dayak'                            => 'day',
    'delaware'                         => 'del',
    'dinca'                            => 'din',
    'diula'                            => 'dyu',
    'divehi'                           => 'dv',
    'dogri'                            => 'doi',
    'dogrib'                           => 'dgr',
    'duala'                            => 'dua',
    'dzongkha'                         => 'dz',
    'easternfrisian'                   => 'frs',
    'ebraico'                          => 'he',
    'efik'                             => 'efi',
    'egizianoantico'                   => 'egy',
    'ekajuka'                          => 'eka',
    'elamitico'                        => 'elx',
    'erzya'                            => 'myv',
    'esperanto'                        => 'eo',
    'estone'                           => 'et',
    'ewe'                              => 'ee',
    'ewondo'                           => 'ewo',
    'fang'                             => 'fan',
    'fanti'                            => 'fat',
    'faroese'                          => 'fo',
    'fenicio'                          => 'phn',
    'fiammingobelga'                   => 'nl_be',
    'figiano'                          => 'fj',
    'filippino'                        => 'fil',
    'finlandese'                       => 'fi',
    'fon'                              => 'fon',
    'francese'                         => 'fr',
    'franceseantico'                   => 'fro',
    'francesecanadese'                 => 'fr_ca',
    'francesemedio'                    => 'frm',
    'francesesvizzero'                 => 'fr_ch',
    'frisone'                          => 'fy',
    'frisonesettentrionale'            => 'frr',
    'friulano'                         => 'fur',
    'fulah'                            => 'ff',
    'ga'                               => 'gaa',
    'gaelicoscozzese'                  => 'gd',
    'galiziano'                        => 'gl',
    'gallese'                          => 'cy',
    'ganda'                            => 'lg',
    'gayo'                             => 'gay',
    'gbaya'                            => 'gba',
    'geez'                             => 'gez',
    'georgiano'                        => 'ka',
    'gerbo'                            => 'grb',
    'gergochinook'                     => 'chn',
    'giapponese'                       => 'ja',
    'giavanese'                        => 'jv',
    'gilbertese'                       => 'gil',
    'giudeoarabo'                      => 'jrb',
    'giudeopersiano'                   => 'jpr',
    'gondi'                            => 'gon',
    'gorontalo'                        => 'gor',
    'gotico'                           => 'got',
    'greco'                            => 'el',
    'grecoantico'                      => 'grc',
    'guarana'                          => 'gn',
    'gujarati'                         => 'gu',
    'gwichʼin'                        => 'gwi',
    'haida'                            => 'hai',
    'haitiano'                         => 'ht',
    'haussa'                           => 'ha',
    'hawaiano'                         => 'haw',
    'herero'                           => 'hz',
    'hiligayna'                        => 'hil',
    'himachali'                        => 'him',
    'hindi'                            => 'hi',
    'hirimotu'                         => 'ho',
    'hittite'                          => 'hit',
    'hmong'                            => 'hmn',
    'hupa'                             => 'hup',
    'iban'                             => 'iba',
    'ido'                              => 'io',
    'igbo'                             => 'ig',
    'ijo'                              => 'ijo',
    'ilocano'                          => 'ilo',
    'indonesiano'                      => 'id',
    'inglese'                          => 'en',
    'ingleseamericano'                 => 'en_us',
    'ingleseantico'                    => 'ang',
    'ingleseaustraliano'               => 'en_au',
    'inglesebritannico'                => 'en_gb',
    'inglesecanadese'                  => 'en_ca',
    'inglesemedio'                     => 'enm',
    'ingush'                           => 'inh',
    'interlingua'                      => 'ia',
    'interlingue'                      => 'ie',
    'inuktitut'                        => 'iu',
    'inupiak'                          => 'ik',
    'iraniana'                         => 'ira',
    'irlandese'                        => 'ga',
    'irlandeseantico'                  => 'sga',
    'irlandesemedio'                   => 'mga',
    'islandese'                        => 'is',
    'italiano'                         => 'it',
    'kabardia'                         => 'kbd',
    'kabyle'                           => 'kab',
    'kachin'                           => 'kac',
    'kai'                              => 'kaj',
    'kalaallisut'                      => 'kl',
    'kalmyk'                           => 'xal',
    'kamba'                            => 'kam',
    'kannada'                          => 'kn',
    'kanuri'                           => 'kr',
    'karachaybalkar'                   => 'krc',
    'karakalpak'                       => 'kaa',
    'karen'                            => 'kar',
    'kashmiri'                         => 'ks',
    'kashubian'                        => 'csb',
    'kawi'                             => 'kaw',
    'kazako'                           => 'kk',
    'kfo'                              => 'kfo',
    'khasi'                            => 'kha',
    'khmer'                            => 'km',
    'khotanese'                        => 'kho',
    'kikuyu'                           => 'ki',
    'kimbundu'                         => 'kmb',
    'kinyarwanda'                      => 'rw',
    'kirghiso'                         => 'ky',
    'klingon'                          => 'tlh',
    'komi'                             => 'kv',
    'kongo'                            => 'kg',
    'konkani'                          => 'kok',
    'kosraean'                         => 'kos',
    'kpelle'                           => 'kpe',
    'kru'                              => 'kro',
    'kuanyama'                         => 'kj',
    'kumyk'                            => 'kum',
    'kurukh'                           => 'kru',
    'kutenai'                          => 'kut',
    'ladino'                           => 'lad',
    'lahnda'                           => 'lah',
    'lamba'                            => 'lam',
    'lao'                              => 'lo',
    'latino'                           => 'la',
    'lettone'                          => 'lv',
    'lezghian'                         => 'lez',
    'limburgese'                       => 'li',
    'lingala'                          => 'ln',
    'linguaafroasiatica'               => 'afa',
    'linguaaltaica'                    => 'tut',
    'linguaartificiale'                => 'art',
    'linguabaltica'                    => 'bat',
    'linguacaucasica'                  => 'cau',
    'linguacuscitica'                  => 'cus',
    'linguadravidica'                  => 'dra',
    'linguafilippina'                  => 'phi',
    'linguagermanica'                  => 'gem',
    'linguaimprecisata'                => 'und',
    'linguaindiana'                    => 'inc',
    'linguaindianadellamericacentrale' => 'cai',
    'linguaindianadelnordamerica'      => 'nai',
    'linguaindianadelsudamerica'       => 'sai',
    'linguaindoeuropea'                => 'ine',
    'linguakhoisan'                    => 'khi',
    'linguamonkhmer'                   => 'mkh',
    'linguamunda'                      => 'mun',
    'linguanigercordofan'              => 'nic',
    'linguanilosahariana'              => 'ssa',
    'linguapapuana'                    => 'paa',
    'linguarhaetoromance'              => 'rm',
    'linguaromanza'                    => 'roa',
    'linguasami'                       => 'smi',
    'linguasemitica'                   => 'sem',
    'linguasinotibetana'               => 'sit',
    'linguaslava'                      => 'sla',
    'linguatailandese'                 => 'tai',
    'linguaungrofinnica'               => 'fiu',
    'linguealgonchine'                 => 'alg',
    'lingueapache'                     => 'apa',
    'lingueathabaska'                  => 'ath',
    'lingueaustraliane'                => 'aus',
    'linguebamileke'                   => 'bai',
    'linguechamic'                     => 'cmc',
    'linguediverse'                    => 'mis',
    'lingueirochesi'                   => 'iro',
    'linguemaya'                       => 'myn',
    'lingueotomi'                      => 'oto',
    'linguesalish'                     => 'sal',
    'linguesign'                       => 'sgn',
    'linguesioux'                      => 'sio',
    'linguetupi'                       => 'tup',
    'linguewakash'                     => 'wak',
    'lingueyupik'                      => 'ypk',
    'lituano'                          => 'lt',
    'lojban'                           => 'jbo',
    'lolobantu'                        => 'lol',
    'lozi'                             => 'loz',
    'lubakatanga'                      => 'lu',
    'lubalulua'                        => 'lua',
    'luiseno'                          => 'lui',
    'lunda'                            => 'lun',
    'luo'                              => 'luo',
    'lushai'                           => 'lus',
    'lussemburghese'                   => 'lb',
    'macedone'                         => 'mk',
    'madurese'                         => 'mad',
    'magahi'                           => 'mag',
    'maithili'                         => 'mai',
    'makasar'                          => 'mak',
    'malayalam'                        => 'ml',
    'malese'                           => 'ms',
    'malgascio'                        => 'mg',
    'maltese'                          => 'mt',
    'manchu'                           => 'mnc',
    'mandar'                           => 'mdr',
    'mandingo'                         => 'man',
    'manipuri'                         => 'mni',
    'manobo'                           => 'mno',
    'manx'                             => 'gv',
    'maori'                            => 'mi',
    'marathi'                          => 'mr',
    'mari'                             => 'chm',
    'marshallese'                      => 'mh',
    'marwari'                          => 'mwr',
    'masai'                            => 'mas',
    'mbundu'                           => 'umb',
    'menangkabau'                      => 'min',
    'mende'                            => 'men',
    'micmac'                           => 'mic',
    'mirandese'                        => 'mwl',
    'mohawk'                           => 'moh',
    'moksha'                           => 'mdf',
    'moldavo'                          => 'mo',
    'mongolo'                          => 'mn',
    'morisyen'                         => 'mfe',
    'mossi'                            => 'mos',
    'multilingua'                      => 'mul',
    'nahuatl'                          => 'nah',
    'napoletano'                       => 'nap',
    'nauru'                            => 'na',
    'navajo'                           => 'nv',
    'ndebeledelnord'                   => 'nd',
    'ndebeledelsud'                    => 'nr',
    'ndonga'                           => 'ng',
    'nepalese'                         => 'ne',
    'nessuncontenutolinguistico'       => 'zxx',
    'newari'                           => 'new',
    'newariclassico'                   => 'nwc',
    'nias'                             => 'nia',
    'niue'                             => 'niu',
    'nko'                              => 'nqo',
    'nogai'                            => 'nog',
    'norseantico'                      => 'non',
    'norvegese'                        => 'no',
    'norvegesebokmal'                  => 'nb',
    'norvegesenynorsk'                 => 'nn',
    'nubiano'                          => 'nub',
    'nyamwezi'                         => 'nym',
    'nyanja'                           => 'ny',
    'nyankole'                         => 'nyn',
    'nyasadeltonga'                    => 'tog',
    'nyoro'                            => 'nyo',
    'nzima'                            => 'nzi',
    'occitano'                         => 'oc',
    'ojibwa'                           => 'oj',
    'olandese'                         => 'nl',
    'olandesemedio'                    => 'dum',
    'oriya'                            => 'or',
    'oromo'                            => 'om',
    'osage'                            => 'osa',
    'ossetico'                         => 'os',
    'pahlavi'                          => 'pal',
    'palau'                            => 'pau',
    'pali'                             => 'pi',
    'pampanga'                         => 'pam',
    'pangasinan'                       => 'pag',
    'papiamento'                       => 'pap',
    'pashto'                           => 'ps',
    'persiano'                         => 'fa',
    'persianoantico'                   => 'peo',
    'polacco'                          => 'pl',
    'ponape'                           => 'pon',
    'portoghese'                       => 'pt',
    'portoghesebrasiliano'             => 'pt_br',
    'portoghesedelportogallo'          => 'pt_pt',
    'pracrito'                         => 'pra',
    'provenzaleantico'                 => 'pro',
    'punjabi'                          => 'pa',
    'quechua'                          => 'qu',
    'rajasthani'                       => 'raj',
    'rapanui'                          => 'rap',
    'rarotonga'                        => 'rar',
    'romani'                           => 'rom',
    'rumeno'                           => 'ro',
    'rundi'                            => 'rn',
    'russo'                            => 'ru',
    'samidelnord'                      => 'se',
    'samidelsud'                       => 'sma',
    'samiinari'                        => 'smn',
    'samilule'                         => 'smj',
    'samiskolt'                        => 'sms',
    'samoano'                          => 'sm',
    'sandawe'                          => 'sad',
    'sango'                            => 'sg',
    'sanscrito'                        => 'sa',
    'santali'                          => 'sat',
    'sardo'                            => 'sc',
    'sasak'                            => 'sas',
    'scozzese'                         => 'sco',
    'selkup'                           => 'sel',
    'serbo'                            => 'sr',
    'serbocroato'                      => 'sh',
    'serer'                            => 'srr',
    'shan'                             => 'shn',
    'shona'                            => 'sn',
    'sichuanyi'                        => 'ii',
    'siciliano'                        => 'scn',
    'sidamo'                           => 'sid',
    'siksika'                          => 'bla',
    'sindhi'                           => 'sd',
    'singalese'                        => 'si',
    'siriaco'                          => 'syr',
    'slave'                            => 'den',
    'slavodellachiesa'                 => 'cu',
    'slovacco'                         => 'sk',
    'sloveno'                          => 'sl',
    'sogdiano'                         => 'sog',
    'somalo'                           => 'so',
    'songhai'                          => 'son',
    'soninke'                          => 'snk',
    'sorabo'                           => 'wen',
    'sothodelnord'                     => 'nso',
    'sothodelsud'                      => 'st',
    'spagnolo'                         => 'es',
    'spagnolodellaspagna'              => 'es_es',
    'sranantongo'                      => 'srn',
    'sukuma'                           => 'suk',
    'sumero'                           => 'sux',
    'sundanese'                        => 'su',
    'susu'                             => 'sus',
    'svedese'                          => 'sv',
    'swahili'                          => 'sw',
    'swati'                            => 'ss',
    'tagalog'                          => 'tl',
    'tagicco'                          => 'tg',
    'taitiano'                         => 'ty',
    'tamashek'                         => 'tmh',
    'tamil'                            => 'ta',
    'taroko'                           => 'trv',
    'tatarico'                         => 'tt',
    'tedesco'                          => 'de',
    'tedescoanticoalto'                => 'goh',
    'tedescoaustriaco'                 => 'de_at',
    'tedescomedioalto'                 => 'gmh',
    'tedescosvizzero'                  => 'gsw',
    'telugu'                           => 'te',
    'temne'                            => 'tem',
    'tereno'                           => 'ter',
    'tetum'                            => 'tet',
    'thai'                             => 'th',
    'tibetano'                         => 'bo',
    'tigre'                            => 'tig',
    'tigrinya'                         => 'ti',
    'tiv'                              => 'tiv',
    'tlingit'                          => 'tli',
    'tokelau'                          => 'tkl',
    'tokpisin'                         => 'tpi',
    'tonga'                            => 'to',
    'tsimshian'                        => 'tsi',
    'tsonga'                           => 'ts',
    'tswana'                           => 'tn',
    'tumbuka'                          => 'tum',
    'turco'                            => 'tr',
    'turcocrimeo'                      => 'crh',
    'turcomanno'                       => 'tk',
    'turcoottomano'                    => 'ota',
    'tuvalu'                           => 'tvl',
    'tuvinian'                         => 'tyv',
    'tyap'                             => 'kcg',
    'ucraino'                          => 'uk',
    'udmurt'                           => 'udm',
    'ugaritico'                        => 'uga',
    'uigurico'                         => 'ug',
    'ungherese'                        => 'hu',
    'urdu'                             => 'ur',
    'usbeco'                           => 'uz',
    'vai'                              => 'vai',
    'vallone'                          => 'wa',
    'venda'                            => 've',
    'vietnamita'                       => 'vi',
    'volapük'                         => 'vo',
    'volof'                            => 'wo',
    'voto'                             => 'vot',
    'walamo'                           => 'wal',
    'waray'                            => 'war',
    'washo'                            => 'was',
    'wemba'                            => 'bem',
    'xosa'                             => 'xh',
    'yakut'                            => 'sah',
    'yaobantu'                         => 'yao',
    'yapese'                           => 'yap',
    'yiddish'                          => 'yi',
    'yoruba'                           => 'yo',
    'zande'                            => 'znd',
    'zapotec'                          => 'zap',
    'zaza'                             => 'zza',
    'zenaga'                           => 'zen',
    'zhuang'                           => 'za',
    'zulu'                             => 'zu',
    'zuni'                             => 'zun',
);

1;
