package Locales::DB::Language::fr;

# Auto generated from CLDR

$Locales::DB::Language::fr::VERSION = '0.06';

$Locales::DB::Language::fr::cldr_version = '1.7.2';

%Locales::DB::Language::fr::misc_info = (
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => undef,
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'language'                => "langue\ \:\ \{0\}",
        'locale'                  => "\{0\}\ \(\{1\}\)",
        'percent'                 => "\#\,\#\#0 \%",
        'territory'               => "région\ \:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "non\:n",
        'yesstr' => "oui\:o"
    },
);

%Locales::DB::Language::fr::code_to_name = (
    'aa'    => 'afar',
    'ab'    => 'abkhaze',
    'ace'   => 'aceh',
    'ach'   => 'acoli',
    'ada'   => 'adangme',
    'ady'   => 'adyghéen',
    'ae'    => 'avestique',
    'af'    => 'afrikaans',
    'afa'   => "langue\ afro\-asiatique",
    'afh'   => 'afrihili',
    'ain'   => 'aïnou',
    'ak'    => 'akan',
    'akk'   => 'akkadien',
    'ale'   => 'aléoute',
    'alg'   => "langue\ algonquienne",
    'alt'   => "altaï\ du\ Sud",
    'am'    => 'amharique',
    'an'    => 'aragonais',
    'ang'   => "ancien\ anglais",
    'anp'   => 'angika',
    'apa'   => "langue\ apache",
    'ar'    => 'arabe',
    'arc'   => 'araméen',
    'arn'   => 'araukan',
    'arp'   => 'arapaho',
    'art'   => "langue\ artificielle",
    'arw'   => 'arawak',
    'as'    => 'assamais',
    'ast'   => 'asturien',
    'ath'   => "langue\ athapascane",
    'aus'   => "langue\ australienne",
    'av'    => 'avar',
    'awa'   => 'awadhi',
    'ay'    => 'aymara',
    'az'    => 'azéri',
    'ba'    => 'bachkir',
    'bad'   => 'banda',
    'bai'   => "langue\ bamilékée",
    'bal'   => 'baloutchi',
    'ban'   => 'balinais',
    'bas'   => 'bassa',
    'bat'   => "langue\ balte",
    'be'    => 'biélorusse',
    'bej'   => 'bedja',
    'bem'   => 'bemba',
    'ber'   => 'berbère',
    'bg'    => 'bulgare',
    'bh'    => "langue\ biharie",
    'bho'   => 'bhojpuri',
    'bi'    => 'bichelamar',
    'bik'   => 'bikol',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengali',
    'bnt'   => 'bantou',
    'bo'    => 'tibétain',
    'br'    => 'breton',
    'bra'   => 'braj',
    'bs'    => 'bosniaque',
    'btk'   => 'batak',
    'bua'   => 'bouriate',
    'bug'   => 'bugi',
    'byn'   => 'blin',
    'ca'    => 'catalan',
    'cad'   => 'caddo',
    'cai'   => "langue\ amérindienne\ centrale",
    'car'   => 'caribe',
    'cau'   => "langue\ caucasienne",
    'cch'   => 'atsam',
    'ce'    => 'tchétchène',
    'ceb'   => 'cebuano',
    'cel'   => "langue\ celtique",
    'ch'    => 'chamorro',
    'chb'   => 'chibcha',
    'chg'   => 'tchaghataï',
    'chk'   => 'chuukais',
    'chm'   => 'mari',
    'chn'   => "jargon\ chinook",
    'cho'   => 'choctaw',
    'chp'   => 'chipewyan',
    'chr'   => 'chérokî',
    'chy'   => 'cheyenne',
    'cmc'   => "langue\ chame",
    'co'    => 'corse',
    'cop'   => 'copte',
    'cpe'   => "créole\ ou\ pidgin\ anglais",
    'cpf'   => "créole\ ou\ pidgin\ français",
    'cpp'   => "créole\ ou\ pidgin\ portugais",
    'cr'    => 'cree',
    'crh'   => "turc\ de\ Crimée",
    'crp'   => "créole\ ou\ pidgin",
    'cs'    => 'tchèque',
    'csb'   => 'kachoube',
    'cu'    => "slavon\ d’église",
    'cus'   => "langue\ couchitique",
    'cv'    => 'tchouvache',
    'cy'    => 'gallois',
    'da'    => 'danois',
    'dak'   => 'dakota',
    'dar'   => 'dargwa',
    'day'   => "langue\ bidayuh",
    'de'    => 'allemand',
    'de_at' => "allemand\ autrichien",
    'de_ch' => "allemand\ suisse",
    'del'   => 'lenape',
    'den'   => 'slavey',
    'dgr'   => "flanc\-de\-chien",
    'din'   => 'dinka',
    'doi'   => "dogri\-kangri",
    'dra'   => "langue\ dravidienne",
    'dsb'   => "bas\-sorabe",
    'dua'   => 'douala',
    'dum'   => "moyen\ néerlandais",
    'dv'    => 'maldivien',
    'dyu'   => 'dioula',
    'dz'    => 'dzongkha',
    'ee'    => 'éwé',
    'efi'   => 'efik',
    'egy'   => "égyptien\ ancien",
    'eka'   => 'ekajuk',
    'el'    => 'grec',
    'elx'   => 'élamite',
    'en'    => 'anglais',
    'en_au' => "anglais\ australien",
    'en_ca' => "anglais\ canadien",
    'en_gb' => "anglais\ britannique",
    'en_us' => "anglais\ américain",
    'enm'   => "moyen\ anglais",
    'eo'    => 'espéranto',
    'es'    => 'espagnol',
    'es_es' => "espagnol\ ibérique",
    'et'    => 'estonien',
    'eu'    => 'basque',
    'ewo'   => 'éwondo',
    'fa'    => 'persan',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'peul',
    'fi'    => 'finnois',
    'fil'   => 'filipino',
    'fiu'   => "langue\ finno\-ougrienne",
    'fj'    => 'fidjien',
    'fo'    => 'féringien',
    'fon'   => 'fon',
    'fr'    => 'français',
    'fr_ca' => "français\ canadien",
    'fr_ch' => "français\ suisse",
    'frm'   => "moyen\ français",
    'fro'   => "ancien\ français",
    'frr'   => "frison\ du\ Nord",
    'frs'   => "frison\ oriental",
    'fur'   => 'frioulan',
    'fy'    => "frison\ occidental",
    'ga'    => 'irlandais',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaya',
    'gd'    => "gaélique\ écossais",
    'gem'   => "langue\ germanique",
    'gez'   => 'guèze',
    'gil'   => 'gilbertin',
    'gl'    => 'galicien',
    'gmh'   => "moyen\ haut\-allemand",
    'gn'    => 'guarani',
    'goh'   => "ancien\ haut\-allemand",
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gotique',
    'grb'   => 'grébo',
    'grc'   => "grec\ ancien",
    'gsw'   => 'alémanique',
    'gu'    => 'goudjarâtî',
    'gv'    => 'mannois',
    'gwi'   => 'gwichʼin',
    'ha'    => 'haoussa',
    'hai'   => 'haïda',
    'haw'   => 'hawaïen',
    'he'    => 'hébreu',
    'hi'    => 'hindi',
    'hil'   => 'hiligaynon',
    'him'   => 'himachali',
    'hit'   => 'hittite',
    'hmn'   => 'hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'croate',
    'hsb'   => "haut\-sorabe",
    'ht'    => 'haïtien',
    'hu'    => 'hongrois',
    'hup'   => 'hupa',
    'hy'    => 'arménien',
    'hz'    => 'héréro',
    'ia'    => 'interlingua',
    'iba'   => 'iban',
    'id'    => 'indonésien',
    'ie'    => 'interlingue',
    'ig'    => 'igbo',
    'ii'    => "yi\ de\ Sichuan",
    'ijo'   => 'ijo',
    'ik'    => 'inupiaq',
    'ilo'   => 'ilokano',
    'inc'   => "langue\ indo\-aryenne",
    'ine'   => "langue\ indo\-européenne",
    'inh'   => 'ingouche',
    'io'    => 'ido',
    'ira'   => "langue\ iranienne",
    'iro'   => "langue\ iroquoienne",
    'is'    => 'islandais',
    'it'    => 'italien',
    'iu'    => 'inuktitut',
    'ja'    => 'japonais',
    'jbo'   => 'lojban',
    'jpr'   => "judéo\-persan",
    'jrb'   => "judéo\-arabe",
    'jv'    => 'javanais',
    'ka'    => 'géorgien',
    'kaa'   => 'karakalpak',
    'kab'   => 'kabyle',
    'kac'   => 'kachin',
    'kaj'   => 'jju',
    'kam'   => 'kamba',
    'kar'   => "langue\ karène",
    'kaw'   => 'kawi',
    'kbd'   => 'kabardin',
    'kcg'   => 'tyap',
    'kfo'   => 'koro',
    'kg'    => 'kongo',
    'kha'   => 'khasi',
    'khi'   => "langue\ khoïsane",
    'kho'   => 'khotanais',
    'ki'    => 'kikuyu',
    'kj'    => 'kuanyama',
    'kk'    => 'kazakh',
    'kl'    => 'groenlandais',
    'km'    => 'khmer',
    'kmb'   => 'kimboundou',
    'kn'    => 'kannara',
    'ko'    => 'coréen',
    'kok'   => 'konkani',
    'kos'   => 'kusaïen',
    'kpe'   => 'kpellé',
    'kr'    => 'kanouri',
    'krc'   => "karatchaï\ balkar",
    'krl'   => 'carélien',
    'kro'   => 'krou',
    'kru'   => 'kurukh',
    'ks'    => 'cachemiri',
    'ku'    => 'kurde',
    'kum'   => 'koumyk',
    'kut'   => 'kutenaï',
    'kv'    => 'komi',
    'kw'    => 'cornique',
    'ky'    => 'kirghize',
    'la'    => 'latin',
    'lad'   => 'ladino',
    'lah'   => 'lahnda',
    'lam'   => 'lamba',
    'lb'    => 'luxembourgeois',
    'lez'   => 'lezghien',
    'lg'    => 'ganda',
    'li'    => 'limbourgeois',
    'ln'    => 'lingala',
    'lo'    => 'lao',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'lituanien',
    'lu'    => "luba\-katanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luiseno',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lushaï',
    'lv'    => 'letton',
    'mad'   => 'madurais',
    'mag'   => 'magahi',
    'mai'   => 'maïthilî',
    'mak'   => 'makassar',
    'man'   => 'mandingue',
    'map'   => "langue\ malayo\-polynésienne",
    'mas'   => 'massaï',
    'mdf'   => 'mokcha',
    'mdr'   => 'mandar',
    'men'   => 'mendé',
    'mfe'   => 'Morisyen',
    'mg'    => 'malgache',
    'mga'   => "moyen\ irlandais",
    'mh'    => 'marshallais',
    'mi'    => 'maori',
    'mic'   => 'micmac',
    'min'   => 'minangkabau',
    'mis'   => "langue\ diverse",
    'mk'    => 'macédonien',
    'mkh'   => "langue\ mon\-khmère",
    'ml'    => 'malayalam',
    'mn'    => 'mongol',
    'mnc'   => 'mandchou',
    'mni'   => 'manipourî',
    'mno'   => "langue\ manobo",
    'mo'    => 'moldave',
    'moh'   => 'mohawk',
    'mos'   => 'moré',
    'mr'    => 'marathe',
    'ms'    => 'malais',
    'mt'    => 'maltais',
    'mul'   => 'multilingue',
    'mun'   => "langue\ mounda",
    'mus'   => 'creek',
    'mwl'   => 'mirandais',
    'mwr'   => 'marwarî',
    'my'    => 'birman',
    'myn'   => "langue\ maya",
    'myv'   => 'erzya',
    'na'    => 'nauruan',
    'nah'   => 'nahuatl',
    'nai'   => "langue\ amérindienne\ du\ Nord",
    'nap'   => 'napolitain',
    'nb'    => "norvégien\ bokmål",
    'nd'    => "ndébélé\ du\ Nord",
    'nds'   => "bas\-allemand",
    'ne'    => 'népalais',
    'new'   => 'newari',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => "langue\ nigéro\-congolaise",
    'niu'   => 'niouéen',
    'nl'    => 'néerlandais',
    'nl_be' => "néerlandais\ belge",
    'nn'    => "norvégien\ nynorsk",
    'no'    => 'norvégien',
    'nog'   => 'nogaï',
    'non'   => "vieux\ norrois",
    'nqo'   => 'n’ko',
    'nr'    => "ndébélé\ du\ Sud",
    'nso'   => "sotho\ du\ Nord",
    'nub'   => "langue\ nubienne",
    'nv'    => 'navaho',
    'nwc'   => "newarî\ classique",
    'ny'    => 'nyanja',
    'nym'   => 'nyamwezi',
    'nyn'   => 'nyankolé',
    'nyo'   => 'nyoro',
    'nzi'   => 'nzema',
    'oc'    => 'occitan',
    'oj'    => 'ojibwé',
    'om'    => 'oromo',
    'or'    => 'oriya',
    'os'    => 'ossète',
    'osa'   => 'osage',
    'ota'   => "turc\ ottoman",
    'oto'   => "langue\ otomangue",
    'pa'    => 'pendjabi',
    'paa'   => "langue\ papoue",
    'pag'   => 'pangasinan',
    'pal'   => 'pahlavi',
    'pam'   => 'pampangan',
    'pap'   => 'papiamento',
    'pau'   => 'paluan',
    'peo'   => "ancien\ persan",
    'phi'   => "langue\ philippine",
    'phn'   => 'phénicien',
    'pi'    => 'pâli',
    'pl'    => 'polonais',
    'pon'   => 'pohnpeï',
    'pra'   => "langue\ prâkrit",
    'pro'   => "ancien\ provençal",
    'ps'    => 'pachto',
    'pt'    => 'portugais',
    'pt_br' => "portugais\ brésilien",
    'pt_pt' => "portugais\ ibérique",
    'qu'    => 'quechua',
    'raj'   => 'rajasthani',
    'rap'   => 'rapanui',
    'rar'   => 'rarotongien',
    'rm'    => "rhéto\-roman",
    'rn'    => 'roundi',
    'ro'    => 'roumain',
    'roa'   => "langue\ romane",
    'rom'   => 'romani',
    'ru'    => 'russe',
    'rup'   => 'aroumain',
    'rw'    => 'rwanda',
    'sa'    => 'sanskrit',
    'sad'   => 'sandawe',
    'sah'   => 'iakoute',
    'sai'   => "langue\ amérindienne\ du\ Sud",
    'sal'   => "langue\ salishenne",
    'sam'   => "araméen\ samaritain",
    'sas'   => 'sasak',
    'sat'   => 'santal',
    'sc'    => 'sarde',
    'scn'   => 'sicilien',
    'sco'   => 'écossais',
    'sd'    => 'sindhî',
    'se'    => "sami\ du\ Nord",
    'sel'   => 'selkoupe',
    'sem'   => "langue\ sémitique",
    'sg'    => 'sangho',
    'sga'   => "ancien\ irlandais",
    'sgn'   => "langue\ des\ signes",
    'sh'    => "serbo\-croate",
    'shn'   => 'shan',
    'si'    => 'cinghalais',
    'sid'   => 'sidamo',
    'sio'   => "langue\ sioux",
    'sit'   => "langue\ sino\-tibétaine",
    'sk'    => 'slovaque',
    'sl'    => 'slovène',
    'sla'   => "langue\ slave",
    'sm'    => 'samoan',
    'sma'   => "sami\ du\ Sud",
    'smi'   => "langue\ samie",
    'smj'   => "sami\ de\ Lule",
    'smn'   => "sami\ d’Inari",
    'sms'   => "sami\ skolt",
    'sn'    => 'shona',
    'snk'   => 'soninké',
    'so'    => 'somali',
    'sog'   => 'sogdien',
    'son'   => 'songhaï',
    'sq'    => 'albanais',
    'sr'    => 'serbe',
    'srn'   => "sranan\ tongo",
    'srr'   => 'sérère',
    'ss'    => 'swati',
    'ssa'   => "langue\ nilo\-saharienne",
    'st'    => 'sesotho',
    'su'    => 'soundanais',
    'suk'   => 'sukuma',
    'sus'   => 'soussou',
    'sux'   => 'sumérien',
    'sv'    => 'suédois',
    'sw'    => 'swahili',
    'syc'   => "syriaque\ classique",
    'syr'   => 'syriaque',
    'ta'    => 'tamoul',
    'tai'   => "langue\ taïe",
    'te'    => 'télougou',
    'tem'   => 'temne',
    'ter'   => 'tereno',
    'tet'   => 'tétoum',
    'tg'    => 'tadjik',
    'th'    => 'thaï',
    'ti'    => 'tigrigna',
    'tig'   => 'tigré',
    'tiv'   => 'tivi',
    'tk'    => 'turkmène',
    'tkl'   => 'tokelauan',
    'tl'    => 'tagalog',
    'tlh'   => 'klingon',
    'tli'   => 'tlingit',
    'tmh'   => 'tamacheq',
    'tn'    => 'tswana',
    'to'    => 'tongan',
    'tog'   => "tonga\ nyasa",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turc',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimshian',
    'tt'    => 'tatar',
    'tum'   => 'tumbuka',
    'tup'   => "langue\ tupie",
    'tut'   => "langue\ altaïque",
    'tvl'   => 'tuvaluan',
    'tw'    => 'twi',
    'ty'    => 'tahitien',
    'tyv'   => 'touva',
    'udm'   => 'oudmourte',
    'ug'    => 'ouïgour',
    'uga'   => 'ougaritique',
    'uk'    => 'ukrainien',
    'umb'   => 'oumboundou',
    'und'   => "langue\ indéterminée",
    'ur'    => 'ourdou',
    'uz'    => 'ouzbek',
    'vai'   => 'vaï',
    've'    => 'venda',
    'vi'    => 'vietnamien',
    'vo'    => 'volapük',
    'vot'   => 'vote',
    'wa'    => 'wallon',
    'wak'   => "langue\ wakashenne",
    'wal'   => 'walamo',
    'war'   => 'waray',
    'was'   => 'washo',
    'wen'   => "langue\ sorabe",
    'wo'    => 'wolof',
    'xal'   => 'kalmouk',
    'xh'    => 'xhosa',
    'yao'   => 'yao',
    'yap'   => 'yapois',
    'yi'    => 'yiddish',
    'yo'    => 'yoruba',
    'ypk'   => "langue\ yupik",
    'za'    => 'zhouang',
    'zap'   => 'zapotèque',
    'zbl'   => "symboles\ Bliss",
    'zen'   => 'zenaga',
    'zh'    => 'chinois',
    'znd'   => 'zandé',
    'zu'    => 'zoulou',
    'zun'   => 'zuni',
    'zxx'   => "\(sans\ contenu\ linguistique\)",
    'zza'   => 'zazaki',
);

%Locales::DB::Language::fr::name_to_code = (
    'abkhaze'                     => 'ab',
    'aceh'                        => 'ace',
    'acoli'                       => 'ach',
    'adangme'                     => 'ada',
    'adyghéen'                   => 'ady',
    'afar'                        => 'aa',
    'afrihili'                    => 'afh',
    'afrikaans'                   => 'af',
    'akan'                        => 'ak',
    'akkadien'                    => 'akk',
    'albanais'                    => 'sq',
    'allemand'                    => 'de',
    'allemandautrichien'          => 'de_at',
    'allemandsuisse'              => 'de_ch',
    'altaïdusud'                 => 'alt',
    'alémanique'                 => 'gsw',
    'aléoute'                    => 'ale',
    'amharique'                   => 'am',
    'ancienanglais'               => 'ang',
    'ancienfrançais'             => 'fro',
    'ancienhautallemand'          => 'goh',
    'ancienirlandais'             => 'sga',
    'ancienpersan'                => 'peo',
    'ancienprovençal'            => 'pro',
    'angika'                      => 'anp',
    'anglais'                     => 'en',
    'anglaisaméricain'           => 'en_us',
    'anglaisaustralien'           => 'en_au',
    'anglaisbritannique'          => 'en_gb',
    'anglaiscanadien'             => 'en_ca',
    'arabe'                       => 'ar',
    'aragonais'                   => 'an',
    'araméen'                    => 'arc',
    'araméensamaritain'          => 'sam',
    'arapaho'                     => 'arp',
    'araukan'                     => 'arn',
    'arawak'                      => 'arw',
    'arménien'                   => 'hy',
    'aroumain'                    => 'rup',
    'assamais'                    => 'as',
    'asturien'                    => 'ast',
    'atsam'                       => 'cch',
    'avar'                        => 'av',
    'avestique'                   => 'ae',
    'awadhi'                      => 'awa',
    'aymara'                      => 'ay',
    'azéri'                      => 'az',
    'aïnou'                      => 'ain',
    'bachkir'                     => 'ba',
    'balinais'                    => 'ban',
    'baloutchi'                   => 'bal',
    'bambara'                     => 'bm',
    'banda'                       => 'bad',
    'bantou'                      => 'bnt',
    'basallemand'                 => 'nds',
    'basque'                      => 'eu',
    'bassa'                       => 'bas',
    'bassorabe'                   => 'dsb',
    'batak'                       => 'btk',
    'bedja'                       => 'bej',
    'bemba'                       => 'bem',
    'bengali'                     => 'bn',
    'berbère'                    => 'ber',
    'bhojpuri'                    => 'bho',
    'bichelamar'                  => 'bi',
    'bikol'                       => 'bik',
    'bini'                        => 'bin',
    'birman'                      => 'my',
    'biélorusse'                 => 'be',
    'blin'                        => 'byn',
    'bosniaque'                   => 'bs',
    'bouriate'                    => 'bua',
    'braj'                        => 'bra',
    'breton'                      => 'br',
    'bugi'                        => 'bug',
    'bulgare'                     => 'bg',
    'cachemiri'                   => 'ks',
    'caddo'                       => 'cad',
    'caribe'                      => 'car',
    'carélien'                   => 'krl',
    'catalan'                     => 'ca',
    'cebuano'                     => 'ceb',
    'chamorro'                    => 'ch',
    'cheyenne'                    => 'chy',
    'chibcha'                     => 'chb',
    'chinois'                     => 'zh',
    'chipewyan'                   => 'chp',
    'choctaw'                     => 'cho',
    'chuukais'                    => 'chk',
    'chérokî'                   => 'chr',
    'cinghalais'                  => 'si',
    'copte'                       => 'cop',
    'cornique'                    => 'kw',
    'corse'                       => 'co',
    'coréen'                     => 'ko',
    'cree'                        => 'cr',
    'creek'                       => 'mus',
    'croate'                      => 'hr',
    'créoleoupidgin'             => 'crp',
    'créoleoupidginanglais'      => 'cpe',
    'créoleoupidginfrançais'    => 'cpf',
    'créoleoupidginportugais'    => 'cpp',
    'dakota'                      => 'dak',
    'danois'                      => 'da',
    'dargwa'                      => 'dar',
    'dinka'                       => 'din',
    'dioula'                      => 'dyu',
    'dogrikangri'                 => 'doi',
    'douala'                      => 'dua',
    'dzongkha'                    => 'dz',
    'efik'                        => 'efi',
    'ekajuk'                      => 'eka',
    'erzya'                       => 'myv',
    'espagnol'                    => 'es',
    'espagnolibérique'           => 'es_es',
    'espéranto'                  => 'eo',
    'estonien'                    => 'et',
    'fang'                        => 'fan',
    'fanti'                       => 'fat',
    'fidjien'                     => 'fj',
    'filipino'                    => 'fil',
    'finnois'                     => 'fi',
    'flancdechien'                => 'dgr',
    'fon'                         => 'fon',
    'français'                   => 'fr',
    'françaiscanadien'           => 'fr_ca',
    'françaissuisse'             => 'fr_ch',
    'frioulan'                    => 'fur',
    'frisondunord'                => 'frr',
    'frisonoccidental'            => 'fy',
    'frisonoriental'              => 'frs',
    'féringien'                  => 'fo',
    'ga'                          => 'gaa',
    'galicien'                    => 'gl',
    'gallois'                     => 'cy',
    'ganda'                       => 'lg',
    'gayo'                        => 'gay',
    'gaéliqueécossais'          => 'gd',
    'gbaya'                       => 'gba',
    'gilbertin'                   => 'gil',
    'gondi'                       => 'gon',
    'gorontalo'                   => 'gor',
    'gotique'                     => 'got',
    'goudjarâtî'                => 'gu',
    'grec'                        => 'el',
    'grecancien'                  => 'grc',
    'groenlandais'                => 'kl',
    'grébo'                      => 'grb',
    'guarani'                     => 'gn',
    'guèze'                      => 'gez',
    'gwichʼin'                   => 'gwi',
    'géorgien'                   => 'ka',
    'haoussa'                     => 'ha',
    'hautsorabe'                  => 'hsb',
    'hawaïen'                    => 'haw',
    'haïda'                      => 'hai',
    'haïtien'                    => 'ht',
    'hiligaynon'                  => 'hil',
    'himachali'                   => 'him',
    'hindi'                       => 'hi',
    'hirimotu'                    => 'ho',
    'hittite'                     => 'hit',
    'hmong'                       => 'hmn',
    'hongrois'                    => 'hu',
    'hupa'                        => 'hup',
    'hébreu'                     => 'he',
    'héréro'                    => 'hz',
    'iakoute'                     => 'sah',
    'iban'                        => 'iba',
    'ido'                         => 'io',
    'igbo'                        => 'ig',
    'ijo'                         => 'ijo',
    'ilokano'                     => 'ilo',
    'indonésien'                 => 'id',
    'ingouche'                    => 'inh',
    'interlingua'                 => 'ia',
    'interlingue'                 => 'ie',
    'inuktitut'                   => 'iu',
    'inupiaq'                     => 'ik',
    'irlandais'                   => 'ga',
    'islandais'                   => 'is',
    'italien'                     => 'it',
    'japonais'                    => 'ja',
    'jargonchinook'               => 'chn',
    'javanais'                    => 'jv',
    'jju'                         => 'kaj',
    'judéoarabe'                 => 'jrb',
    'judéopersan'                => 'jpr',
    'kabardin'                    => 'kbd',
    'kabyle'                      => 'kab',
    'kachin'                      => 'kac',
    'kachoube'                    => 'csb',
    'kalmouk'                     => 'xal',
    'kamba'                       => 'kam',
    'kannara'                     => 'kn',
    'kanouri'                     => 'kr',
    'karakalpak'                  => 'kaa',
    'karatchaïbalkar'            => 'krc',
    'kawi'                        => 'kaw',
    'kazakh'                      => 'kk',
    'khasi'                       => 'kha',
    'khmer'                       => 'km',
    'khotanais'                   => 'kho',
    'kikuyu'                      => 'ki',
    'kimboundou'                  => 'kmb',
    'kirghize'                    => 'ky',
    'klingon'                     => 'tlh',
    'komi'                        => 'kv',
    'kongo'                       => 'kg',
    'konkani'                     => 'kok',
    'koro'                        => 'kfo',
    'koumyk'                      => 'kum',
    'kpellé'                     => 'kpe',
    'krou'                        => 'kro',
    'kuanyama'                    => 'kj',
    'kurde'                       => 'ku',
    'kurukh'                      => 'kru',
    'kusaïen'                    => 'kos',
    'kutenaï'                    => 'kut',
    'ladino'                      => 'lad',
    'lahnda'                      => 'lah',
    'lamba'                       => 'lam',
    'langueafroasiatique'         => 'afa',
    'languealgonquienne'          => 'alg',
    'languealtaïque'             => 'tut',
    'langueamérindiennecentrale' => 'cai',
    'langueamérindiennedunord'   => 'nai',
    'langueamérindiennedusud'    => 'sai',
    'langueapache'                => 'apa',
    'langueartificielle'          => 'art',
    'langueathapascane'           => 'ath',
    'langueaustralienne'          => 'aus',
    'languebalte'                 => 'bat',
    'languebamilékée'           => 'bai',
    'languebidayuh'               => 'day',
    'languebiharie'               => 'bh',
    'languecaucasienne'           => 'cau',
    'langueceltique'              => 'cel',
    'languechame'                 => 'cmc',
    'languecouchitique'           => 'cus',
    'languedessignes'             => 'sgn',
    'languediverse'               => 'mis',
    'languedravidienne'           => 'dra',
    'languefinnoougrienne'        => 'fiu',
    'languegermanique'            => 'gem',
    'langueindoaryenne'           => 'inc',
    'langueindoeuropéenne'       => 'ine',
    'langueindéterminée'        => 'und',
    'langueiranienne'             => 'ira',
    'langueiroquoienne'           => 'iro',
    'languekarène'               => 'kar',
    'languekhoïsane'             => 'khi',
    'languemalayopolynésienne'   => 'map',
    'languemanobo'                => 'mno',
    'languemaya'                  => 'myn',
    'languemonkhmère'            => 'mkh',
    'languemounda'                => 'mun',
    'languenigérocongolaise'     => 'nic',
    'languenilosaharienne'        => 'ssa',
    'languenubienne'              => 'nub',
    'langueotomangue'             => 'oto',
    'languepapoue'                => 'paa',
    'languephilippine'            => 'phi',
    'langueprâkrit'              => 'pra',
    'langueromane'                => 'roa',
    'languesalishenne'            => 'sal',
    'languesamie'                 => 'smi',
    'languesinotibétaine'        => 'sit',
    'languesioux'                 => 'sio',
    'langueslave'                 => 'sla',
    'languesorabe'                => 'wen',
    'languesémitique'            => 'sem',
    'languetaïe'                 => 'tai',
    'languetupie'                 => 'tup',
    'languewakashenne'            => 'wak',
    'langueyupik'                 => 'ypk',
    'lao'                         => 'lo',
    'latin'                       => 'la',
    'lenape'                      => 'del',
    'letton'                      => 'lv',
    'lezghien'                    => 'lez',
    'limbourgeois'                => 'li',
    'lingala'                     => 'ln',
    'lituanien'                   => 'lt',
    'lojban'                      => 'jbo',
    'lozi'                        => 'loz',
    'lubakatanga'                 => 'lu',
    'lubalulua'                   => 'lua',
    'luiseno'                     => 'lui',
    'lunda'                       => 'lun',
    'luo'                         => 'luo',
    'lushaï'                     => 'lus',
    'luxembourgeois'              => 'lb',
    'macédonien'                 => 'mk',
    'madurais'                    => 'mad',
    'magahi'                      => 'mag',
    'makassar'                    => 'mak',
    'malais'                      => 'ms',
    'malayalam'                   => 'ml',
    'maldivien'                   => 'dv',
    'malgache'                    => 'mg',
    'maltais'                     => 'mt',
    'mandar'                      => 'mdr',
    'mandchou'                    => 'mnc',
    'mandingue'                   => 'man',
    'manipourî'                  => 'mni',
    'mannois'                     => 'gv',
    'maori'                       => 'mi',
    'marathe'                     => 'mr',
    'mari'                        => 'chm',
    'marshallais'                 => 'mh',
    'marwarî'                    => 'mwr',
    'massaï'                     => 'mas',
    'maïthilî'                  => 'mai',
    'mendé'                      => 'men',
    'micmac'                      => 'mic',
    'minangkabau'                 => 'min',
    'mirandais'                   => 'mwl',
    'mohawk'                      => 'moh',
    'mokcha'                      => 'mdf',
    'moldave'                     => 'mo',
    'mongo'                       => 'lol',
    'mongol'                      => 'mn',
    'morisyen'                    => 'mfe',
    'moré'                       => 'mos',
    'moyenanglais'                => 'enm',
    'moyenfrançais'              => 'frm',
    'moyenhautallemand'           => 'gmh',
    'moyenirlandais'              => 'mga',
    'moyennéerlandais'           => 'dum',
    'multilingue'                 => 'mul',
    'nahuatl'                     => 'nah',
    'napolitain'                  => 'nap',
    'nauruan'                     => 'na',
    'navaho'                      => 'nv',
    'ndonga'                      => 'ng',
    'ndébélédunord'            => 'nd',
    'ndébélédusud'             => 'nr',
    'newari'                      => 'new',
    'newarîclassique'            => 'nwc',
    'nias'                        => 'nia',
    'niouéen'                    => 'niu',
    'nogaï'                      => 'nog',
    'norvégien'                  => 'no',
    'norvégienbokmål'           => 'nb',
    'norvégiennynorsk'           => 'nn',
    'nyamwezi'                    => 'nym',
    'nyanja'                      => 'ny',
    'nyankolé'                   => 'nyn',
    'nyoro'                       => 'nyo',
    'nzema'                       => 'nzi',
    'néerlandais'                => 'nl',
    'néerlandaisbelge'           => 'nl_be',
    'népalais'                   => 'ne',
    'n’ko'                      => 'nqo',
    'occitan'                     => 'oc',
    'ojibwé'                     => 'oj',
    'oriya'                       => 'or',
    'oromo'                       => 'om',
    'osage'                       => 'osa',
    'ossète'                     => 'os',
    'oudmourte'                   => 'udm',
    'ougaritique'                 => 'uga',
    'oumboundou'                  => 'umb',
    'ourdou'                      => 'ur',
    'ouzbek'                      => 'uz',
    'ouïgour'                    => 'ug',
    'pachto'                      => 'ps',
    'pahlavi'                     => 'pal',
    'paluan'                      => 'pau',
    'pampangan'                   => 'pam',
    'pangasinan'                  => 'pag',
    'papiamento'                  => 'pap',
    'pendjabi'                    => 'pa',
    'persan'                      => 'fa',
    'peul'                        => 'ff',
    'phénicien'                  => 'phn',
    'pohnpeï'                    => 'pon',
    'polonais'                    => 'pl',
    'portugais'                   => 'pt',
    'portugaisbrésilien'         => 'pt_br',
    'portugaisibérique'          => 'pt_pt',
    'pâli'                       => 'pi',
    'quechua'                     => 'qu',
    'rajasthani'                  => 'raj',
    'rapanui'                     => 'rap',
    'rarotongien'                 => 'rar',
    'rhétoroman'                 => 'rm',
    'romani'                      => 'rom',
    'roumain'                     => 'ro',
    'roundi'                      => 'rn',
    'russe'                       => 'ru',
    'rwanda'                      => 'rw',
    'samidelule'                  => 'smj',
    'samidunord'                  => 'se',
    'samidusud'                   => 'sma',
    'samid’inari'               => 'smn',
    'samiskolt'                   => 'sms',
    'samoan'                      => 'sm',
    'sandawe'                     => 'sad',
    'sangho'                      => 'sg',
    'sanscontenulinguistique'     => 'zxx',
    'sanskrit'                    => 'sa',
    'santal'                      => 'sat',
    'sarde'                       => 'sc',
    'sasak'                       => 'sas',
    'selkoupe'                    => 'sel',
    'serbe'                       => 'sr',
    'serbocroate'                 => 'sh',
    'sesotho'                     => 'st',
    'shan'                        => 'shn',
    'shona'                       => 'sn',
    'sicilien'                    => 'scn',
    'sidamo'                      => 'sid',
    'siksika'                     => 'bla',
    'sindhî'                     => 'sd',
    'slavey'                      => 'den',
    'slavond’église'           => 'cu',
    'slovaque'                    => 'sk',
    'slovène'                    => 'sl',
    'sogdien'                     => 'sog',
    'somali'                      => 'so',
    'songhaï'                    => 'son',
    'soninké'                    => 'snk',
    'sothodunord'                 => 'nso',
    'soundanais'                  => 'su',
    'soussou'                     => 'sus',
    'sranantongo'                 => 'srn',
    'sukuma'                      => 'suk',
    'sumérien'                   => 'sux',
    'suédois'                    => 'sv',
    'swahili'                     => 'sw',
    'swati'                       => 'ss',
    'symbolesbliss'               => 'zbl',
    'syriaque'                    => 'syr',
    'syriaqueclassique'           => 'syc',
    'sérère'                    => 'srr',
    'tadjik'                      => 'tg',
    'tagalog'                     => 'tl',
    'tahitien'                    => 'ty',
    'tamacheq'                    => 'tmh',
    'tamoul'                      => 'ta',
    'taroko'                      => 'trv',
    'tatar'                       => 'tt',
    'tchaghataï'                 => 'chg',
    'tchouvache'                  => 'cv',
    'tchèque'                    => 'cs',
    'tchétchène'                => 'ce',
    'temne'                       => 'tem',
    'tereno'                      => 'ter',
    'thaï'                       => 'th',
    'tibétain'                   => 'bo',
    'tigrigna'                    => 'ti',
    'tigré'                      => 'tig',
    'tivi'                        => 'tiv',
    'tlingit'                     => 'tli',
    'tokelauan'                   => 'tkl',
    'tokpisin'                    => 'tpi',
    'tongan'                      => 'to',
    'tonganyasa'                  => 'tog',
    'touva'                       => 'tyv',
    'tsimshian'                   => 'tsi',
    'tsonga'                      => 'ts',
    'tswana'                      => 'tn',
    'tumbuka'                     => 'tum',
    'turc'                        => 'tr',
    'turcdecrimée'               => 'crh',
    'turcottoman'                 => 'ota',
    'turkmène'                   => 'tk',
    'tuvaluan'                    => 'tvl',
    'twi'                         => 'tw',
    'tyap'                        => 'kcg',
    'télougou'                   => 'te',
    'tétoum'                     => 'tet',
    'ukrainien'                   => 'uk',
    'vaï'                        => 'vai',
    'venda'                       => 've',
    'vietnamien'                  => 'vi',
    'vieuxnorrois'                => 'non',
    'volapük'                    => 'vo',
    'vote'                        => 'vot',
    'walamo'                      => 'wal',
    'wallon'                      => 'wa',
    'waray'                       => 'war',
    'washo'                       => 'was',
    'wolof'                       => 'wo',
    'xhosa'                       => 'xh',
    'yao'                         => 'yao',
    'yapois'                      => 'yap',
    'yiddish'                     => 'yi',
    'yidesichuan'                 => 'ii',
    'yoruba'                      => 'yo',
    'zandé'                      => 'znd',
    'zapotèque'                  => 'zap',
    'zazaki'                      => 'zza',
    'zenaga'                      => 'zen',
    'zhouang'                     => 'za',
    'zoulou'                      => 'zu',
    'zuni'                        => 'zun',
    'écossais'                   => 'sco',
    'égyptienancien'             => 'egy',
    'élamite'                    => 'elx',
    'éwondo'                     => 'ewo',
    'éwé'                       => 'ee',
);

1;
