/*
 * Decompiled with CFR 0.152.
 */
package org.ttt.salt;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.ttt.salt.dom.tbx.TBXElement;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XCSValidationException
extends Exception
implements Comparable<XCSValidationException> {
    public static final String RCSID = "$Id: XCSValidationException.java 159 2012-11-26 19:51:19Z lanhel $";
    private static int exceptionCount;
    private final int order = exceptionCount++;
    private final Element elem;

    public XCSValidationException(Element e) {
        this.elem = e;
    }

    protected Element element() {
        return this.elem;
    }

    @Override
    public String getMessage() {
        return "XCSValidationException " + this.buildContext();
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    @Override
    public int compareTo(XCSValidationException o) {
        return this.order - o.order;
    }

    protected String buildContext() {
        String ret;
        ResourceBundle bundle = ResourceBundle.getBundle("org.ttt.salt.XCSValidationException");
        Element term = this.elem;
        while (!term.getTagName().equals("termEntry")) {
            term = (Element)term.getParentNode();
        }
        Object[] args = new Object[4];
        args[2] = this.elem;
        args[3] = this.elem instanceof TBXElement ? ((TBXElement)this.elem).getLocationString() : "Line: ??";
        String id = term.getAttribute("id");
        if (id.equals("") || id.startsWith("AUTO_termEntry_ID_")) {
            args[0] = "TODO";
            args[1] = "TODO";
            args[2] = this.elem;
            ret = MessageFormat.format(bundle.getString("NoTermEntry"), args);
        } else {
            args[0] = id;
            ret = MessageFormat.format(bundle.getString("TermEntry"), args);
        }
        return ret;
    }
}

