package Configure::Step;

use strict;
use vars qw($description @args);
use Parrot::Configure::Step ':inter';

use Config;

$description = <<'END';
Thanks.  Now I need a little information on certain types.
Same rules as the last section.
END

@args=qw(defaults intval opcode floatval);

sub runstep {
  my %args;
  @args{@args}=@_;
  
  my $intval=$Config{ivtype}   || 'long';
  my $floatval=$Config{nvtype} || 'double';
  my $opcode=$Config{ivtype}   || 'long';
  
  $intval=$args{intval}     if defined $args{intval};
  $floatval=$args{floatval} if defined $args{floatval};
  $opcode=$args{opcode}     if defined $args{opcode};

  unless($args{defaults}) {
    $intval=prompt("How big would you like your integers to be?", $intval);
    $floatval=prompt("And your floats?", $floatval);
    $opcode=prompt("What's your native opcode type?", $opcode);
  }
  
  Configure::Data->set(
    iv       => $intval,
    nv       => $floatval,
    opcode_t => $opcode
  );
}

1;