package main;
use FindBin;
use lib "$FindBin::Bin/lib";
use Evo::Base -strict;

# check 'lib' dir
use UAP;

my $ua             = UAP::->new;
my $ioloop         = Mojo::IOLoop->singleton;
my $AWESOME_PERSON = 'http://alexbyk.com';

# this is just a little example
# visit site of the awesome person, get a link to my blog and visit it.
# With progress notifications!
#
# see the same example using dsl in ua-promises-dsl.pl

$ua->get($AWESOME_PERSON)
  ->then(sub($res) { $ua->get($res->dom->at('a')->{href}) })

  ->then(
  sub($res) { say "content: ", substr($res->body, 0, 300); },
  sub($reason) { warn "Rejected:  $reason"; },
  sub($res)    { say "[progress] ${\$res->content->progress} bytes"; },
  )

  # done, because we've already handler a rejection in prev then
  ->then(sub { $ioloop->stop });

# show that we're non blocking
my $i = 0;
$ioloop->recurring(0.2 => sub { say '[timer] ', $i += 0.2, ' secs passed' });
$ioloop->start;
