/* stats.c, coding statistics                                               */

/* Copyright (C) 1994, MPEG Software Simulation Group. All Rights Reserved. */

/*
 * Disclaimer of Warranty
 *
 * These software programs are available to the user without any license fee or
 * royalty on an "as is" basis.  The MPEG Software Simulation Group disclaims
 * any and all warranties, whether express, implied, or statuary, including any
 * implied warranties or merchantability or of fitness for a particular
 * purpose.  In no event shall the copyright-holder be liable for any
 * incidental, punitive, or consequential damages of any kind whatsoever
 * arising from the use of these programs.
 *
 * This disclaimer of warranty extends to the user of these programs and user's
 * customers, employees, agents, transferees, successors, and assigns.
 *
 * The MPEG Software Simulation Group does not represent or warrant that the
 * programs furnished hereunder are free of infringement of any third-party
 * patents.
 *
 * Commercial implementations of MPEG-1 and MPEG-2 video, including shareware,
 * are subject to royalty fees to patent holders.  Many of these patents are
 * general enough such that they are unavoidable regardless of implementation
 * design.
 *
 */

#include <stdio.h>
#include <math.h>
#include "config.h"
#include "global.h"

void calcSNR(org,rec)
unsigned char *org[3];
unsigned char *rec[3];
{
  int i, j;
  double v1, s1, s2, e2;
  unsigned char *porg, *prec;

  s1 = s2 = e2 = 0.0;

  for (j=0; j<vertical_size; j++)
  {
    porg = org[0] + j*width;
    prec = rec[0] + j*width;

    for (i=0; i<horizontal_size; i++)
    {
      v1 = porg[i];
      s1+= v1;
      s2+= v1*v1;
      v1-= prec[i];
      e2+= v1*v1;
    }
  }

  s1/= horizontal_size*vertical_size;
  s2/= horizontal_size*vertical_size;
  e2/= horizontal_size*vertical_size;
  s2-= s1*s1;

  fprintf(statfile,"Y: variance=%3.3g, MSE=%3.3g (%3.3g dB), SNR=%3.3g dB\n",
    s2,e2,10.0*log10(255.0*255.0/e2),10.0*log10(s2/e2));

  s1 = s2 = e2 = 0.0;

  for (j=0; j<(vertical_size>>1); j++)
  {
    porg = org[1] + j*(width>>1);
    prec = rec[1] + j*(width>>1);

    for (i=0; i<(horizontal_size>>1); i++)
    {
      v1 = porg[i];
      s1+= v1;
      s2+= v1*v1;
      v1-= prec[i];
      e2+= v1*v1;
    }
  }

  s1/= horizontal_size*vertical_size/4;
  s2/= horizontal_size*vertical_size/4;
  e2/= horizontal_size*vertical_size/4;
  s2-= s1*s1;

  fprintf(statfile,"U: variance=%3.3g, MSE=%3.3g (%3.3g dB), SNR=%3.3g dB\n",
    s2,e2,10.0*log10(255.0*255.0/e2),10.0*log10(s2/e2));

  s1 = s2 = e2 = 0.0;

  for (j=0; j<(vertical_size>>1); j++)
  {
    porg = org[2] + j*(width>>1);
    prec = rec[2] + j*(width>>1);
    for (i=0; i<(horizontal_size>>1); i++)
    {
      v1 = porg[i];
      s1+= v1;
      s2+= v1*v1;
      v1-= prec[i];
      e2+= v1*v1;
    }
  }

  s1/= horizontal_size*vertical_size/4;
  s2/= horizontal_size*vertical_size/4;
  e2/= horizontal_size*vertical_size/4;
  s2-= s1*s1;

  fprintf(statfile,"V: variance=%3.3g, MSE=%3.3g (%3.3g dB), SNR=%3.3g dB\n",
    s2,e2,10.0*log10(255.0*255.0/e2),10.0*log10(s2/e2));
}

void stats()
{
  int i, j, k, nmb, mb_type;
  int n_skipped, n_intra, n_ncoded, n_interp, n_forward, n_backward;
  struct mbinfo *mbi;

  nmb = mb_width*mb_height;

  n_skipped=n_intra=n_ncoded=n_interp=n_forward=n_backward=0;

  for (k=0; k<nmb; k++)
  {
    mbi = mbinfo+k;
    if (mbi->skipped)
      n_skipped++;
    else if (mbi->mb_type & MB_INTRA)
      n_intra++;
    else if (!(mbi->mb_type & MB_PATTERN))
      n_ncoded++;

    if (mbi->mb_type & MB_FORWARD)
    {
      if (mbi->mb_type & MB_BACKWARD)
        n_interp++;
      else
        n_forward++;
    }
    else if (mbi->mb_type & MB_BACKWARD)
      n_backward++;
  }

  fprintf(statfile,"\nframe statistics:\n");
  fprintf(statfile," # of intra coded macroblocks:  %4d (%.1f%%)\n",
    n_intra,100.0*(double)n_intra/nmb);
  fprintf(statfile," # of not coded macroblocks:    %4d (%.1f%%)\n",
    n_ncoded,100.0*(double)n_ncoded/nmb);
  fprintf(statfile," # of skipped macroblocks:      %4d (%.1f%%)\n",
    n_skipped,100.0*(double)n_skipped/nmb);
  fprintf(statfile," # of forw. pred. macroblocks:  %4d (%.1f%%)\n",
    n_forward,100.0*(double)n_forward/nmb);
  fprintf(statfile," # of backw. pred. macroblocks: %4d (%.1f%%)\n",
    n_backward,100.0*(double)n_backward/nmb);
  fprintf(statfile," # of interpolated macroblocks: %4d (%.1f%%)\n",
    n_interp,100.0*(double)n_interp/nmb);

  fprintf(statfile,"\nmacroblock_type map:\n");

  k = 0;

  for (j=0; j<mb_height; j++)
  {
    for (i=0; i<mb_width; i++)
    {
      mbi = mbinfo + k;
      mb_type = mbi->mb_type;
      if (mbi->skipped)
        putc('S',statfile);
      else if (mb_type & MB_INTRA)
        putc('I',statfile);
      else switch (mb_type & (MB_FORWARD|MB_BACKWARD))
      {
      case MB_FORWARD:
        putc(mbi->motion_type==MC_FRAME?'F':'f',statfile); break;
      case MB_BACKWARD:
        putc(mbi->motion_type==MC_FRAME?'B':'b',statfile); break;
      case MB_FORWARD|MB_BACKWARD:
        putc(mbi->motion_type==MC_FRAME?'D':'d',statfile); break;
      default:
        putc('0',statfile); break;
      }

      if (mb_type & MB_QUANT)
        putc('Q',statfile);
      else if (mb_type & (MB_PATTERN|MB_INTRA))
        putc(' ',statfile);
      else
        putc('N',statfile);

      putc(' ',statfile);

      k++;
    }
    putc('\n',statfile);
  }

  fprintf(statfile,"\nmquant map:\n");

  k=0;
  for (j=0; j<mb_height; j++)
  {
    for (i=0; i<mb_width; i++)
    {
      if (i==0 || mbinfo[k].mquant!=mbinfo[k-1].mquant)
        fprintf(statfile,"%3d",mbinfo[k].mquant);
      else
        fprintf(statfile,"   ");

      k++;
    }
    putc('\n',statfile);
  }
}
