'\"
'\" Copyright (c) 1992 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /user6/ouster/wish/man/RCS/text.n,v 1.12 93/10/23 16:30:35 ouster Exp $ SPRITE (Berkeley)
'/" 
.\" The definitions below are for supplemental macros used in Tcl/Tk
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'       .TH \\$1 1 \\*(^3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\*(^3 \\$4
.if '\\$2'tcl'        .TH \\$1 n \\*(^3 Tcl "Tcl Built-In Commands"
.if '\\$2'tk'         .TH \\$1 n \\*(^3 Tk "Tk Commands"
.if '\\$2'tclc'        .TH \\$1 3 \\*(^3 Tcl "Tcl Library Procedures"
.if '\\$2'tkc'         .TH \\$1 3 \\*(^3 Tk "Tk Library Procedures"
.if '\\$2'tclcmds'         .TH \\$1 1 \\*(^3 Tk "Tcl Applications"
.if '\\$2'tkcmds'         .TH \\$1 1 \\*(^3 Tk "Tk Applications"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS text tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
text \- Create and manipulate text widgets
.SH SYNOPSIS
\fBtext\fI \fIpathName \fR?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBforeground\fR	\fBinsertWidth\fR	\fBselectBorderWidth\fR
\fBborderWidth\fR	\fBinsertBackground\fR	\fBpadX\fR	\fBselectForeground\fR
\fBcursor\fR	\fBinsertBorderWidth\fR	\fBpadY\fR	\fBsetGrid\fR
\fBexportSelection\fR	\fBinsertOffTime\fR	\fBrelief\fR	\fByScrollCommand\fR
\fBfont\fR	\fBinsertOnTime\fR	\fBselectBackground\fR
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB\-height\fR
.fi
.IP
Specifies the desired height for the window, in units of characters.
Must be at least one.
.LP
.nf
Name:	\fBstate\fR
Class:	\fBState\fR
Command-Line Switch:	\fB\-state\fR
.fi
.IP
Specifies one of two states for the text:  \fBnormal\fR or \fBdisabled\fR.
If the text is disabled then characters may not be inserted or deleted
and no insertion cursor will be displayed, even if the input focus is
in the widget.
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB\-width\fR
.fi
.IP
Specifies the desired width for the window in units of characters.
If the font doesn't have a uniform width then the width of the
character ``0'' is used in translating from character units to
screen units.
.LP
.nf
Name:	\fBwrap\fR
Class:	\fBWrap\fR
Command-Line Switch:	\fB\-wrap\fR
.fi
.IP
Specifies how to handle lines in the text that are too long to be
displayed in a single line of the text's window.
The value must be \fBnone\fR or \fBchar\fR or \fBword\fR.
A wrap mode of \fBnone\fR means that each line of text appears as
exactly one line on the screen;  extra characters that don't fit
on the screen are not displayed.
In the other modes each line of text will be broken up into several
screen lines if necessary to keep all the characters visible.
In \fBchar\fR mode a screen line break may occur after any character;
in \fBword\fR mode a line break will only be made at word boundaries.
.BE

.SH DESCRIPTION
.PP
The \fBtext\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a text widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the text such as its default background color
and relief.  The \fBtext\fR command returns the
path name of the new window.
.PP
A text widget displays one or more lines of text and allows that
text to be edited.
Text widgets support three different kinds of annotations on the
text, called tags, marks, and windows.
Tags allow different portions of the text
to be displayed with different fonts and colors.
In addition, Tcl commands can be associated with tags so
that commands are invoked when particular actions such as keystrokes
and mouse button presses occur in particular ranges of the text.
See TAGS below for more details.
.PP
The second form of annotation consists of marks, which are floating
markers in the text.
Marks are used to keep track of various interesting positions in the
text as it is edited.
See MARKS below for more details.
.PP
The third form of annotation allows arbitrary windows to be displayed
in the text widget.
See WINDOWS below for more details.

.SH INDICES
.PP
Many of the widget commands for texts take one or more indices
as arguments.
An index is a string used to indicate a particular place within
a text, such as a place to insert characters or one endpoint of a
range of characters to delete.
Indices have the syntax
.IP
\fIbase modifier modifier modifier ...\fR
.LP
Where \fIbase\fR gives a starting point and the \fImodifier\fRs
adjust the index from the starting point (e.g. move forward or
backward one character).  Every index must contain a \fIbase\fR,
but the \fImodifier\fRs are optional.
.LP
The \fIbase\fR for an index must have one of the following forms:
.TP 12
\fIline\fB.\fIchar\fR
Indicates \fIchar\fR'th character on line \fIline\fR.
Lines are numbered from 1 for consistency with other UNIX programs
that use this numbering scheme.
Within a line, characters are numbered from 0.
.TP 12
\fB@\fIx\fB,\fIy\fR
Indicates the character that covers the pixel whose x and y coordinates
within the text's window are \fIx\fR and \fIy\fR.
.TP 12
\fBend\fR
Indicates the last character in the text, which is always a newline
character.
.TP 12
\fImark\fR
Indicates the character just after the mark whose name is \fImark\fR.
.TP 12
\fItag\fB.first\fR
Indicates the first character in the text that has been tagged with
\fItag\fR.
This form generates an error if no characters are currently tagged
with \fItag\fR.
.TP 12
\fItag\fB.last\fR
Indicates the character just after the last one in the text that has
been tagged with \fItag\fR.
This form generates an error if no characters are currently tagged
with \fItag\fR.
.LP
If modifiers follow the base index, each one of them must have one
of the forms listed below.  Keywords such as \fBchars\fR and \fBwordend\fR
may be abbreviated as long as the abbreviation is unambiguous.
.TP
\fB+ \fIcount\fB chars\fR
Adjust the index forward by \fIcount\fR characters, moving to later
lines in the text if necessary.  If there are fewer than \fIcount\fR
characters in the text after the current index, then set the index
to the last character in the text.
Spaces on either side of \fIcount\fR are optional.
.TP
\fB\- \fIcount\fB chars\fR
Adjust the index backward by \fIcount\fR characters, moving to earlier
lines in the text if necessary.  If there are fewer than \fIcount\fR
characters in the text before the current index, then set the index
to the first character in the text.
Spaces on either side of \fIcount\fR are optional.
.TP
\fB+ \fIcount\fB lines\fR
Adjust the index forward by \fIcount\fR lines, retaining the same
character position within the line.  If there are fewer than \fIcount\fR
lines after the line containing the current index, then set the index
to refer to the same character position on the last line of the text.
Then, if the line is not long enough to contain a character at the indicated
character position, adjust the character position to refer to the last
character of the line (the newline).
Spaces on either side of \fIcount\fR are optional.
.TP
\fB\- \fIcount\fB lines\fR
Adjust the index backward by \fIcount\fR lines, retaining the same
character position within the line.  If there are fewer than \fIcount\fR
lines before the line containing the current index, then set the index
to refer to the same character position on the first line of the text.
Then, if the line is not long enough to contain a character at the indicated
character position, adjust the character position to refer to the last
character of the line (the newline).
Spaces on either side of \fIcount\fR are optional.
.TP
\fBlinestart\fR
Adjust the index to refer to the first character on the line.
.TP
\fBlineend\fR
Adjust the index to refer to the last character on the line (the newline).
.TP
\fBwordstart\fR
Adjust the index to refer to the first character of the word containing
the current index.  A word consists of any number of adjacent characters
that are letters, digits, or underscores, or a single character that
is not one of these.
.TP
\fBwordend\fR
Adjust the index to refer to the character just after the last one of the
word containing the current index.  If the current index refers to the last
character of the text then it is not modified.
.LP
If more than one modifier is present then they are applied in
left-to-right order.  For example, the index ``\fBend \- 1 chars\fR''
refers to the next-to-last character in the text and
``\fBinsert wordstart \- 1 c\fR'' refers to the character just before
the first one in the word containing the insertion cursor.

.SH TAGS
.PP
The first form of annotation in text widgets is a tag.
A tag is a textual string that is associated with some of the characters
in a text.
There may be any number of tags associated with characters in a
text.
Each tag may refer to a single character, a range of characters, or
several ranges of characters.
An individual character may have any number of tags associated with it.
.PP
A priority order is defined among tags, and this order is used in
implementing some of the tag-related functions described below.
When a tag is defined (by associating it with characters or setting
its display options or binding commands to it), it is given
a priority higher than any existing tag.
The priority order of tags may be redefined using the
``\fIpathName \fBtag raise\fR'' and ``\fIpathName \fBtag lower\fR''
widget commands.
.PP
Tags serve three purposes in text widgets.
First, they control the way information is displayed on the screen.
By default, characters are displayed as determined by the
\fBbackground\fR, \fBfont\fR, and \fBforeground\fR options for the
text widget.
However, display options may be associated with individual tags
using the ``\fIpathName \fBtag configure\fR'' widget command.
If a character has been tagged, then the display options associated
with the tag override the default display style.
The following options are currently supported for tags:
.TP
\fB\-background \fIcolor\fR
\fIColor\fR specifies the background color to use for characters
associated with the tag.
It may have any of the forms accepted by \fBTk_GetColor\fR.
.TP
\fB\-bgstipple \fIbitmap\fR
\fIBitmap\fR specifies a bitmap that is used as a stipple pattern
for the background.
It may have any of the forms accepted by \fBTk_GetBitmap\fR.
If \fIbitmap\fR hasn't been specified, or if it is specified
as an empty string, then a solid fill will be used for the
background.
.TP
\fB\-borderwidth \fIpixels\fR
\fIPixels\fR specifies the width of a 3-D border to draw around
the background.
It may have any of the forms accepted by \fBTk_GetPixels\fR.
This option is used in conjunction with the \fB\-relief\fR
option to give a 3-D appearance to the background for characters;
it is ignored unless the \fB\-background\fR option
has been set for the tag.
.TP
\fB\-fgstipple \fIbitmap\fR
\fIBitmap\fR specifies a bitmap that is used as a stipple pattern
when drawing text and other foreground information such as
underlines.
It may have any of the forms accepted by \fBTk_GetBitmap\fR.
If \fIbitmap\fR hasn't been specified, or if it is specified
as an empty string, then a solid fill will be used.
.TP
\fB\-font \fIfontName\fR
\fIFontName\fR is the name of a font to use for drawing characters.
It may have any of the forms accepted by \fBTk_GetFontStruct\fR.
.TP
\fB\-foreground \fIcolor\fR
\fIColor\fR specifies the color to use when drawing text and other
foreground information such as underlines.
It may have any of the forms accepted by \fBTk_GetColor\fR.
.TP
\fB\-relief \fIrelief\fR
\fIRelief specifies the 3-D relief to use for drawing backgrounds,
in any of the forms accepted by \fBTk_GetRelief\fR.
This option is used in conjunction with the \fB\-borderwidth\fR
option to give a 3-D appearance to the background for characters;
it is ignored unless the \fB\-background\fR option
has been set for the tag.
.TP
\fB\-underline \fIboolean\fR
\fIBoolean\fR specifies whether or not to draw an underline underneath
characters.
It may have any of the forms accepted by \fBTk_GetBoolean\fR.
.PP
If a character has several tags associated with it, and if their
display options conflict, then the options of the highest priority
tag are used.
If a particular display option hasn't been specified for a
particular tag, or if it is specified as an empty string, then
that option will never be used;  the next-highest-priority
tag's option will used instead.
If no tag specifies a particular display optionl, then the default
style for the widget will be used.
.PP
The second purpose for tags is event bindings.
You can associate bindings with a tag in much the same way you can
associate bindings with a widget class:  whenever particular X
events occur on characters with the given tag, a given
Tcl command will be executed.
Tag bindings can be used to give behaviors to ranges of characters;
among other things, this allows hypertext-like
features to be implemented.
For details, see the description of the \fBtag bind\fR widget
command below.
.PP
The third use for tags is in managing the selection.
See THE SELECTION below.

.SH MARKS
.PP
The second form of annotation in text widgets is a mark.
Marks are used for remembering particular places in a text.
They are something like tags, in that they have names and
they refer to places in the file, but a mark isn't associated
with particular characters.
Instead, a mark is associated with the gap between two characters.
Only a single position may be associated with a mark at any given
time.
If the characters around a mark are deleted the mark will still
remain;  it will just have new neighbor characters.
In contrast, if the characters containing a tag are deleted then
the tag will no longer have an association with characters in
the file.
Marks may be manipulated with the ``\fIpathName \fBmark\fR'' widget
command, and their current locations may be determined by using the
mark name as an index in widget commands.
.PP
The name space for marks is different from that for tags:  the
same name may be used for both a mark and a tag, but they will refer
to different things.
.PP
Two marks have special significance.
First, the mark \fBinsert\fR is associated with the insertion cursor,
as described under THE INSERTION CURSOR below.
Second, the mark \fBcurrent\fR is associated with the character
closest to the mouse and is adjusted automatically to track the
mouse position and any changes to the text in the widget (one
exception:  \fBcurrent\fR is not updated in response to mouse
motions if a mouse button is down;  the update will be deferred
until all mouse buttons have been released).
Neither of these special marks may be unset.

.SH WINDOWS
.PP
The third form of annotation in text widgets is a window.
Window support isn't implemented yet, but when it is it will be
described here.

.SH THE SELECTION
.PP
Text widgets support the standard X selection.
Selection support is implemented via tags.
If the \fBexportSelection\fR option for the text widget is true
then the \fBsel\fR tag will be associated with the selection:
.IP [1]
Whenever characters are tagged with \fBsel\fR the text widget
will claim ownership of the selection.
.IP [2]
Attempts to retrieve the
selection will be serviced by the text widget, returning all the
charaters with the \fBsel\fR tag.
.IP [3]
If the selection is claimed away by another application or by another
window within this application, then the \fBsel\fR tag will be removed
from all characters in the text.
.PP
The \fBsel\fR tag is automatically defined when a text widget is
created, and it may not be deleted with the ``\fIpathName \fBtag delete\fR''
widget command.  Furthermore, the \fBselectBackground\fR,
\fBselectBorderWidth\fR, and \fBselectForeground\fR options for
the text widget are tied to the \fB\-background\fR,
\fB\-borderwidth\fR, and \fB\-foreground\fR options for the \fBsel\fR
tag:  changes in either will automatically be reflected in the
other.

.SH THE INSERTION CURSOR
.PP
The mark named \fBinsert\fR has special significance in text widgets.
It is defined automatically when a text widget is created and it
may not be unset with the ``\fIpathName \fBmark unset\fR'' widget
command.
The \fBinsert\fR mark represents the position of the insertion
cursor, and the insertion cursor will automatically be drawn at
this point whenever the text widget has the input focus.

.SH "WIDGET COMMAND"
.PP
The \fBtext\fR command creates a new Tcl command whose
name is the same as the path name of the text's window.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIPathName\fR is the name of the command, which is the same as
the text widget's path name.  \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for text widgets:
.TP
\fIpathName \fBcompare\fR \fIindex1 op index2\fR
Compares the indices given by \fIindex1\fR and \fIindex2\fR according
to the relational operator given by \fIop\fR, and returns 1 if
the relationship is satisfied and 0 if it isn't.
\fIOp\fR must be one of the operators <, <=, ==, >=, >, or !=.
If \fIop\fR is == then 1 is returned if the two indices refer to
the same character, if \fIop\fR is < then 1 is returned if \fIindex1\fR
refers to an earlier character in the text than \fIindex2\fR, and
so on.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBtext\fR
command.
.TP
\fIpathName \fBdebug \fR?\fIboolean\fR?
If \fIboolean\fR is specified, then it must have one of the true or
false values accepted by Tcl_GetBoolean.
If the value is a true one then internal consistency checks will be
turned on in the B-tree code associated with text widgets.
If \fIboolean\fR has a false value then the debugging checks will
be turned off.
In either case the command returns an empty string.
If \fIboolean\fR is not specified then the command returns \fBon\fR
or \fBoff\fR to indicate whether or not debugging is turned on.
There is a single debugging switch shared by all text widgets:  turning
debugging on or off in any widget turns it on or off for all widgets.
For widgets with large amounts of text, the consistency checks may
cause a noticeable slow-down.
.TP
\fIpathName \fBdelete \fIindex1 \fR?\fIindex2\fR?
Delete a range of characters from the text.
If both \fIindex1\fR and \fIindex2\fR are specified, then delete
all the characters starting with the one given by \fIindex1\fR
and stopping just before \fIindex2\fR (i.e. the character at
\fIindex2\fR is not deleted).
If \fIindex2\fR doesn't specify a position later in the text
than \fIindex1\fR then no characters are deleted.
If \fIindex2\fR isn't specified then the single character at
\fIindex1\fR is deleted.
It is not allowable to delete characters in a way that would leave
the text without a newline as the last character.
The command returns an empty string.
.TP
\fIpathName \fBget \fIindex1 \fR?\fIindex2\fR?
Return a range of characters from the text.
The return value will be all the characters in the text starting
with the one whose index is \fIindex1\fR and ending just before
the one whose index is \fIindex2\fR (the character at \fIindex2\fR
will not be returned).
If \fIindex2\fR is omitted then the single character at \fIindex1\fR
is returned.
If there are no characters in the specified range (e.g. \fIindex1\fR
is past the end of the file or \fIindex2\fR is less than or equal
to \fIindex1\fR) then an empty string is returned.
.TP
\fIpathName \fBindex \fIindex\fR
Returns the position corresponding to \fIindex\fR in the form
\fIline.char\fR where \fIline\fR is the line number and \fIchar\fR
is the character number.
\fIIndex\fR may have any of the forms described under INDICES above.
.TP
\fIpathName \fBinsert \fIindex chars
Inserts \fIchars\fR into the text just before the character at
\fIindex\fR and returns an empty string.
It is not possible to insert characters after the last newline
of the text.
.TP
\fIpathName \fBmark \fIoption \fR?\fIarg arg ...\fR?
This command is used to manipulate marks.  The exact behavior of
the command depends on the \fIoption\fR argument that follows
the \fBmark\fR argument.  The following forms of the command
are currently supported:
.RS
.TP
\fIpathName \fBmark names\fR
Returns a list whose elements are the names of all the marks that
are currently set.
.TP
\fIpathName \fBmark set \fImarkName index\fR
Sets the mark named \fImarkName\fR to a position just before the
character at \fIindex\fR.
If \fImarkName\fR already exists, it is moved from its old position;
if it doesn't exist, a new mark is created.
This command returns an empty string.
.TP
\fIpathName \fBmark unset \fImarkName \fR?\fImarkName markName ...\fR?
Remove the mark corresponding to each of the \fImarkName\fR arguments.
The removed marks will not be usable in indices and will not be
returned by future calls to ``\fIpathName \fBmark names\fR''.
This command returns an empty string.
.RE
.TP
\fIpathName \fBscan\fR \fIoption args\fR
This command is used to implement scanning on texts.  It has
two forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName \fBscan mark \fIy\fR
Records \fIy\fR and the current view in the text window;  used in
conjunction with later \fBscan dragto\fR commands.  Typically this
command is associated with a mouse button press in the widget.  It
returns an empty string.
.TP
\fIpathName \fBscan dragto \fIy\fR
This command computes the difference between its \fIy\fR argument
and the \fIy\fR argument to the last \fBscan mark\fR command for
the widget.  It then adjusts the view up or down by 10 times the
difference in y-coordinates.  This command is typically associated
with mouse motion events in the widget, to produce the effect of
dragging the text at high speed through the window.  The return
value is an empty string.
.RE
.TP
\fIpathName \fBtag \fIoption \fR?\fIarg arg ...\fR?
This command is used to manipulate tags.  The exact behavior of the
command depends on the \fIoption\fR argument that follows the
\fBtag\fR argument.  The following forms of the command are currently
supported:
.RS
.TP
\fIpathName \fBtag add \fItagName index1 \fR?\fIindex2\fR?
Associate the tag \fItagName\fR with all of the characters starting
with \fIindex1\fR and ending just before
\fIindex2\fR (the character at \fIindex2\fR isn't tagged).
If \fIindex2\fR is omitted then the single character at
\fIindex1\fR is tagged.
If there are no characters in the specified range (e.g. \fIindex1\fR
is past the end of the file or \fIindex2\fR is less than or equal
to \fIindex1\fR) then the command has no effect.
This command returns an empty string.
.TP
\fIpathName \fBtag bind \fItagName\fR ?\fIsequence\fR? ?\fIcommand\fR?
This command associates \fIcommand\fR with the tag given by
\fItagName\fR.
Whenever the event sequence given by \fIsequence\fR occurs for a
character that has been tagged with \fItagName\fR,
the command will be invoked.
This widget command is similar to the \fBbind\fR command except that
it operates on characters in a text rather than entire widgets.
See the \fBbind\fR manual entry for complete details
on the syntax of \fIsequence\fR and the substitutions performed
on \fIcommand\fR before invoking it.
If all arguments are specified then a new binding is created, replacing
any existing binding for the same \fIsequence\fR and \fItagName\fR
(if the first character of \fIcommand\fR is ``+'' then \fIcommand\fR
augments an existing binding rather than replacing it).
In this case the return value is an empty string.
If \fIcommand\fR is omitted then the command returns the \fIcommand\fR
associated with \fItagName\fR and \fIsequence\fR (an error occurs
if there is no such binding).
If both \fIcommand\fR and \fIsequence\fR are omitted then the command
returns a list of all the sequences for which bindings have been
defined for \fItagName\fR.
.RS
.LP
The only events for which bindings may be specified are those related
to the mouse and keyboard, such as \fBEnter\fR, \fBLeave\fR,
\fBButtonPress\fR, \fBMotion\fR, and \fBKeyPress\fR.
Event bindings for a text widget use the \fBcurrent\fR mark
described under MARKS above.
\fBEnter\fR events trigger for a character when it
becomes the current character (i.e. the \fBcurrent\fR mark moves
to just in front of that character).
\fBLeave\fR events trigger for a character when it ceases to be
the current item (i.e. the \fBcurrent\fR mark moves away from
that character, or the character is deleted).
These events are different than \fBEnter\fR and \fBLeave\fR
events for windows.
Mouse and keyboard events are directed to the current character.
.LP
It is possible for the current character to have multiple tags,
and for each of them to have a binding for a particular event
sequence.
When this occurs, the binding from the highest priority tag is
used.
If a particular tag doesn't have a binding that matches an
event, then the tag is ignored and tags with lower priority
will be checked.
.LP
If bindings are created for the widget as a whole using the
\fBbind\fR command, then those bindings will supplement the
tag bindings.
This means that a single event can trigger two Tcl scripts,
one for a widget-level binding and one for a tag-level
binding.
.RE
.TP
\fIpathName \fBtag configure \fItagName\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
This command is similar to the \fBconfigure\fR widget command except
that it modifies options associated with the tag given by \fItagName\fR
instead of modifying options for the overall text widget.
If no \fIoption\fR is specified, the command returns a list describing
all of the available options for \fItagName\fR (see \fBTk_ConfigureInfo\fR
for information on the format of this list).
If \fIoption\fR is specified with no \fIvalue\fR, then the command returns
a list describing the one named option (this list will be identical to
the corresponding sublist of the value returned if no \fIoption\fR
is specified).
If one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s) in \fItagName\fR;
in this case the command returns an empty string.
See TAGS above for details on the options available for tags.
.TP
\fIpathName \fBtag delete \fItagName \fR?\fItagName ...\fR?
Deletes all tag information for each of the \fItagName\fR
arguments.
The command removes the tags from all characters in the file
and also deletes any other information associated with the tags,
such as bindings and display information.
The command returns an empty string.
.TP
\fIpathName\fBtag lower \fItagName \fR?\fIbelowThis\fR?
Changes the priority of tag \fItagName\fR so that it is just lower
in priority than the tag whose name is \fIbelowThis\fR.
If \fIbelowThis\fR is omitted, then \fItagName\fR's priority
is changed to make it lowest priority of all tags.
.TP
\fIpathName \fBtag names \fR?\fIindex\fR?
Returns a list whose elements are the names of all the tags that
are active at the character position given by \fIindex\fR.
If \fIindex\fR is omitted, then the return value will describe
all of the tags that exist for the text (this includes all tags
that have been named in a ``\fIpathName \fBtag\fR'' widget
command but haven't been deleted by a ``\fIpathName \fBtag delete\fR''
widget command, even if no characters are currently marked with
the tag).
The list will be sorted in order from lowest priority to highest
priority.
.TP
\fIpathName \fBtag nextrange \fItagName index1 \fR?\fIindex2\fR?
This command searches the text for a range of characters tagged
with \fItagName\fR where the first character of the range is
no earlier than the character at \fIindex1\fR and no later than
the character just before \fIindex2\fR (a range starting at
\fIindex2\fR will not be considered).
If several matching ranges exist, the first one is chosen.
The command's return value is a list containing
two elements, which are the index of the first character of the
range and the index of the character just after the last one in
the range.
If no matching range is found then the return value is an
empty string.
If \fIindex2\fR is not given then it defaults to the end of the text.
.TP
\fIpathName\fBtag raise \fItagName \fR?\fIaboveThis\fR?
Changes the priority of tag \fItagName\fR so that it is just higher
in priority than the tag whose name is \fIaboveThis\fR.
If \fIaboveThis\fR is omitted, then \fItagName\fR's priority
is changed to make it highest priority of all tags.
.TP
\fIpathName \fBtag ranges \fItagName\fR
Returns a list describing all of the ranges of text that have been
tagged with \fItagName\fR.
The first two elements of the list describe the first tagged range
in the text, the next two elements describe the second range, and
so on.
The first element of each pair contains the index of the first
character of the range, and the second element of the pair contains
the index of the character just after the last one in the
range.
If there are no characters tagged with \fItag\fR then an
empty string is returned.
.TP
\fIpathName \fBtag remove \fItagName index1 \fR?\fIindex2\fR?
Remove the tag \fItagName\fR from all of the characters starting
at \fIindex1\fR and ending just before
\fIindex2\fR (the character at \fIindex2\fR isn't affected).
If \fIindex2\fR is omitted then the single character at
\fIindex1\fR is untagged.
If there are no characters in the specified range (e.g. \fIindex1\fR
is past the end of the file or \fIindex2\fR is less than or equal
to \fIindex1\fR) then the command has no effect.
This command returns an empty string.
.RE
.TP
\fIpathName \fByview \fR?\fB\-pickplace\fR? \fIwhat\fR
This command changes the view in the widget's window so that the line
given by \fIwhat\fR is visible in the window.
\fIWhat\fR may be either an absolute line number, where 0 corresponds
to the first line of the file, or an index with any of the forms
described under INDICES above.
The first form (absolute line number) is used in the commands issued
by scrollbars to control the widget's view.
If the \fB\-pickplace\fR option isn't specified then \fIwhat\fR will
appear at the top of the window.
If \fB\-pickplace\fR is specified then the widget chooses where
\fIwhat\fR appears in the window:
.RS
.IP [1]
If \fIwhat\fR is already visible somewhere in the window then the
command does nothing.
.IP [2]
If \fIwhat\fR is only a few lines off-screen above the window then
it will be positioned at the top of the window.
.IP [3]
If \fIwhat\fR is only a few lines off-screen below the window then
it will be positioned at the bottom of the window.
.IP [4]
Otherwise, \fIwhat\fR will be centered in the window.
.LP
The \fB\-pickplace\fR option is typically used after inserting text
to make sure that the insertion cursor is still visible on the screen.
This command returns an empty string.
.RE

.SH BINDINGS
.PP
Tk automatically creates class bindings for texts that give them
the following default behavior:
.IP [1]
Pressing mouse button 1 in an text positions the insertion cursor
just before the character underneath the mouse cursor and sets the
input focus to this widget.
.IP [2]
Dragging with mouse button 1 strokes out a selection between
the insertion cursor and the character under the mouse.
.IP [3]
If you double-press mouse button 1 then the word under the mouse cursor
will be selected, the insertion cursor will be positioned at the
beginning of the word, and dragging the mouse will stroke out a selection
whole words at a time.
.IP [4]
If you triple-press mouse button 1 then the line under the mouse cursor
will be selected, the insertion cursor will be positioned at the
beginning of the line, and dragging the mouse will stroke out a selection
whole line at a time.
.IP [5]
The ends of the selection can be adjusted by dragging with mouse
button 1 while the shift key is down;  this will adjust the end
of the selection that was nearest to the mouse cursor when button
1 was pressed.  If the selection was made in word or line mode then
it will be adjusted in this same mode.
.IP [6]
The view in the text can be adjusted by dragging with mouse button 2.
.IP [7]
If the input focus is in a text widget and characters are typed on the
keyboard, the characters are inserted just before the insertion cursor.
.IP [8]
Control+h and the Backspace and Delete keys erase the character just
before the insertion cursor.
.IP [9]
Control+v inserts the current selection just before the insertion cursor.
.IP [10]
Control+d deletes the selected characters;  an error occurs if the selection
is not in this widget.
.PP
If the text is disabled using the \fBstate\fR option, then the text's
view can still be adjusted and text in the text can still be selected,
but no insertion cursor will be displayed and no text modifications will
take place.
.PP
The behavior of texts can be changed by defining new bindings for
individual widgets or by redefining the class bindings.

.SH "PERFORMANCE ISSUES"
.PP
Text widgets should run efficiently under a variety
of conditions.  The text widget uses about 2-3 bytes of
main memory for each byte of text, so texts containing a megabyte
or more should be practical on most workstations.
Text is represented internally with a modified B-tree structure
that makes operations relatively efficient even with large texts.
Tags are included in the B-tree structure in a way that allows
tags to span large ranges or have many disjoint smaller ranges
without loss of efficiency.
Marks are also implemented in a way that allows large numbers of
marks.
The only known mode of operation where a text widget may not run
efficiently is if it has a very large number of different tags.
Hundreds of tags should be fine, or even a thousand,
but tens of thousands of tags will make texts consume a lot of
memory and run slowly.

.SH KEYWORDS
text, widget
