/* 
 * Mach Operating System
 * Copyright (c) 1991 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon 
 * the rights to redistribute these changes.
 */
/*
 *
 * HISTORY
 * $Log:	bcopy.c,v $
 * Revision 2.2  91/07/09  23:24:03  danner
 * 	Additions.
 * 	[91/07/08  23:01:44  danner]
 * 
 *
 */

/* 
   This version calls out to memcpy if the regions do not overlap, 
   which we assume the compiler provides and is fast. This is true
   of gcc.
*/

void bcopy(from,to,len)
register char *from, *to;
register unsigned int len;
{
  /* LOGIC - if to+len < from and to < from then there is no overlap, 
             so use memcpy. 
             Similarly if  from+len < to and from < to, there is no overlap.
   
	     If from < to and from+len >= to, then we need to copy tailwise.
             If to < from and to+len > from,  then we need to copy headwise.

             Assuming  pointers can be coerced to unsigned ints. 
  */

  if (to==from || len==0) 
       return;

  if (((unsigned int) to) < ((unsigned int) from))
    {
      if (len < from-to)
         memcpy(to,from,len); /* Memcpy reverses arguments */
      else  /* to < from, to+len >= from  -> headwise copy */
         { 
           register int i;
           for (i=0; i<len; i++)
             to[i] = from[i];
         }
    }
  else /* to > from */
   {
      if (len < to-from)
         memcpy(to,from,len); /* Memcpy reverses arguments */
      else /* from < to, from+len >= to  -> tailwise copy */
        {
          register int i;
	  for (i=len-1; i>=0; i--)
            to[i] = from[i];
        }
   }
   return;
}
